/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.fast.template;

import java.util.HashSet;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.layout.Renderer;
import org.pentaho.reporting.engine.classic.core.layout.StreamingRenderer;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessor;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.FastExportTemplate;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.DynamicStyleKey;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.FastExportTemplateListener;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.TemplatingOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SheetLayout;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableLayoutProducer;
import org.pentaho.reporting.engine.classic.core.states.DefaultPerformanceMonitorContext;

public class FastSheetLayoutProducer
implements FastExportTemplate {
    private OutputProcessorMetaData metaData;
    private SheetLayout sharedSheetLayout;
    private HashSet<DynamicStyleKey> processedBands;

    public FastSheetLayoutProducer(SheetLayout sharedSheetLayout) {
        this.sharedSheetLayout = sharedSheetLayout;
        this.processedBands = new HashSet();
    }

    @Override
    public void write(Band band, ExpressionRuntime runtime) throws InvalidReportStateException {
        DynamicStyleKey dynamicStyleKey = DynamicStyleKey.create(band, runtime);
        if (this.processedBands.contains(dynamicStyleKey)) {
            return;
        }
        try {
            LayoutProducer templateListener = new LayoutProducer(this.metaData, this.sharedSheetLayout);
            TemplatingOutputProcessor op = new TemplatingOutputProcessor(runtime.getProcessingContext().getOutputProcessorMetaData(), templateListener);
            FastSheetLayoutProducer.performLayout(band, runtime, op);
            this.processedBands.add(dynamicStyleKey);
        }
        catch (ContentProcessingException e) {
            throw new InvalidReportStateException();
        }
        catch (ReportProcessingException e) {
            throw new InvalidReportStateException();
        }
    }

    @Override
    public void initialize(ReportDefinition reportDefinition, ExpressionRuntime runtime, boolean pagination) {
        this.metaData = runtime.getProcessingContext().getOutputProcessorMetaData();
    }

    @Override
    public void finishReport() {
        this.sharedSheetLayout.pageCompleted();
    }

    public static void performLayout(Band band, ExpressionRuntime runtime, OutputProcessor outputTarget) throws ReportProcessingException, ContentProcessingException {
        StreamingRenderer renderer = new StreamingRenderer(outputTarget);
        renderer.startReport(band.getReportDefinition(), runtime.getProcessingContext(), new DefaultPerformanceMonitorContext());
        renderer.startSection(Renderer.SectionType.NORMALFLOW);
        renderer.add(band, runtime);
        renderer.endSection();
        renderer.endReport();
        renderer.applyAutoCommit();
        if (renderer.validatePages() == Renderer.LayoutResult.LAYOUT_UNVALIDATABLE) {
            throw new ReportProcessingException("Template layout is not valid, aborting");
        }
        renderer.processPage(null, null, true);
    }

    private static class LayoutProducer
    implements FastExportTemplateListener {
        private SheetLayout sheetLayout;
        private OutputProcessorMetaData metaData;

        private LayoutProducer(OutputProcessorMetaData metaData, SheetLayout sheetLayout) {
            this.metaData = metaData;
            this.sheetLayout = sheetLayout;
        }

        @Override
        public void produceTemplate(LogicalPageBox pageBox) {
            this.sheetLayout.clearVerticalInfo();
            TableLayoutProducer currentLayout = new TableLayoutProducer(this.metaData, this.sheetLayout);
            currentLayout.update(pageBox, false);
            currentLayout.pageCompleted();
        }
    }
}

