/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.fast.template;

import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.SheetPropertySource;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.AbstractStructureVisitor;

public class SheetPropertyCollector
extends AbstractStructureVisitor
implements SheetPropertySource {
    private String sheetName;
    private String pageHeaderCenter;
    private String pageFooterCenter;
    private String pageHeaderLeft;
    private String pageFooterLeft;
    private String pageHeaderRight;
    private String pageFooterRight;
    private Integer freezeTop;
    private Integer freezeLeft;

    public String compute(Band band) {
        this.sheetName = null;
        this.traverseSection(band);
        if (this.sheetName == null) {
            for (Section parentSection = band.getParentSection(); parentSection != null; parentSection = parentSection.getParentSection()) {
                this.inspectElement(parentSection);
            }
        }
        return this.sheetName;
    }

    @Override
    protected void traverseSection(Section section) {
        this.traverseSectionWithoutSubReports(section);
    }

    @Override
    protected void inspectElement(ReportElement element) {
        if (this.sheetName != null) {
            return;
        }
        Object styleProperty = element.getComputedStyle().getStyleProperty(BandStyleKeys.COMPUTED_SHEETNAME);
        if (styleProperty != null) {
            this.sheetName = String.valueOf(styleProperty);
        }
        this.pageHeaderCenter = this.lookup(element, "page-header-center", this.pageHeaderCenter);
        this.pageHeaderLeft = this.lookup(element, "page-header-left", this.pageHeaderLeft);
        this.pageHeaderRight = this.lookup(element, "page-header-right", this.pageHeaderRight);
        this.pageFooterCenter = this.lookup(element, "page-footer-center", this.pageFooterCenter);
        this.pageFooterLeft = this.lookup(element, "page-footer-left", this.pageFooterLeft);
        this.pageFooterRight = this.lookup(element, "page-footer-right", this.pageFooterRight);
        Integer freezeTop = (Integer)element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/excel", "freezing-top-position");
        if (this.freezeTop == null && freezeTop != null) {
            this.freezeTop = freezeTop;
        }
        Integer freezeLeft = (Integer)element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/excel", "freezing-left-position");
        if (this.freezeLeft == null && freezeLeft != null) {
            this.freezeLeft = freezeLeft;
        }
    }

    @Override
    public int getFreezeTop() {
        if (this.freezeTop == null) {
            return 0;
        }
        return this.freezeTop;
    }

    @Override
    public int getFreezeLeft() {
        if (this.freezeLeft == null) {
            return 0;
        }
        return this.freezeLeft;
    }

    @Override
    public String getPageHeaderCenter() {
        return this.pageHeaderCenter;
    }

    @Override
    public String getPageFooterCenter() {
        return this.pageFooterCenter;
    }

    @Override
    public String getPageHeaderLeft() {
        return this.pageHeaderLeft;
    }

    @Override
    public String getPageFooterLeft() {
        return this.pageFooterLeft;
    }

    @Override
    public String getPageHeaderRight() {
        return this.pageHeaderRight;
    }

    @Override
    public String getPageFooterRight() {
        return this.pageFooterRight;
    }

    private String lookup(ReportElement box, String attribute, String defaultValue) {
        Object value = box.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/excel", attribute);
        if (value != null && defaultValue == null) {
            return String.valueOf(value);
        }
        return defaultValue;
    }
}

