/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cgg;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.servlet.http.HttpServletResponse;
import pt.webdetails.cgg.AbstractCgg;
import pt.webdetails.cgg.Chart;
import pt.webdetails.cgg.ScriptExecuteException;
import pt.webdetails.cgg.SetResponseHeaderDelegate;
import pt.webdetails.cgg.datasources.WebDataSourceFactory;
import pt.webdetails.cgg.output.OutputHandler;
import pt.webdetails.cgg.scripts.JCRScriptFactory;
import pt.webdetails.cgg.scripts.ScriptFactory;

public class WebCgg
extends AbstractCgg {
    private HttpServletResponse servletResponse;
    private OutputStream out;
    private SetResponseHeaderDelegate delegate;

    public WebCgg(URL context, HttpServletResponse servletResponse, OutputStream out, SetResponseHeaderDelegate delegate) {
        this.servletResponse = servletResponse;
        this.out = out;
        this.delegate = delegate;
        this.setDataSourceFactory(new WebDataSourceFactory());
        this.setScriptFactory((ScriptFactory)new JCRScriptFactory(context.getPath()));
    }

    protected void produceOutput(Chart chart, String requestedOutputHandler) throws IOException, ScriptExecuteException {
        OutputHandler cggOutputHandler = this.getOutputFactory().create(requestedOutputHandler);
        if (this.servletResponse != null) {
            this.servletResponse.setContentType(cggOutputHandler.getMimeType());
            this.servletResponse.setHeader("Cache-Control", "max-age=0, no-store");
        }
        this.delegate.setResponseHeader(cggOutputHandler.getMimeType());
        cggOutputHandler.render(this.out, chart);
    }

    public void refresh() {
        this.getScriptFactory().clearCachedScopes();
    }
}

