/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mongo.wrapper;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.steps.mongodb.MongoDbMeta;
import org.pentaho.mongo.wrapper.KerberosInvocationHandler;
import org.pentaho.mongo.wrapper.KerberosMongoClientWrapper;
import org.pentaho.mongo.wrapper.MongoClientWrapper;
import org.pentaho.mongo.wrapper.NoAuthMongoClientWrapper;
import org.pentaho.mongo.wrapper.UsernamePasswordMongoClientWrapper;

public class MongoClientWrapperFactory {
    public static MongoClientWrapper createMongoClientWrapper(MongoDbMeta meta, VariableSpace vars, LogChannelInterface log) throws KettleException {
        if (meta.getUseKerberosAuthentication()) {
            KerberosMongoClientWrapper wrapper = new KerberosMongoClientWrapper(meta, vars, log);
            return (MongoClientWrapper)Proxy.newProxyInstance(wrapper.getClass().getClassLoader(), new Class[]{MongoClientWrapper.class}, (InvocationHandler)new KerberosInvocationHandler(wrapper.getAuthContext(), wrapper));
        }
        if (!Const.isEmpty((String)meta.getAuthenticationUser()) || !Const.isEmpty((String)meta.getAuthenticationPassword())) {
            return new UsernamePasswordMongoClientWrapper(meta, vars, log);
        }
        return new NoAuthMongoClientWrapper(meta, vars, log);
    }
}

