/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cdf.dd.ICdeEnvironment;
import pt.webdetails.cdf.dd.InitializationException;
import pt.webdetails.cdf.dd.bean.factory.CoreBeanFactory;
import pt.webdetails.cdf.dd.bean.factory.ICdeBeanFactory;
import pt.webdetails.cdf.dd.util.CdeEnvironment;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.repository.api.IRWAccess;
import pt.webdetails.cpf.repository.api.IReadAccess;

public class CdeEngine {
    private static CdeEngine instance;
    protected static Log logger;
    private ICdeEnvironment cdeEnv;

    private CdeEngine() {
        logger.debug((Object)"Starting ElementEngine");
    }

    private CdeEngine(ICdeEnvironment environment) {
        this();
        this.cdeEnv = environment;
    }

    public static CdeEngine getInstance() {
        if (instance == null) {
            instance = new CdeEngine();
            try {
                CdeEngine.initialize();
            }
            catch (Exception ex) {
                logger.fatal((Object)("Error initializing CdeEngine: " + Util.getExceptionDescription((Exception)ex)));
            }
        }
        return instance;
    }

    public ICdeEnvironment getEnvironment() {
        return CdeEngine.getInstance().cdeEnv;
    }

    private static void initialize() throws InitializationException {
        if (CdeEngine.instance.cdeEnv == null) {
            CoreBeanFactory factory = new CoreBeanFactory();
            ICdeEnvironment env = instance.getConfiguredEnvironment(factory);
            if (env != null) {
                env.init(factory);
            }
            CdeEngine.instance.cdeEnv = env;
            instance.ensureBasicDirs();
        }
    }

    public void ensureBasicDirs() {
        IRWAccess repoBase = CdeEnvironment.getPluginRepositoryWriter();
        if (!this.ensureDirExists(repoBase, "components")) {
            logger.error((Object)"Couldn't find or create CDE components dir.");
        }
        if (!this.ensureDirExists(repoBase, "styles")) {
            logger.error((Object)"Couldn't find or create CDE styles dir.");
        }
        if (!this.ensureDirExists(repoBase, "templates")) {
            logger.error((Object)"Couldn't find or create CDE templates dir.");
        }
        if (!repoBase.fileExists("widgets")) {
            if (!this.ensureDirExists(repoBase, "widgets")) {
                logger.error((Object)"Couldn't find or create CDE widgets dir.");
            } else {
                IReadAccess sysPluginSamples = CdeEnvironment.getPluginSystemReader("resources/samples/");
                this.saveAndClose(repoBase, Util.joinPath((String[])new String[]{"widgets", "sample.cdfde"}), sysPluginSamples, "widget.cdfde");
                this.saveAndClose(repoBase, Util.joinPath((String[])new String[]{"widgets", "sample.wcdf"}), sysPluginSamples, "widget.wcdf");
                this.saveAndClose(repoBase, Util.joinPath((String[])new String[]{"widgets", "sample.cda"}), sysPluginSamples, "widget.cda");
                this.saveAndClose(repoBase, Util.joinPath((String[])new String[]{"widgets", "sample.component.xml"}), sysPluginSamples, "widget.xml");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveAndClose(IRWAccess writer, String fileOut, IReadAccess reader, String fileIn) {
        InputStream input = null;
        try {
            input = reader.getFileInputStream(fileIn);
            boolean bl = CdeEngine.getEnv().getFileHandler().createBasicFileIfNotExists(writer, fileOut, input);
            return bl;
        }
        catch (IOException e) {
            logger.error((Object)("Couldn't read " + fileIn + " in " + reader));
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
        return false;
    }

    private boolean ensureDirExists(IRWAccess access, String relPath) {
        return CdeEngine.getEnv().getFileHandler().createBasicDirIfNotExists(access, relPath);
    }

    public static ICdeEnvironment getEnv() {
        return CdeEngine.getInstance().getEnvironment();
    }

    protected synchronized ICdeEnvironment getConfiguredEnvironment(ICdeBeanFactory factory) throws InitializationException {
        Object obj = new CoreBeanFactory().getBean(ICdeEnvironment.class.getSimpleName());
        if (obj != null && obj instanceof ICdeEnvironment) {
            return (ICdeEnvironment)obj;
        }
        String msg = "No bean found for ICdeEnvironment!!";
        logger.fatal((Object)msg);
        throw new InitializationException(msg, null);
    }

    static {
        logger = LogFactory.getLog(CdeEngine.class);
    }
}

