/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd;

import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cdf.dd.CdeEngine;

public class ResourceManager {
    private static final Log logger = LogFactory.getLog(ResourceManager.class);
    public static ResourceManager instance;
    private static final HashSet<String> CACHEABLE_EXTENSIONS;
    private static final HashMap<String, String> cacheContainer;
    private boolean isCacheEnabled = true;

    public ResourceManager() {
        CACHEABLE_EXTENSIONS.add("html");
        CACHEABLE_EXTENSIONS.add("json");
        CACHEABLE_EXTENSIONS.add("cdfde");
        this.isCacheEnabled = Boolean.parseBoolean(CdeEngine.getInstance().getEnvironment().getResourceLoader().getPluginSetting(this.getClass(), "pentaho-cdf-dd/enable-cache"));
    }

    public static ResourceManager getInstance() {
        if (instance == null) {
            instance = new ResourceManager();
        }
        return instance;
    }

    public boolean existsInCache(String cacheKey) {
        return this.isCacheEnabled && !StringUtils.isEmpty((String)cacheKey) && cacheContainer.containsKey(cacheKey);
    }

    public boolean existsInCache(String path, HashMap<String, String> tokens) {
        String extension = ResourceManager.getResourceExtension(path);
        String cacheKey = ResourceManager.buildCacheKey(path, tokens);
        return this.isCacheEnabled && CACHEABLE_EXTENSIONS.contains(extension) && cacheContainer.containsKey(cacheKey);
    }

    public boolean isCacheEnabled() {
        return this.isCacheEnabled;
    }

    public boolean isCacheableExtension(String extension) {
        return extension != null && CACHEABLE_EXTENSIONS.contains(extension);
    }

    public boolean putResourceInCache(String key, String resource) {
        boolean success = false;
        if (this.isCacheEnabled()) {
            cacheContainer.put(key, resource);
            success = true;
        }
        return success;
    }

    public String getResourceFromCache(String key) {
        if (this.isCacheEnabled() && cacheContainer.containsKey(key)) {
            return cacheContainer.get(key);
        }
        return null;
    }

    public static String buildCacheKey(String path, HashMap<String, String> tokens) {
        StringBuilder keyBuilder = new StringBuilder(path);
        if (tokens != null) {
            keyBuilder.append(tokens.hashCode());
        }
        return keyBuilder.toString();
    }

    public static String getResourceExtension(String path) {
        return path.substring(path.lastIndexOf(46) + 1);
    }

    static {
        CACHEABLE_EXTENSIONS = new HashSet();
        cacheContainer = new HashMap();
    }
}

