/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.datasources;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.model.beans.NullPointer;
import org.apache.commons.lang.StringUtils;
import pt.webdetails.cdf.dd.DashboardManager;
import pt.webdetails.cdf.dd.util.XPathUtils;

public class CdaDataSourceReader {
    public static List<CdaDataSource> getCdaDataSources(String dashboard) {
        JXPathContext context;
        try {
            context = DashboardManager.openDashboardAsJXPathContext(dashboard, null);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        return CdaDataSourceReader.getCdaDataSources(context);
    }

    protected static List<CdaDataSource> getCdaDataSources(JXPathContext docContext) {
        ArrayList<CdaDataSource> dataSources = new ArrayList<CdaDataSource>();
        Iterator extDataSources = docContext.iteratePointers("/datasources/rows[properties/name='dataAccessId']");
        while (extDataSources.hasNext()) {
            Pointer source = (Pointer)extDataSources.next();
            if (source instanceof NullPointer) continue;
            dataSources.add(new CdaDataSource(docContext.getRelativeContext(source)));
        }
        Iterator builtInDataSources = docContext.iteratePointers("/datasources/rows[meta='CDA']");
        if (builtInDataSources.hasNext()) {
            String fileName = XPathUtils.getStringValue(docContext, "/filename");
            String toReplace = ".cdfde";
            String replaceWith = ".cda";
            if (StringUtils.endsWith((String)fileName, (String)".wcdf")) {
                toReplace = ".wcdf";
            }
            fileName = StringUtils.replace((String)fileName, (String)toReplace, (String)replaceWith);
            dataSources.add(new CdaDataSource(fileName, null));
        }
        return dataSources;
    }

    public static class CdaDataSource {
        String cdaSettings;
        String dataAccessId;

        CdaDataSource(JXPathContext dataSourceContext) {
            this(dataSourceContext, null);
        }

        CdaDataSource(JXPathContext dataSourceContext, String cdaSettings) {
            this.dataAccessId = XPathUtils.getStringValue(dataSourceContext, "properties/value[../name='name']");
            this.cdaSettings = cdaSettings != null ? cdaSettings : (XPathUtils.exists(dataSourceContext, "properties/value[../name='cdaPath']") ? XPathUtils.getStringValue(dataSourceContext, "properties/value[../name='cdaPath']") : XPathUtils.getStringValue(dataSourceContext, "properties/value[../name='solution']") + '/' + XPathUtils.getStringValue(dataSourceContext, "properties/value[../name='path']") + '/' + XPathUtils.getStringValue(dataSourceContext, "properties/value[../name='file']"));
        }

        public CdaDataSource(String cdaSettings, String dataAccessId) {
            this.cdaSettings = cdaSettings;
            this.dataAccessId = dataAccessId;
        }

        public String toString() {
            return "{cdaSettingsId:'" + this.cdaSettings + "'" + (this.dataAccessId != null ? ", dataAccessId:'" + this.dataAccessId + "'" : "") + "}";
        }
    }
}

