/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.editor;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cdf.dd.CdeEngine;
import pt.webdetails.cdf.dd.ResourceManager;
import pt.webdetails.cdf.dd.extapi.ICdeApiPathProvider;
import pt.webdetails.cdf.dd.render.DependenciesManager;
import pt.webdetails.cdf.dd.structure.DashboardWcdfDescriptor;
import pt.webdetails.cdf.dd.util.CdeEnvironment;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.context.api.IUrlProvider;
import pt.webdetails.cpf.repository.api.IReadAccess;

public class DashboardEditor {
    private static Log logger = LogFactory.getLog(DashboardEditor.class);
    private static final String WEBAPP_PATH = "#{WEBAPP_PATH}";

    public static String getEditor(String wcdfPath, boolean debugMode, String scheme, boolean isDefault) throws Exception {
        ResourceManager resMgr = ResourceManager.getInstance();
        IReadAccess sysReader = CdeEnvironment.getPluginSystemReader();
        HashMap<String, String> tokens = DashboardEditor.buildReplacementTokenMap(wcdfPath, scheme, debugMode, resMgr, sysReader);
        return DashboardEditor.getProcessedEditor(wcdfPath, resMgr, tokens, sysReader, isDefault);
    }

    private static HashMap<String, String> buildReplacementTokenMap(String wcdfPath, String scheme, boolean debugMode, ResourceManager resMgr, IReadAccess sysReader) throws IOException {
        DependenciesManager depMgr = DependenciesManager.getInstance();
        HashMap<String, String> tokens = new HashMap<String, String>();
        String scriptDeps = debugMode ? DashboardEditor.getResource(resMgr, sysReader, "resources/scripts.html") : depMgr.getPackage("scripts").getDependencies(true);
        String styleDeps = debugMode ? DashboardEditor.getResource(resMgr, sysReader, "resources/styles.html") : depMgr.getPackage("styles").getDependencies(true);
        String cdeDeps = depMgr.getPackage("CDFDD").getDependencies(debugMode);
        tokens.put("@HEADER@", cdeDeps);
        tokens.put("@STYLES@", styleDeps);
        tokens.put("@SCRIPTS@", scriptDeps);
        try {
            String cdfDeps = CdeEngine.getEnv().getCdfIncludes("empty", "blueprint", debugMode, false, null, scheme);
            tokens.put("@CDF@", cdfDeps);
        }
        catch (Exception e) {
            logger.fatal((Object)"Unable to get CDF dependencies", (Throwable)e);
        }
        tokens.put("@FILENAME@", DashboardWcdfDescriptor.toStructurePath(wcdfPath));
        IUrlProvider urlProvider = CdeEngine.getEnv().getPluginEnv().getUrlProvider();
        String apiPath = urlProvider.getPluginBaseUrl();
        tokens.put("@SERVERURL@", apiPath);
        ICdeApiPathProvider extApi = CdeEngine.getEnv().getExtApi();
        tokens.put("@DATAURL@", CdeEngine.getInstance().getEnvironment().getApplicationBaseContentUrl() + "Syncronize");
        tokens.put("@CDE_RENDERER_API@", extApi.getRendererBasePath());
        return tokens;
    }

    private static String getProcessedEditor(String wcdfPath, ResourceManager resMgr, HashMap<String, String> tokens, IReadAccess sysReader, boolean isDefault) throws IOException {
        String editorPage;
        String cacheKey = ResourceManager.buildCacheKey(wcdfPath, tokens);
        if (resMgr.existsInCache(cacheKey)) {
            editorPage = resMgr.getResourceFromCache(cacheKey);
        } else {
            editorPage = isDefault ? Util.toString((InputStream)sysReader.getFileInputStream("resources/cdf-dd-default.html")) : Util.toString((InputStream)sysReader.getFileInputStream("resources/cdf-dd.html"));
            if (tokens != null && tokens.size() > 0) {
                for (String key : tokens.keySet()) {
                    editorPage = StringUtils.replace((String)editorPage, (String)key, (String)tokens.get(key));
                }
            }
            if (resMgr.isCacheEnabled()) {
                resMgr.putResourceInCache(cacheKey, editorPage);
            }
        }
        return editorPage;
    }

    private static String getResource(ResourceManager resMgr, IReadAccess sysReader, String path) throws IOException {
        String resource;
        if (resMgr.existsInCache(path)) {
            resource = resMgr.getResourceFromCache(path);
        } else {
            resource = Util.toString((InputStream)sysReader.getFileInputStream(path));
            if (resource != null) {
                resMgr.putResourceInCache(path, resource);
            }
        }
        if (resource.contains(WEBAPP_PATH)) {
            return resource.replace(WEBAPP_PATH, CdeEngine.getInstance().getEnvironment().getApplicationReposUrl() + CdeEngine.getInstance().getEnvironment().getPluginId() + "/");
        }
        return resource;
    }
}

