/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.localization;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cdf.dd.CdeEngine;
import pt.webdetails.cdf.dd.util.CdeEnvironment;
import pt.webdetails.cdf.dd.util.Utils;
import pt.webdetails.cpf.repository.api.IBasicFile;
import pt.webdetails.cpf.repository.api.IRWAccess;
import pt.webdetails.cpf.repository.api.IReadAccess;
import pt.webdetails.cpf.repository.api.IUserContentAccess;

public class MessageBundlesHelper {
    private static final Log logger = LogFactory.getLog(MessageBundlesHelper.class);
    public static final String SYSTEM_PLUGIN_GLOBAL_LANGUAGES_DIR = "lang";
    public static final String BASE_GLOBAL_MESSAGE_SET_FILENAME = "messages";
    public static final String BASE_CACHE_DIR = "tmp/.cache";
    private IBasicFile globalBaseMessageFile;
    private IBasicFile targetDashboardBaseMsgFile;
    private IBasicFile globalMsgCacheFile;
    private IBasicFile sourceDashboardBaseMsgFile;
    private String languagesCacheUrl;
    private String msgsRelativeDir;
    private String staticBaseContentUrl = CdeEngine.getEnv().getExtApi().getPluginStaticBaseUrl();

    public MessageBundlesHelper(String msgsRelativeDir, IBasicFile sourceDashboardBaseMsgFile) {
        if (StringUtils.isEmpty((String)msgsRelativeDir)) {
            this.msgsRelativeDir = String.valueOf('/');
        } else if (!msgsRelativeDir.startsWith(String.valueOf('/'))) {
            this.msgsRelativeDir = String.valueOf('/') + msgsRelativeDir;
        }
        this.sourceDashboardBaseMsgFile = sourceDashboardBaseMsgFile;
        this.languagesCacheUrl = Utils.joinPath(this.staticBaseContentUrl, BASE_CACHE_DIR, msgsRelativeDir);
    }

    protected IBasicFile getGlobalBaseMessageFile() {
        if (this.globalBaseMessageFile == null) {
            this.globalBaseMessageFile = CdeEnvironment.getPluginSystemReader(SYSTEM_PLUGIN_GLOBAL_LANGUAGES_DIR).fetchFile("messages.properties");
        }
        return this.globalBaseMessageFile;
    }

    protected IBasicFile getTargetDashboardBaseMessageFile() {
        if (this.targetDashboardBaseMsgFile == null) {
            String msg;
            IReadAccess systemReader = CdeEnvironment.getPluginSystemReader(Utils.joinPath(BASE_CACHE_DIR, this.msgsRelativeDir));
            String string = msg = this.sourceDashboardBaseMsgFile != null ? this.sourceDashboardBaseMsgFile.getName() : "messages.properties";
            if (systemReader.fileExists(msg)) {
                this.targetDashboardBaseMsgFile = systemReader.fetchFile(msg);
            }
        }
        return this.targetDashboardBaseMsgFile;
    }

    protected IBasicFile getGlobalMsgCacheFile() {
        String msg;
        IReadAccess systemReader;
        if (this.globalMsgCacheFile == null && (systemReader = CdeEnvironment.getPluginSystemReader(Utils.joinPath(BASE_CACHE_DIR, this.msgsRelativeDir))).fileExists(msg = "messages.properties")) {
            this.globalMsgCacheFile = systemReader.fetchFile(msg);
        }
        return this.globalMsgCacheFile;
    }

    public void saveI18NMessageFilesToCache() {
        if (!CdeEnvironment.getPluginSystemReader(BASE_CACHE_DIR).fileExists(this.msgsRelativeDir)) {
            CdeEnvironment.getPluginSystemWriter().createFolder(Utils.joinPath(BASE_CACHE_DIR, this.msgsRelativeDir));
        }
        try {
            this.copyStdGlobalMessageFileToCache();
            this.appendMessageFiles(this.sourceDashboardBaseMsgFile, this.getGlobalBaseMessageFile(), this.getTargetDashboardBaseMessageFile());
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
    }

    public String getMessageFilesCacheUrl() {
        return FilenameUtils.separatorsToUnix((String)FilenameUtils.normalize((String)this.languagesCacheUrl));
    }

    protected void appendMessageFiles(IBasicFile sourceDashboardBaseMsgFile, IBasicFile globalBaseMessageFile, IBasicFile targetDashboardBaseMsgFile) throws IOException {
        Locale locale = CdeEngine.getEnv().getLocale();
        IUserContentAccess userContentAccess = CdeEngine.getEnv().getContentAccessFactory().getUserContentAccess(this.msgsRelativeDir);
        IRWAccess systemWriter = CdeEngine.getEnv().getContentAccessFactory().getPluginSystemWriter(Utils.joinPath(BASE_CACHE_DIR, this.msgsRelativeDir));
        String localizedMsgGlobalName = "messages_" + locale.getLanguage() + ".properties";
        if (userContentAccess.fileExists(localizedMsgGlobalName)) {
            systemWriter.saveFile(localizedMsgGlobalName, userContentAccess.getFileInputStream(localizedMsgGlobalName));
        } else if (globalBaseMessageFile != null) {
            systemWriter.saveFile(localizedMsgGlobalName, globalBaseMessageFile.getContents());
        }
        if (sourceDashboardBaseMsgFile != null) {
            systemWriter.saveFile(sourceDashboardBaseMsgFile.getName(), sourceDashboardBaseMsgFile.getContents());
            String localizedMsgTargetName = FilenameUtils.getBaseName((String)sourceDashboardBaseMsgFile.getName()) + "_" + locale.getLanguage() + ".properties";
            if (userContentAccess.fileExists(localizedMsgTargetName)) {
                systemWriter.saveFile(localizedMsgTargetName, userContentAccess.getFileInputStream(localizedMsgTargetName));
            }
        }
    }

    protected void copyStdGlobalMessageFileToCache() throws IOException {
        IBasicFile globalMsgCacheFile = this.getGlobalMsgCacheFile();
        if (globalMsgCacheFile != null && globalMsgCacheFile.getContents() != null) {
            return;
        }
        String globalMsgFileName = "messages.properties";
        IBasicFile globalMsgFile = CdeEnvironment.getPluginSystemReader(SYSTEM_PLUGIN_GLOBAL_LANGUAGES_DIR).fetchFile(globalMsgFileName);
        CdeEnvironment.getPluginSystemWriter().saveFile(Utils.joinPath(BASE_CACHE_DIR, this.msgsRelativeDir, globalMsgFileName), globalMsgFile.getContents());
    }

    public String replaceParameters(String text, ArrayList<String> i18nTagsList) throws Exception {
        if (i18nTagsList == null) {
            i18nTagsList = new ArrayList();
        }
        this.saveI18NMessageFilesToCache();
        String dashboardsMessagesBaseFilename = this.sourceDashboardBaseMsgFile != null ? FilenameUtils.getBaseName((String)this.sourceDashboardBaseMsgFile.getName()) : BASE_GLOBAL_MESSAGE_SET_FILENAME;
        text = text.replaceAll("\\{load\\}", "onload=\"load()\"");
        text = text.replaceAll("\\{body-tag-unload\\}", "");
        text = text.replaceAll("#\\{GLOBAL_MESSAGE_SET_NAME\\}", dashboardsMessagesBaseFilename);
        text = text.replaceAll("#\\{GLOBAL_MESSAGE_SET_PATH\\}", this.getMessageFilesCacheUrl());
        text = text.replaceAll("#\\{GLOBAL_MESSAGE_SET\\}", this.buildMessageSetCode(i18nTagsList));
        text = text.replaceAll("#\\{LANGUAGE_CODE\\}", CdeEngine.getEnv().getLocale().getLanguage());
        return text;
    }

    private String buildMessageSetCode(ArrayList<String> tagsList) {
        StringBuffer messageCodeSet = new StringBuffer();
        for (String tag : tagsList) {
            messageCodeSet.append("\\$('#").append(this.updateSelectorName(tag)).append("').html(jQuery.i18n.prop('").append(tag).append("'));\n");
        }
        return messageCodeSet.toString();
    }

    private String updateSelectorName(String name) {
        return name.replace(".", "_");
    }
}

