/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.core.writer.js;

import org.apache.commons.lang.StringUtils;

public abstract class JsWriterAbstract {
    protected static final String INDENT1 = "\t";
    protected static final String INDENT2 = "\t\t";
    protected static final String INDENT3 = "\t\t\t";
    protected static final String INDENT4 = "\t\t\t\t";
    protected static final String NEWLINE = System.getProperty("line.separator");

    protected static void addCommaAndLineSep(StringBuilder out) {
        out.append(",");
        out.append(NEWLINE);
    }

    protected static void addVar(StringBuilder out, String name, String value) {
        out.append("var ");
        JsWriterAbstract.addAssignmentWithOr(out, name, value);
    }

    protected static void addAssignmentWithOr(StringBuilder out, String name, String value) {
        out.append(name);
        out.append(" = ");
        out.append(name);
        out.append(" || ");
        out.append(value);
        out.append(";");
        out.append(NEWLINE);
    }

    protected static void addAssignment(StringBuilder out, String name, String value) {
        out.append(name);
        out.append(" = ");
        out.append(value);
        out.append(";");
        out.append(NEWLINE);
    }

    protected static void addJsProperty(StringBuilder out, String name, String jsValue, String indent) {
        JsWriterAbstract.addJsProperty(out, name, jsValue, indent, true);
    }

    protected static void addJsProperty(StringBuilder out, String name, String jsValue, String indent, boolean isFirst) {
        if (!isFirst) {
            JsWriterAbstract.addCommaAndLineSep(out);
        }
        if (StringUtils.isNotEmpty((String)indent)) {
            out.append(indent);
        }
        out.append(name);
        out.append(": ");
        out.append(jsValue);
    }

    protected static String wrapJsScriptTags(String code) {
        StringBuilder out = new StringBuilder();
        JsWriterAbstract.wrapJsScriptTags(out, code);
        return out.toString();
    }

    protected static void wrapJsScriptTags(StringBuilder out, String code) {
        out.append(NEWLINE);
        out.append("<script language=\"javascript\" type=\"text/javascript\">");
        out.append(NEWLINE);
        out.append(code);
        out.append(NEWLINE);
        out.append("</script>");
        out.append(NEWLINE);
    }
}

