/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.components;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import pt.webdetails.cdf.dd.model.core.writer.ThingWriteException;
import pt.webdetails.cdf.dd.model.inst.ParameterComponent;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.components.CdfRunJsParameterComponentWriter;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteContext;
import pt.webdetails.cdf.dd.util.JsonUtils;

public class CdfRunJsDateParameterComponentWriter
extends CdfRunJsParameterComponentWriter {
    private static final SimpleDateFormat _format = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    public void write(StringBuilder out, CdfRunJsDashboardWriteContext context, ParameterComponent comp) throws ThingWriteException {
        String name = JsonUtils.toJsString(context.getId(comp));
        String value = JsonUtils.toJsString(this.resolveDateValue(comp.tryGetPropertyValue("propertyDateValue", "")));
        Boolean isBookmarkable = "true".equalsIgnoreCase(comp.tryGetPropertyValue("bookmarkable", null));
        CdfRunJsDateParameterComponentWriter.addSetParameterAssignment(out, name, value);
        if (isBookmarkable.booleanValue()) {
            CdfRunJsDateParameterComponentWriter.addBookmarkable(out, name);
        }
    }

    private String resolveDateValue(String value) {
        if (value.equals("today")) {
            Calendar cal = Calendar.getInstance();
            return _format.format(cal.getTime());
        }
        if (value.equals("yesterday")) {
            Calendar cal = Calendar.getInstance();
            cal.add(5, -1);
            return _format.format(cal.getTime());
        }
        if (value.equals("lastWeek")) {
            Calendar cal = Calendar.getInstance();
            cal.add(5, -7);
            return _format.format(cal.getTime());
        }
        if (value.equals("lastMonth")) {
            Calendar cal = Calendar.getInstance();
            cal.add(2, -1);
            return _format.format(cal.getTime());
        }
        if (value.equals("monthStart")) {
            Calendar cal = Calendar.getInstance();
            cal.set(5, 1);
            return _format.format(cal.getTime());
        }
        if (value.equals("yearStart")) {
            Calendar cal = Calendar.getInstance();
            cal.set(2, 0);
            cal.set(5, 1);
            return _format.format(cal.getTime());
        }
        return value;
    }
}

