/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.properties;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pt.webdetails.cdf.dd.model.core.Thing;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriteContext;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriter;
import pt.webdetails.cdf.dd.model.core.writer.ThingWriteException;
import pt.webdetails.cdf.dd.model.core.writer.js.JsWriterAbstract;
import pt.webdetails.cdf.dd.model.inst.PropertyBinding;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteContext;
import pt.webdetails.cdf.dd.util.JsonUtils;

public abstract class CdfRunJsPropertyBindingWriter
extends JsWriterAbstract
implements IThingWriter {
    protected static final Pattern _wrappedFunctionPattern = Pattern.compile("(?s)\"(function\\s*\\(.*?})\"");
    protected static final Pattern _maybeWrappedFunctionValue = Pattern.compile("(\\\"|\\s)*function\\s*\\u0028.*\\u0029{1}\\s*\\u007b.*(\\u007d(\\\"|\\s)*)?|(\\\"|\\s)*function\\s*[a-zA-Z0-9\\u002d\\u005f]+\\u0028.*\\u0029{1}\\s*\\u007b.*(\\u007d(\\\"|\\s)*)?");

    @Override
    public void write(Object output, IThingWriteContext context, Thing t) throws ThingWriteException {
        this.write((StringBuilder)output, (CdfRunJsDashboardWriteContext)context, (PropertyBinding)t);
    }

    public abstract void write(StringBuilder var1, CdfRunJsDashboardWriteContext var2, PropertyBinding var3) throws ThingWriteException;

    protected String writeString(String canonicalValue) {
        return JsonUtils.toJsString(canonicalValue);
    }

    protected String writeNumber(String canonicalValue) {
        return canonicalValue;
    }

    protected String writeBoolean(String canonicalValue) {
        return canonicalValue.equals("true") ? "true" : "false";
    }

    protected String writeLiteral(String canonicalValue) {
        return canonicalValue;
    }

    protected String writeArray(String canonicalValue) {
        Matcher m = _wrappedFunctionPattern.matcher(canonicalValue);
        if (!m.find()) {
            return canonicalValue;
        }
        StringBuffer sb = new StringBuffer();
        do {
            String rep = m.group(1);
            rep = rep.replaceAll("\\\"", "\"");
            rep = rep.replaceAll("\\$", "\\\\\\$");
            rep = rep.replaceAll("\\\\n", " ").replaceAll("\\\\r", " ");
            m.appendReplacement(sb, rep);
        } while (m.find());
        m.appendTail(sb);
        return sb.toString();
    }

    protected String writeFunction(String canonicalValue) {
        Matcher matcher = _maybeWrappedFunctionValue.matcher(canonicalValue);
        if (matcher.find()) {
            return canonicalValue;
        }
        canonicalValue = canonicalValue.replace("\n", " ").replace("\r", " ");
        canonicalValue = canonicalValue.replace("\"", "\\\"");
        canonicalValue = canonicalValue.replaceAll("(\\$\\{[^}]*\\})", "\"+ $1 + \"");
        return "function() { return \"" + canonicalValue + "\"; }";
    }
}

