/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.meta.reader.cdexml.fs;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.webdetails.cdf.dd.CdeEngine;
import pt.webdetails.cdf.dd.model.core.reader.ThingReadException;
import pt.webdetails.cdf.dd.model.meta.ComponentType;
import pt.webdetails.cdf.dd.model.meta.CustomComponentType;
import pt.webdetails.cdf.dd.model.meta.MetaModel;
import pt.webdetails.cdf.dd.model.meta.PrimitiveComponentType;
import pt.webdetails.cdf.dd.model.meta.PropertyType;
import pt.webdetails.cdf.dd.model.meta.WidgetComponentType;
import pt.webdetails.cdf.dd.model.meta.reader.cdexml.XmlAdhocComponentTypeReader;
import pt.webdetails.cdf.dd.model.meta.reader.cdexml.fs.XmlFsPluginThingReaderFactory;
import pt.webdetails.cdf.dd.util.CdeEnvironment;
import pt.webdetails.cdf.dd.util.GenericBasicFileFilter;
import pt.webdetails.cdf.dd.util.Utils;
import pt.webdetails.cpf.packager.origin.PathOrigin;
import pt.webdetails.cpf.packager.origin.PluginRepositoryOrigin;
import pt.webdetails.cpf.packager.origin.RepositoryPathOrigin;
import pt.webdetails.cpf.packager.origin.StaticSystemOrigin;
import pt.webdetails.cpf.repository.api.IBasicFile;
import pt.webdetails.cpf.repository.api.IBasicFileFilter;
import pt.webdetails.cpf.repository.api.IContentAccessFactory;
import pt.webdetails.cpf.repository.api.IReadAccess;

public final class XmlFsPluginModelReader {
    public static final String RESOURCES_DIR = "resources";
    public static final String DEF_BASE_TYPE = PrimitiveComponentType.class.getSimpleName();
    public static final String BASE_DIR = Utils.joinPath("resources", "base");
    public static final String BASE_PROPS_DIR = Utils.joinPath(BASE_DIR, "properties");
    public static final String BASE_COMPS_DIR = Utils.joinPath(BASE_DIR, "components");
    public static final String DEF_CUSTOM_TYPE = CustomComponentType.class.getSimpleName();
    public static final String CUSTOM_DIR = Utils.joinPath("resources", "custom");
    public static final String CUSTOM_PROPS_DIR = Utils.joinPath(CUSTOM_DIR, "properties");
    public static final String DEF_WIDGET_STUB_TYPE = WidgetComponentType.class.getSimpleName();
    public static final String WIDGETS_DIR = "widgets";
    public static final String CUSTOM_PROPS_FILENAME = "property";
    public static final String COMPONENT_FILENAME = "component";
    public static final String DEFINITION_FILE_EXT = "xml";
    protected static final Log logger = LogFactory.getLog(XmlFsPluginModelReader.class);
    private final Boolean continueOnError;
    private IContentAccessFactory contentAccessFactory;

    public XmlFsPluginModelReader(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    public XmlFsPluginModelReader(IContentAccessFactory caf, boolean continueOnError) {
        this(false);
        this.contentAccessFactory = caf;
    }

    public MetaModel.Builder read(XmlFsPluginThingReaderFactory factory) throws ThingReadException {
        MetaModel.Builder model = new MetaModel.Builder();
        this.readBaseProperties(model, factory);
        this.readCustomProperties(model, factory);
        logger.info((Object)String.format("Loading BASE components from: %s", BASE_COMPS_DIR));
        this.readBaseComponents(model, factory);
        this.readCustomComponents(model, factory);
        this.readWidgetStubComponents(model, factory);
        return model;
    }

    private void readBaseComponents(MetaModel.Builder model, XmlFsPluginThingReaderFactory factory) throws ThingReadException {
        List filesList = CdeEnvironment.getPluginSystemReader(BASE_COMPS_DIR).listFiles(null, (IBasicFileFilter)new GenericBasicFileFilter(null, DEFINITION_FILE_EXT), -1);
        StaticSystemOrigin origin = new StaticSystemOrigin(BASE_COMPS_DIR);
        for (IBasicFile file : filesList) {
            this.readComponentsFile(model, factory, file, DEF_BASE_TYPE, (PathOrigin)origin);
        }
    }

    private void readBaseProperties(MetaModel.Builder model, XmlFsPluginThingReaderFactory factory) throws ThingReadException {
        logger.info((Object)String.format("Loading BASE properties from: %s", BASE_PROPS_DIR));
        List filesList = CdeEnvironment.getPluginSystemReader(BASE_PROPS_DIR).listFiles(null, (IBasicFileFilter)new GenericBasicFileFilter(null, DEFINITION_FILE_EXT), -1);
        if (filesList != null) {
            for (IBasicFile file : filesList) {
                this.readPropertiesFile(model, factory, file);
            }
        }
    }

    private void readCustomProperties(MetaModel.Builder model, XmlFsPluginThingReaderFactory factory) throws ThingReadException {
        logger.info((Object)String.format("Loading CUSTOM properties from: %s", CUSTOM_PROPS_DIR));
        List filesList = CdeEnvironment.getPluginSystemReader(CUSTOM_PROPS_DIR).listFiles(null, (IBasicFileFilter)new GenericBasicFileFilter(CUSTOM_PROPS_FILENAME, DEFINITION_FILE_EXT), -1);
        if (filesList != null) {
            for (IBasicFile file : filesList) {
                this.readPropertiesFile(model, factory, file);
            }
        }
    }

    private void readPropertiesFile(MetaModel.Builder model, XmlFsPluginThingReaderFactory factory, IBasicFile file) throws ThingReadException {
        Document doc;
        try {
            doc = Utils.getDocFromFile(file, null);
        }
        catch (Exception ex) {
            ThingReadException ex2 = new ThingReadException("Cannot read properties file '" + file + "'.", ex);
            if (!this.continueOnError.booleanValue()) {
                throw ex2;
            }
            logger.fatal(null, (Throwable)ex2);
            return;
        }
        List propertieElems = doc.selectNodes("//DesignerProperty");
        for (Element propertyElem : propertieElems) {
            this.readProperty(model, factory, propertyElem, file);
        }
    }

    private void readProperty(MetaModel.Builder modelBuilder, XmlFsPluginThingReaderFactory factory, Element propertyElem, IBasicFile file) {
        String className = null;
        try {
            className = Utils.getNodeText("Header/Override", (Node)propertyElem);
            if (StringUtils.isEmpty((String)className)) {
                className = "PropertyType";
            }
            PropertyType.Builder prop = factory.getPropertyTypeReader().read(propertyElem, file.getPath());
            modelBuilder.addProperty(prop);
        }
        catch (IllegalArgumentException ex) {
            if (!this.continueOnError.booleanValue()) {
                throw ex;
            }
            logger.fatal((Object)"Failed to read property ", (Throwable)ex);
        }
    }

    private void readCustomComponents(MetaModel.Builder model, XmlFsPluginThingReaderFactory factory) throws ThingReadException {
        for (PathOrigin origin : CdeEnvironment.getPluginResourceLocationManager().getCustomComponentsLocations()) {
            this.readCustomComponentsLocation(model, factory, origin);
        }
    }

    private void readCustomComponentsLocation(MetaModel.Builder model, XmlFsPluginThingReaderFactory factory, PathOrigin origin) throws ThingReadException {
        logger.info((Object)("reading custom components from " + origin));
        GenericBasicFileFilter filter = new GenericBasicFileFilter(COMPONENT_FILENAME, DEFINITION_FILE_EXT);
        IReadAccess access = origin.getReader(this.contentAccessFactory);
        List filesList = access.listFiles(null, (IBasicFileFilter)filter, -1, false, true);
        if (filesList != null) {
            logger.debug((Object)String.format("%d sub-folders found", filesList.size()));
            IBasicFile[] filesArray = filesList.toArray(new IBasicFile[0]);
            Arrays.sort(filesArray, this.getComponentFileComparator());
            for (IBasicFile file : filesList) {
                this.readComponentsFile(model, factory, file, DEF_CUSTOM_TYPE, origin);
            }
        }
    }

    private void readWidgetStubComponents(MetaModel.Builder model, XmlFsPluginThingReaderFactory factory) throws ThingReadException {
        Document doc = null;
        IBasicFile cdeXml = CdeEngine.getInstance().getEnvironment().getCdeXml();
        try {
            if (cdeXml != null) {
                doc = Utils.getDocFromFile(cdeXml, null);
            }
        }
        catch (Exception e) {
            String msg = "Cannot read components file 'cde.xml'.";
            if (!this.continueOnError.booleanValue()) {
                throw new ThingReadException(msg, e);
            }
            logger.fatal((Object)msg, (Throwable)e);
            return;
        }
        if (doc != null) {
            List widgetLocations = doc.selectNodes("//widgetsLocations//location");
            ArrayList<List> widgetsLists = new ArrayList<List>();
            String locations = "";
            for (Element location : widgetLocations) {
                try {
                    String path = location.getText().toLowerCase().replaceFirst("/", "");
                    List filesList = path.startsWith(CdeEnvironment.getSystemDir() + "/") ? CdeEnvironment.getPluginSystemReader().listFiles(location.getText(), (IBasicFileFilter)new GenericBasicFileFilter(COMPONENT_FILENAME, DEFINITION_FILE_EXT), -1, false, true) : CdeEnvironment.getUserContentAccess().listFiles(location.getText(), (IBasicFileFilter)new GenericBasicFileFilter(COMPONENT_FILENAME, DEFINITION_FILE_EXT), -1, false, true);
                    if (filesList != null) {
                        widgetsLists.add(filesList);
                    }
                    locations = locations + location.getText() + ", ";
                }
                catch (Exception e) {
                    logger.fatal((Object)("Couldn't load widgets from: " + location.getText()), (Throwable)e);
                }
            }
            logger.info((Object)String.format("Loading WIDGET components from: %s", locations));
            ArrayList<String> files = new ArrayList<String>();
            if (widgetsLists.size() > 0) {
                for (List filesList : widgetsLists) {
                    for (IBasicFile file : filesList) {
                        if (!files.contains(file.getName())) {
                            files.add(file.getName());
                            this.fixWidgetMeta(file);
                            this.readComponentsFile(model, factory, file, DEF_WIDGET_STUB_TYPE, (PathOrigin)new RepositoryPathOrigin(FilenameUtils.getPath((String)file.getPath())));
                            continue;
                        }
                        logger.debug((Object)("Duplicate widget, ignoring " + file.getPath()));
                    }
                }
            }
            return;
        }
        logger.info((Object)String.format("Loading WIDGET components from: %s", WIDGETS_DIR));
        List filesList = CdeEnvironment.getPluginRepositoryReader(WIDGETS_DIR).listFiles(null, (IBasicFileFilter)new GenericBasicFileFilter(COMPONENT_FILENAME, DEFINITION_FILE_EXT), -1, false, true);
        PluginRepositoryOrigin widgetsOrigin = new PluginRepositoryOrigin(CdeEngine.getEnv().getPluginRepositoryDir(), WIDGETS_DIR);
        if (filesList != null) {
            logger.debug((Object)String.format("%s widget components found", filesList.size()));
            IBasicFile[] filesArray = filesList.toArray(new IBasicFile[0]);
            Arrays.sort(filesArray, this.getComponentFileComparator());
            for (IBasicFile file : filesList) {
                this.readComponentsFile(model, factory, file, DEF_WIDGET_STUB_TYPE, (PathOrigin)widgetsOrigin);
            }
        }
    }

    private void fixWidgetMeta(IBasicFile componentXml) {
        Document doc = null;
        try {
            if (CdeEnvironment.getUserContentAccess().fileExists(componentXml.getPath())) {
                doc = Utils.getDocFromFile(CdeEnvironment.getUserContentAccess().fetchFile(componentXml.getPath()), null);
            } else if (CdeEnvironment.getPluginSystemReader().fileExists(componentXml.getPath())) {
                doc = Utils.getDocFromFile(CdeEnvironment.getPluginSystemReader().fetchFile(componentXml.getPath()), null);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to check meta for " + componentXml.getPath() + ", moving on"));
            return;
        }
        List wcdfMeta = doc.selectNodes("//meta[@name='wcdf']");
        String wcdfName = componentXml.getName().replace(".component.xml", ".wcdf");
        String wcdfPath = FilenameUtils.getPath((String)componentXml.getPath()) + wcdfName;
        for (Element meta : wcdfMeta) {
            String metaText = meta.getText();
            if (CdeEnvironment.getPluginSystemWriter().fileExists(metaText)) {
                wcdfPath = metaText;
            }
            if (metaText.startsWith("/") && !wcdfPath.startsWith("/")) {
                wcdfPath = "/" + wcdfPath;
            }
            if (metaText.equals(wcdfPath)) {
                logger.debug((Object)("No need to fix current wcdf meta ( " + metaText + " ) "));
                continue;
            }
            logger.debug((Object)("Fixing wcdf meta, was " + metaText + ", setting " + wcdfPath));
            meta.setText(wcdfPath);
            try {
                if (CdeEnvironment.getUserContentAccess().fileExists(componentXml.getPath())) {
                    CdeEnvironment.getUserContentAccess().saveFile(componentXml.getPath(), (InputStream)new ByteArrayInputStream(doc.asXML().getBytes()));
                    continue;
                }
                if (!CdeEnvironment.getPluginSystemWriter().fileExists(componentXml.getPath())) continue;
                CdeEnvironment.getPluginSystemWriter().saveFile(componentXml.getPath(), (InputStream)new ByteArrayInputStream(doc.asXML().getBytes()));
            }
            catch (Exception e) {
                logger.error((Object)("Unable to fix meta for " + componentXml.getName() + ", moving on"));
            }
        }
    }

    private Comparator<IBasicFile> getComponentFileComparator() {
        return new Comparator<IBasicFile>(){

            @Override
            public int compare(IBasicFile file1, IBasicFile file2) {
                return file1.getFullPath().toLowerCase().compareTo(file2.getFullPath().toLowerCase());
            }
        };
    }

    private void readComponentsFile(MetaModel.Builder model, XmlFsPluginThingReaderFactory factory, IBasicFile file, String defaultClassName, PathOrigin origin) throws ThingReadException {
        Document doc;
        try {
            doc = Utils.getDocFromFile(file, null);
        }
        catch (Exception ex) {
            String msg = "Cannot read components file '" + file.getFullPath() + "'.";
            if (!this.continueOnError.booleanValue()) {
                throw new ThingReadException(msg, ex);
            }
            logger.fatal((Object)msg, (Throwable)ex);
            return;
        }
        List componentElems = doc.selectNodes("//DesignerComponent");
        if (logger.isDebugEnabled() && componentElems.size() > 0) {
            logger.debug((Object)String.format("\t%s [%s]", file.getPath(), componentElems.size()));
        }
        for (Element componentElem : componentElems) {
            this.readComponent(model, factory, componentElem, file.getPath(), defaultClassName, origin);
        }
    }

    private void readComponent(MetaModel.Builder model, XmlFsPluginThingReaderFactory factory, Element componentElem, String sourcePath, String defaultClassName, PathOrigin origin) throws ThingReadException {
        String className = Utils.getNodeText("Header/Override", (Node)componentElem);
        if (StringUtils.isEmpty((String)className)) {
            className = defaultClassName;
        }
        String name = Utils.getNodeText("Header/Name", (Node)componentElem);
        XmlAdhocComponentTypeReader<? extends ComponentType.Builder> reader = factory.getComponentTypeReader(className);
        if (reader == null) {
            String msg = "Failed to read component of class '" + className + "' and name " + name;
            if (!this.continueOnError.booleanValue()) {
                throw new ThingReadException(msg);
            }
            logger.fatal((Object)msg);
        }
        ComponentType.Builder comp = reader.read(componentElem, origin, sourcePath);
        comp.setOrigin(origin);
        model.addComponent(comp);
    }
}

