/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.meta.reader.datasources;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cdf.dd.model.core.reader.ThingReadException;
import pt.webdetails.cdf.dd.model.meta.DataSourceComponentType;
import pt.webdetails.cdf.dd.model.meta.MetaModel;
import pt.webdetails.cpf.packager.origin.OtherPluginStaticSystemOrigin;
import pt.webdetails.cpf.packager.origin.PathOrigin;

public final class DataSourcesModelReader {
    protected static final Log logger = LogFactory.getLog(DataSourcesModelReader.class);

    public void read(MetaModel.Builder model, JSON cdaDefs, String sourcePath) throws ThingReadException {
        assert (model != null);
        logger.info((Object)("Loading data source components of '" + sourcePath + "'"));
        JXPathContext doc = JXPathContext.newContext((Object)cdaDefs);
        Iterator pointers = doc.iteratePointers("*");
        while (pointers.hasNext()) {
            Pointer pointer = (Pointer)pointers.next();
            this.readDataSourceComponent(model, pointer, sourcePath);
        }
    }

    private void readDataSourceComponent(MetaModel.Builder model, Pointer pointer, String sourcePath) {
        DataSourceComponentType.Builder builder = new DataSourceComponentType.Builder();
        JSONObject def = (JSONObject)pointer.getNode();
        JXPathContext jctx = JXPathContext.newContext((Object)def);
        String label = (String)jctx.getValue("metadata/name");
        String dataSourceType = (String)jctx.getValue("metadata/datype");
        boolean isCPK = dataSourceType.equalsIgnoreCase("cpk");
        boolean isCDA = !isCPK;
        OtherPluginStaticSystemOrigin origin = new OtherPluginStaticSystemOrigin(isCPK ? "cpk" : "cda", "");
        builder.setOrigin((PathOrigin)origin);
        boolean isKettleOverX = isCDA && "kettle over kettleTransFromFile".equalsIgnoreCase(label);
        logger.debug((Object)String.format("\t%s", label));
        String connType = (String)jctx.getValue("metadata/conntype");
        connType = connType != null ? connType : "";
        builder.setName(pointer.asPath().replaceAll(".*name='(.*?)'.*", "$1")).setLabel(label).setTooltip(label).setCategory((String)jctx.getValue("metadata/group")).setCategoryLabel((String)jctx.getValue("metadata/groupdesc")).setSourcePath(sourcePath).addAttribute("", isCPK ? "CPK" : "CDA");
        if (isCDA) {
            builder.addAttribute("conntype", connType).addAttribute("datype", dataSourceType);
        } else if (isCPK) {
            builder.useProperty(null, "stepName").useProperty(null, "kettleOutput").addAttribute("pluginId", (String)jctx.getValue("metadata/pluginId")).addAttribute("endpoint", (String)jctx.getValue("metadata/endpoint"));
        }
        if (isCDA) {
            for (String cdaPropName : this.getCDAPropertyNames(def)) {
                if (cdaPropName.equals("id") || cdaPropName.equals("connection")) continue;
                if (cdaPropName.equals("columns")) {
                    builder.useProperty(null, "cdacolumns");
                    builder.useProperty(null, "cdacalculatedcolumns");
                    continue;
                }
                if (cdaPropName.equals("output")) {
                    builder.useProperty(null, "output");
                    builder.useProperty(null, "outputMode");
                    continue;
                }
                if (cdaPropName.equals("left")) {
                    builder.useProperty(null, "left");
                    builder.useProperty(null, "leftkeys");
                    continue;
                }
                if (cdaPropName.equals("right")) {
                    builder.useProperty(null, "right");
                    builder.useProperty(null, "rightkeys");
                    continue;
                }
                if (isKettleOverX && cdaPropName.equalsIgnoreCase("query")) {
                    builder.useProperty(cdaPropName, "kettleQuery");
                    continue;
                }
                builder.useProperty(null, cdaPropName);
            }
        }
        model.addComponent(builder);
    }

    private List<String> getCDAPropertyNames(JSONObject def) {
        JSONObject dataaccess;
        ArrayList<String> props = new ArrayList<String>();
        JXPathContext context = JXPathContext.newContext((Object)def);
        JSONObject connection = (JSONObject)context.getValue("definition/connection", JSONObject.class);
        if (connection != null) {
            Set keys = connection.keySet();
            props.addAll(keys);
        }
        if ((dataaccess = (JSONObject)context.getValue("definition/dataaccess", JSONObject.class)) != null) {
            Set keys = dataaccess.keySet();
            props.addAll(keys);
        }
        return props;
    }
}

