/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.render.layout;

import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cdf.dd.render.Renderer;
import pt.webdetails.cdf.dd.util.PropertyBag;
import pt.webdetails.cdf.dd.util.XPathUtils;

public abstract class Render {
    private JXPathContext node;
    protected static final Log logger = LogFactory.getLog(Render.class);
    private PropertyBag propertyBag = new PropertyBag();

    public Render(JXPathContext node) {
        this.node = node;
    }

    public JXPathContext getNode() {
        return this.node;
    }

    public void setNode(JXPathContext node) {
        this.node = node;
    }

    public String getPropertyBagString() {
        return this.propertyBag.getPropertiesString();
    }

    protected boolean hasProperty(String property) {
        return XPathUtils.exists(this.getNode(), "properties/value[../name='" + property + "']");
    }

    protected String getPropertyString(String property) {
        return XPathUtils.getStringValue(this.getNode(), "properties/value[../name='" + property + "']");
    }

    protected Boolean getPropertyBoolean(String property) {
        return XPathUtils.getBooleanValue(this.getNode(), "properties/value[../name='" + property + "']");
    }

    public PropertyBag getPropertyBag() {
        return this.propertyBag;
    }

    public void aliasId(String alias) {
        String id = this.propertyBag.getId();
        if (id != null) {
            this.propertyBag.addId(Renderer.aliasName(alias, id));
        }
    }

    public abstract void processProperties();

    public abstract String renderStart();

    public abstract String renderClose();
}

