/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.structure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.webdetails.cdf.dd.util.Utils;
import pt.webdetails.cpf.repository.api.IReadAccess;

public class DashboardWcdfDescriptor {
    private static final Log _logger = LogFactory.getLog(DashboardWcdfDescriptor.class);
    private String _title = "";
    private String _author;
    private String _description = "";
    private String _style;
    private String _rendererType;
    private String _path;
    private List<String> _widgetParameters = new ArrayList<String>();
    private String _widgetName;
    private boolean _isWidget;

    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put((Object)"title", (Object)this.getTitle());
        json.put((Object)"author", (Object)this.getAuthor());
        json.put((Object)"description", (Object)this.getDescription());
        json.put((Object)"style", (Object)this.getStyle());
        json.put((Object)"widgetName", (Object)this.getWidgetName());
        json.put((Object)"widget", (Object)this.isWidget());
        json.put((Object)"rendererType", (Object)this.getRendererType());
        JSONArray aWidgetParams = new JSONArray();
        for (String s : this._widgetParameters) {
            aWidgetParams.add((Object)s);
        }
        json.put((Object)"widgetParameters", (Object)aWidgetParams);
        return json;
    }

    public static DashboardWcdfDescriptor fromXml(Document wcdfDoc) {
        String widgetParams;
        DashboardWcdfDescriptor wcdf = new DashboardWcdfDescriptor();
        wcdf.setTitle(Utils.getNodeText("/cdf/title", (Node)wcdfDoc, ""));
        wcdf.setDescription(Utils.getNodeText("/cdf/description", (Node)wcdfDoc, ""));
        wcdf.setWidget(Utils.getNodeText("/cdf/widget", (Node)wcdfDoc, "").equalsIgnoreCase("true"));
        wcdf.setWidgetName(Utils.getNodeText("/cdf/widgetName", (Node)wcdfDoc, ""));
        wcdf.setAuthor(Utils.getNodeText("/cdf/author", (Node)wcdfDoc, ""));
        wcdf.setStyle(Utils.getNodeText("/cdf/style", (Node)wcdfDoc, ""));
        wcdf.setRendererType(Utils.getNodeText("/cdf/rendererType", (Node)wcdfDoc, ""));
        String string = widgetParams = wcdfDoc.selectSingleNode("/cdf/widgetParameters") != null ? wcdfDoc.selectSingleNode("/cdf/widgetParameters").getText() : "";
        if (StringUtils.isNotEmpty((String)widgetParams)) {
            wcdf.setWidgetParameters(widgetParams.split(","));
        }
        return wcdf;
    }

    public Document toXml() {
        Document doc = DocumentHelper.createDocument();
        Element cdfElem = doc.addElement("cdf");
        cdfElem.addElement("title").setText(StringUtils.defaultIfEmpty((String)this.getTitle(), (String)""));
        cdfElem.addElement("description").setText(StringUtils.defaultIfEmpty((String)this.getDescription(), (String)""));
        cdfElem.addElement("author").setText(StringUtils.defaultIfEmpty((String)this.getAuthor(), (String)""));
        cdfElem.addElement("style").setText(StringUtils.defaultIfEmpty((String)this.getStyle(), (String)""));
        cdfElem.addElement("rendererType").setText(StringUtils.defaultIfEmpty((String)this.getRendererType(), (String)""));
        cdfElem.addElement("widget").setText(this.isWidget() ? "true" : "false");
        cdfElem.addElement("widgetName").setText(StringUtils.defaultIfEmpty((String)this.getWidgetName(), (String)""));
        cdfElem.addElement("widgetParameters").setText(StringUtils.join((Object[])this.getWidgetParameters(), (String)","));
        return doc;
    }

    public void update(HashMap<String, Object> parameters) {
        if (parameters.containsKey("title")) {
            this.setTitle((String)parameters.get("title"));
        }
        if (parameters.containsKey("author")) {
            this.setAuthor((String)parameters.get("author"));
        }
        if (parameters.containsKey("description")) {
            this.setDescription((String)parameters.get("description"));
        }
        if (parameters.containsKey("style")) {
            this.setStyle((String)parameters.get("style"));
        }
        if (parameters.containsKey("rendererType")) {
            this.setRendererType((String)parameters.get("rendererType"));
        }
        if (parameters.containsKey("widgetName")) {
            this.setWidgetName((String)parameters.get("widgetName"));
        }
        if (parameters.containsKey("widget")) {
            this.setWidget("true".equals(parameters.get("widget")));
        }
        if (parameters.containsKey("widgetParameters")) {
            Object widgetParams = parameters.get("widgetParameters");
            String[] widgetParameters = null;
            if (widgetParams instanceof String[]) {
                widgetParameters = (String[])widgetParams;
            } else if (widgetParams != null) {
                String widgetParamName = widgetParams.toString();
                widgetParameters = StringUtils.isNotEmpty((String)widgetParamName) ? new String[]{widgetParamName} : new String[]{};
            }
            this.setWidgetParameters(widgetParameters);
        } else {
            this.setWidgetParameters(null);
        }
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public String getAuthor() {
        return this._author;
    }

    public void setAuthor(String author) {
        this._author = author;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getStyle() {
        return this._style;
    }

    public void setStyle(String style) {
        this._style = style;
    }

    public String getRendererType() {
        return this._rendererType;
    }

    public DashboardRendererType getParsedRendererType() {
        return DashboardWcdfDescriptor.parseRendererType(this._rendererType, DashboardRendererType.BLUEPRINT);
    }

    public void setRendererType(String rendererType) {
        this._rendererType = rendererType;
    }

    public void setPath(String wcdfFilePath) {
        this._path = wcdfFilePath;
    }

    public String getPath() {
        return this._path;
    }

    public String getStructurePath() {
        return this._path == null ? null : this._path.replace(".wcdf", ".cdfde");
    }

    public static String toStructurePath(String wcdfPath) {
        return wcdfPath == null ? wcdfPath : wcdfPath.replace(".wcdf", ".cdfde");
    }

    public String getWidgetName() {
        return this._widgetName;
    }

    public void setWidgetName(String widgetName) {
        this._widgetName = widgetName;
    }

    public void setWidget(boolean isWidget) {
        this._isWidget = isWidget;
    }

    public boolean isWidget() {
        return this._isWidget;
    }

    public void setWidgetParameters(String[] params) {
        this._widgetParameters = params != null ? Arrays.asList(params) : Arrays.asList(new Object[0]);
    }

    public String[] getWidgetParameters() {
        return this._widgetParameters.toArray(new String[0]);
    }

    public static DashboardWcdfDescriptor load(String wcdfFilePath) throws IOException {
        IReadAccess readAccess = Utils.getSystemOrUserReadAccess(wcdfFilePath);
        if (readAccess == null || !readAccess.fileExists(wcdfFilePath)) {
            return null;
        }
        Document wcdfDoc = null;
        try {
            wcdfDoc = Utils.getDocFromFile(readAccess.fetchFile(wcdfFilePath), null);
            DashboardWcdfDescriptor wcdf = DashboardWcdfDescriptor.fromXml(wcdfDoc);
            wcdf.setPath(wcdfFilePath);
            return wcdf;
        }
        catch (DocumentException e) {
            _logger.error((Object)"DashboardWcdfDescriptor.load(wcdfFilePath)", (Throwable)e);
            return null;
        }
    }

    public static DashboardRendererType parseRendererType(String rendererType, DashboardRendererType defaultValue) {
        if (!StringUtils.isEmpty((String)rendererType)) {
            try {
                return DashboardRendererType.valueOf(rendererType.toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                _logger.error((Object)("Bad renderer type: " + rendererType));
            }
        }
        return defaultValue;
    }

    public static enum DashboardRendererType {
        MOBILE("mobile"),
        BLUEPRINT("blueprint"),
        BOOTSTRAP("bootstrap");

        String type;

        private DashboardRendererType(String t) {
            this.type = t;
        }

        public String getType() {
            return this.type;
        }
    }
}

