/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.RegionServerCallable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.RetryingCallable;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.util.BoundedCompletionService;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

public class RpcRetryingCallerWithReadReplicas {
    static final Log LOG = LogFactory.getLog(RpcRetryingCallerWithReadReplicas.class);
    protected final ExecutorService pool;
    protected final ClusterConnection cConnection;
    protected final Configuration conf;
    protected final Get get;
    protected final TableName tableName;
    protected final int timeBeforeReplicas;
    private final int callTimeout;
    private final int retries;

    public RpcRetryingCallerWithReadReplicas(TableName tableName, ClusterConnection cConnection, Get get, ExecutorService pool, int retries, int callTimeout, int timeBeforeReplicas) {
        this.tableName = tableName;
        this.cConnection = cConnection;
        this.conf = cConnection.getConfiguration();
        this.get = get;
        this.pool = pool;
        this.retries = retries;
        this.callTimeout = callTimeout;
        this.timeBeforeReplicas = timeBeforeReplicas;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Result call() throws DoNotRetryIOException, InterruptedIOException, RetriesExhaustedException {
        Future f;
        RegionLocations rl = this.getRegionLocations(true, 0);
        BoundedCompletionService cs = new BoundedCompletionService((Executor)this.pool, rl.size());
        ArrayList<ExecutionException> exceptions = null;
        int submitted = 0;
        int completed = 0;
        submitted += this.addCallsForReplica((BoundedCompletionService<Result>)cs, rl, 0, 0);
        try {
            f = cs.poll((long)this.timeBeforeReplicas, TimeUnit.MICROSECONDS);
            if (f != null) {
                return (Result)f.get();
            }
        }
        catch (ExecutionException e) {
            exceptions = new ArrayList<ExecutionException>(rl.size());
            exceptions.add(e);
            ++completed;
        }
        catch (CancellationException e) {
            throw new InterruptedIOException();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        submitted += this.addCallsForReplica((BoundedCompletionService<Result>)cs, rl, 1, rl.size() - 1);
        try {
            while (completed < submitted) {
                try {
                    f = cs.take();
                    if (f == null) continue;
                    Result result = (Result)f.get();
                    return result;
                }
                catch (ExecutionException e) {
                    if (exceptions == null) {
                        exceptions = new ArrayList(rl.size());
                    }
                    exceptions.add(e);
                    ++completed;
                }
            }
        }
        catch (CancellationException e) {
            throw new InterruptedIOException();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            cs.cancelAll(true);
        }
        if (exceptions == null) return null;
        if (exceptions.isEmpty()) return null;
        this.throwEnrichedException((ExecutionException)exceptions.get(0));
        return null;
    }

    private void throwEnrichedException(ExecutionException e) throws RetriesExhaustedException, DoNotRetryIOException {
        Throwable t = e.getCause();
        assert (t != null);
        if (t instanceof RetriesExhaustedException) {
            throw (RetriesExhaustedException)t;
        }
        if (t instanceof DoNotRetryIOException) {
            throw (DoNotRetryIOException)((Object)t);
        }
        RetriesExhaustedException.ThrowableWithExtraContext qt = new RetriesExhaustedException.ThrowableWithExtraContext(t, EnvironmentEdgeManager.currentTimeMillis(), this.toString());
        List<RetriesExhaustedException.ThrowableWithExtraContext> exceptions = Collections.singletonList(qt);
        throw new RetriesExhaustedException(this.retries, exceptions);
    }

    private int addCallsForReplica(BoundedCompletionService<Result> cs, RegionLocations rl, int min, int max) {
        for (int id = min; id <= max; ++id) {
            HRegionLocation hrl = rl.getRegionLocation(id);
            ReplicaRegionServerCallable callOnReplica = new ReplicaRegionServerCallable(id, hrl);
            RetryingRPC retryingOnReplica = new RetryingRPC(callOnReplica);
            cs.submit((Callable)retryingOnReplica);
        }
        return max - min + 1;
    }

    private RegionLocations getRegionLocations(boolean useCache, int replicaId) throws RetriesExhaustedException, DoNotRetryIOException, InterruptedIOException {
        RegionLocations rl;
        try {
            rl = this.cConnection.locateRegion(this.tableName, this.get.getRow(), useCache, true, replicaId);
        }
        catch (DoNotRetryIOException e) {
            throw e;
        }
        catch (RetriesExhaustedException e) {
            throw e;
        }
        catch (InterruptedIOException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RetriesExhaustedException("Can't get the location", e);
        }
        if (rl == null) {
            throw new RetriesExhaustedException("Can't get the locations");
        }
        return rl;
    }

    class RetryingRPC
    implements Callable<Result> {
        final RetryingCallable<Result> callable;

        RetryingRPC(RetryingCallable<Result> callable) {
            this.callable = callable;
        }

        @Override
        public Result call() throws IOException {
            return new RpcRetryingCallerFactory(RpcRetryingCallerWithReadReplicas.this.conf).newCaller().callWithRetries(this.callable, RpcRetryingCallerWithReadReplicas.this.callTimeout);
        }
    }

    class ReplicaRegionServerCallable
    extends RegionServerCallable<Result> {
        final int id;

        public ReplicaRegionServerCallable(int id, HRegionLocation location) {
            super(RpcRetryingCallerWithReadReplicas.this.cConnection, RpcRetryingCallerWithReadReplicas.this.tableName, RpcRetryingCallerWithReadReplicas.this.get.getRow());
            this.id = id;
            this.location = location;
        }

        @Override
        public void prepare(boolean reload) throws IOException {
            if (Thread.interrupted()) {
                throw new InterruptedIOException();
            }
            if (reload || this.location == null) {
                RegionLocations rl = RpcRetryingCallerWithReadReplicas.this.getRegionLocations(false, this.id);
                HRegionLocation hRegionLocation = this.location = this.id < rl.size() ? rl.getRegionLocation(this.id) : null;
            }
            if (this.location == null || this.location.getServerName() == null) {
                throw new HBaseIOException("There is no location for replica id #" + this.id);
            }
            ServerName dest = this.location.getServerName();
            assert (dest != null);
            this.setStub(RpcRetryingCallerWithReadReplicas.this.cConnection.getClient(dest));
        }

        @Override
        public Result call() throws Exception {
            if (Thread.interrupted()) {
                throw new InterruptedIOException();
            }
            byte[] reg = this.location.getRegionInfo().getRegionName();
            return ProtobufUtil.get(this.getStub(), reg, RpcRetryingCallerWithReadReplicas.this.get);
        }
    }
}

