/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.hbase;

import com.cloudera.sqoop.lib.FieldMapProcessor;
import com.cloudera.sqoop.lib.FieldMappable;
import com.cloudera.sqoop.lib.ProcessingException;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.sqoop.hbase.PutTransformer;
import org.apache.sqoop.hbase.ToStringPutTransformer;

public class HBasePutProcessor
implements Closeable,
Configurable,
FieldMapProcessor {
    public static final Log LOG = LogFactory.getLog((String)HBasePutProcessor.class.getName());
    public static final String TABLE_NAME_KEY = "sqoop.hbase.insert.table";
    public static final String COL_FAMILY_KEY = "sqoop.hbase.insert.column.family";
    public static final String ROW_KEY_COLUMN_KEY = "sqoop.hbase.insert.row.key.column";
    public static final String TRANSFORMER_CLASS_KEY = "sqoop.hbase.insert.put.transformer.class";
    public static final String ADD_ROW_KEY = "sqoop.hbase.add.row.key";
    public static final boolean ADD_ROW_KEY_DEFAULT = false;
    private Configuration conf;
    private PutTransformer putTransformer;
    private String tableName;
    private HTable table;

    public void setConf(Configuration config) {
        this.conf = config;
        Class xformerClass = this.conf.getClass(TRANSFORMER_CLASS_KEY, ToStringPutTransformer.class);
        this.putTransformer = (PutTransformer)ReflectionUtils.newInstance((Class)xformerClass, (Configuration)this.conf);
        if (null == this.putTransformer) {
            throw new RuntimeException("Could not instantiate PutTransformer.");
        }
        this.putTransformer.setColumnFamily(this.conf.get(COL_FAMILY_KEY, null));
        this.putTransformer.setRowKeyColumn(this.conf.get(ROW_KEY_COLUMN_KEY, null));
        if (this.putTransformer instanceof ToStringPutTransformer) {
            ToStringPutTransformer stringPutTransformer = (ToStringPutTransformer)this.putTransformer;
            stringPutTransformer.bigDecimalFormatString = this.conf.getBoolean("sqoop.bigdecimal.format.string", true);
            stringPutTransformer.addRowKey = this.conf.getBoolean(ADD_ROW_KEY, false);
            stringPutTransformer.detectCompositeKey();
        }
        this.tableName = this.conf.get(TABLE_NAME_KEY, null);
        try {
            this.table = new HTable(this.conf, this.tableName);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not access HBase table " + this.tableName, ioe);
        }
        this.table.setAutoFlush(false);
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void accept(FieldMappable record) throws IOException, ProcessingException {
        Map<String, Object> fields = record.getFieldMap();
        List<Put> putList = this.putTransformer.getPutCommand(fields);
        if (null != putList) {
            for (Put put : putList) {
                if (put == null) continue;
                if (put.isEmpty()) {
                    LOG.warn((Object)("Could not insert row with no columns for row-key column: " + Bytes.toString((byte[])put.getRow())));
                    continue;
                }
                this.table.put(put);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.table.flushCommits();
        this.table.close();
    }
}

