/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.db.netezza;

import com.cloudera.sqoop.lib.DelimiterSet;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.sqoop.io.NamedFifo;
import org.apache.sqoop.lib.SqoopRecord;
import org.apache.sqoop.mapreduce.SqoopMapper;
import org.apache.sqoop.mapreduce.db.DBConfiguration;
import org.apache.sqoop.mapreduce.db.netezza.NetezzaExternalTableImportMapper;
import org.apache.sqoop.mapreduce.db.netezza.NetezzaJDBCStatementRunner;
import org.apache.sqoop.util.PerfCounters;
import org.apache.sqoop.util.TaskId;

public abstract class NetezzaExternalTableExportMapper<K, V>
extends SqoopMapper<K, V, NullWritable, NullWritable> {
    private Configuration conf;
    private DBConfiguration dbc;
    private File fifoFile;
    private Connection con;
    private OutputStream recordWriter;
    public static final Log LOG = LogFactory.getLog((String)NetezzaExternalTableImportMapper.class.getName());
    private NetezzaJDBCStatementRunner extTableThread;
    private PerfCounters counter;
    private DelimiterSet outputDelimiters;

    private String getSqlStatement() throws IOException {
        char fd = (char)this.conf.getInt("sqoop.input.field.delim", 44);
        char qc = (char)this.conf.getInt("sqoop.input.enclosed.by", 0);
        char ec = (char)this.conf.getInt("sqoop.input.escaped.by", 0);
        String nullValue = this.conf.get("netezza.exttable.null.value");
        int errorThreshold = this.conf.getInt("netezza.error.threshold", 1);
        String logDir = this.conf.get("netezza.log.dir");
        StringBuilder sqlStmt = new StringBuilder(2048);
        sqlStmt.append("INSERT INTO ");
        sqlStmt.append(this.dbc.getInputTableName());
        sqlStmt.append(" SELECT * FROM EXTERNAL '");
        sqlStmt.append(this.fifoFile.getAbsolutePath());
        sqlStmt.append("' USING (REMOTESOURCE 'JDBC' ");
        sqlStmt.append(" BOOLSTYLE 'TRUE_FALSE' ");
        sqlStmt.append(" CRINSTRING FALSE ");
        sqlStmt.append(" DELIMITER ");
        sqlStmt.append(Integer.toString(fd));
        sqlStmt.append(" ENCODING 'internal' ");
        if (ec > '\u0000') {
            sqlStmt.append(" ESCAPECHAR '\\' ");
        }
        sqlStmt.append(" FORMAT 'Text' ");
        sqlStmt.append(" INCLUDEZEROSECONDS TRUE ");
        sqlStmt.append(" NULLVALUE '");
        if (nullValue != null) {
            sqlStmt.append(nullValue);
        } else {
            sqlStmt.append("null");
        }
        sqlStmt.append("' ");
        if (qc > '\u0000') {
            switch (qc) {
                case '\'': {
                    sqlStmt.append(" QUOTEDVALUE SINGLE ");
                    break;
                }
                case '\"': {
                    sqlStmt.append(" QUOTEDVALUE DOUBLE ");
                    break;
                }
                default: {
                    LOG.warn((Object)("Unsupported enclosed by character: " + qc + " - ignoring."));
                }
            }
        }
        sqlStmt.append(" MAXERRORS ").append(errorThreshold);
        if (logDir != null && (logDir = logDir.trim()).length() > 0) {
            File logDirPath = new File(logDir);
            logDirPath.mkdirs();
            if (logDirPath.canWrite() && logDirPath.isDirectory()) {
                sqlStmt.append(" LOGDIR ").append(logDir).append(' ');
            } else {
                throw new IOException("Unable to create log directory specified");
            }
        }
        sqlStmt.append(")");
        String stmt = sqlStmt.toString();
        LOG.debug((Object)("SQL generated for external table export" + stmt));
        return stmt;
    }

    private void initNetezzaExternalTableExport(Mapper.Context context) throws IOException {
        NamedFifo nf;
        this.conf = context.getConfiguration();
        this.dbc = new DBConfiguration(this.conf);
        File taskAttemptDir = TaskId.getLocalWorkPath(this.conf);
        this.outputDelimiters = new DelimiterSet(',', '\n', '\u0000', '\\', false);
        this.fifoFile = new File(taskAttemptDir, "nzexttable-export.txt");
        String filename = this.fifoFile.toString();
        try {
            nf = new NamedFifo(this.fifoFile);
            nf.create();
        }
        catch (IOException ioe) {
            LOG.error((Object)("Could not create FIFO file " + filename));
            this.fifoFile = null;
            throw new IOException("Could not create FIFO for netezza external table import", ioe);
        }
        String sqlStmt = this.getSqlStatement();
        boolean cleanup = false;
        try {
            this.con = this.dbc.getConnection();
            this.extTableThread = new NetezzaJDBCStatementRunner(Thread.currentThread(), this.con, sqlStmt);
        }
        catch (SQLException sqle) {
            cleanup = true;
            throw new IOException(sqle);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe);
        }
        finally {
            if (this.con != null && cleanup) {
                try {
                    this.con.close();
                }
                catch (Exception e) {
                    LOG.debug((Object)("Exception closing connection " + e.getMessage()));
                }
            }
            this.con = null;
        }
        this.counter = new PerfCounters();
        this.extTableThread.start();
        this.recordWriter = new BufferedOutputStream(new FileOutputStream(nf.getFile()));
        this.counter.startClock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Mapper.Context context) throws IOException, InterruptedException {
        this.setup(context);
        this.initNetezzaExternalTableExport(context);
        if (this.extTableThread.isAlive()) {
            try {
                while (context.nextKeyValue() && (!Thread.interrupted() || this.extTableThread.isAlive())) {
                    this.map(context.getCurrentKey(), context.getCurrentValue(), context);
                }
                this.cleanup(context);
            }
            finally {
                this.recordWriter.close();
                this.extTableThread.join();
                this.counter.stopClock();
                LOG.info((Object)("Transferred " + this.counter.toString()));
                if (this.extTableThread.hasExceptions()) {
                    this.extTableThread.printException();
                    throw new IOException(this.extTableThread.getExcepton());
                }
            }
        }
    }

    protected void writeTextRecord(Text record) throws IOException, InterruptedException {
        String outputStr = record.toString() + "\n";
        byte[] outputBytes = outputStr.getBytes("UTF-8");
        this.counter.addBytes(outputBytes.length);
        this.recordWriter.write(outputBytes, 0, outputBytes.length);
    }

    protected void writeSqoopRecord(SqoopRecord sqr) throws IOException, InterruptedException {
        String outputStr = sqr.toString(this.outputDelimiters);
        byte[] outputBytes = outputStr.getBytes("UTF-8");
        this.counter.addBytes(outputBytes.length);
        this.recordWriter.write(outputBytes, 0, outputBytes.length);
    }
}

