/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.linq4j.expressions;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.List;
import net.hydromatic.linq4j.Linq4j;
import net.hydromatic.linq4j.expressions.Evaluator;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.ExpressionType;
import net.hydromatic.linq4j.expressions.ExpressionWriter;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.Types;
import net.hydromatic.linq4j.expressions.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodCallExpression
extends Expression {
    public final Method method;
    public final Expression targetExpression;
    public final List<Expression> expressions;

    MethodCallExpression(Type returnType, Method method, Expression targetExpression, List<Expression> expressions) {
        super(ExpressionType.Call, returnType);
        this.method = method;
        this.targetExpression = targetExpression;
        this.expressions = expressions;
        assert (expressions != null);
        assert (returnType != null);
        assert (targetExpression == null == Modifier.isStatic(method.getModifiers()));
        assert (Types.toClass(returnType) == method.getReturnType());
    }

    MethodCallExpression(Method method, Expression targetExpression, List<Expression> expressions) {
        this(method.getGenericReturnType(), method, targetExpression, expressions);
    }

    public int hashCode() {
        return this.nodeType.hashCode() ^ this.method.hashCode() ^ this.targetExpression.hashCode() ^ this.expressions.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MethodCallExpression) {
            MethodCallExpression call = (MethodCallExpression)obj;
            return this.nodeType == call.nodeType && this.method == call.method && Linq4j.equals(this.targetExpression, call.targetExpression) && this.expressions.equals(call.expressions);
        }
        return false;
    }

    @Override
    public Expression accept(Visitor visitor) {
        Expression targetExpression = Expressions.accept(this.targetExpression, visitor);
        List<Expression> expressions = Expressions.acceptExpressions(this.expressions, visitor);
        return visitor.visit(this, targetExpression, expressions);
    }

    @Override
    public Object evaluate(Evaluator evaluator) {
        Object target = this.targetExpression == null ? null : this.targetExpression.evaluate(evaluator);
        Object[] args = new Object[this.expressions.size()];
        for (int i = 0; i < this.expressions.size(); ++i) {
            Expression expression = this.expressions.get(i);
            args[i] = expression.evaluate(evaluator);
        }
        try {
            return this.method.invoke(target, args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("error while evaluating " + this, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("error while evaluating " + this, e);
        }
    }

    @Override
    void accept(ExpressionWriter writer, int lprec, int rprec) {
        if (writer.requireParentheses(this, lprec, rprec)) {
            return;
        }
        if (this.targetExpression != null) {
            this.targetExpression.accept(writer, lprec, this.nodeType.lprec);
        } else {
            writer.append(this.method.getDeclaringClass());
        }
        writer.append('.').append(this.method.getName()).append('(');
        int k = 0;
        for (Expression expression : this.expressions) {
            if (k++ > 0) {
                writer.append(", ");
            }
            expression.accept(writer, 0, 0);
        }
        writer.append(')');
    }
}

