/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import pt.webdetails.cpf.repository.api.IRWAccess;
import pt.webdetails.cpf.utils.CharsetHelper;

public class PluginSettings {
    protected static final String SETTINGS_FILE = "settings.xml";
    protected static Log logger = LogFactory.getLog(PluginSettings.class);
    private IRWAccess writeAccess;
    private Document settings;
    private long lastRead;

    public PluginSettings(IRWAccess writeAccess) {
        this.writeAccess = writeAccess;
        this.loadDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    private boolean loadDocument() {
        boolean bl;
        InputStream input = null;
        try {
            input = this.writeAccess.getFileInputStream(SETTINGS_FILE);
            this.lastRead = this.writeAccess.getLastModified(SETTINGS_FILE);
            SAXReader reader = new SAXReader();
            this.settings = reader.read(input);
            bl = true;
        }
        catch (IOException ex) {
            logger.error((Object)"Error while reading settings.xml", (Throwable)ex);
            IOUtils.closeQuietly((InputStream)input);
        }
        catch (DocumentException ex2) {
            logger.error((Object)"Error while reading settings.xml", (Throwable)ex2);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(input);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)input);
        }
        IOUtils.closeQuietly((InputStream)input);
        return bl;
        return false;
    }

    protected String getStringSetting(String section, String defaultValue) {
        Node node = this.settings.selectSingleNode(this.getNodePath(section));
        if (node == null) {
            return defaultValue;
        }
        return node.getStringValue();
    }

    protected boolean getBooleanSetting(String section, boolean nullValue) {
        String setting = this.getStringSetting(section, null);
        if (setting != null) {
            return Boolean.parseBoolean(setting);
        }
        return nullValue;
    }

    private String getNodePath(String section) {
        return "settings/" + section;
    }

    protected boolean writeSetting(String section, String value) {
        if (this.settings != null) {
            Node node = this.settings.selectSingleNode(this.getNodePath(section));
            if (node != null) {
                String oldValue = node.getText();
                node.setText(value);
                String saveMsg = "changed '" + section + "' from '" + oldValue + "' to '" + value + "'";
                return this.saveSettingsFile(saveMsg);
            }
            logger.error((Object)"Couldn't find node");
        } else {
            logger.error((Object)"No settings!");
        }
        return false;
    }

    private boolean saveSettingsFile(String saveMsg) {
        try {
            String contents = this.settings.asXML();
            if (this.writeAccess.saveFile(SETTINGS_FILE, IOUtils.toInputStream((String)contents, (String)CharsetHelper.getEncoding()))) {
                logger.debug((Object)saveMsg);
                return true;
            }
            logger.error((Object)"Error saving settings file.");
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return false;
    }

    protected List<Element> getSettingsXmlSection(String section) {
        return this.settings.selectNodes("/settings/" + section);
    }

    public List<String> getTagValue(String tag) {
        List<Element> pathElements = this.getSettingsXmlSection(tag);
        if (pathElements != null) {
            ArrayList<String> solutionPaths = new ArrayList<String>(pathElements.size());
            for (Element pathElement : pathElements) {
                solutionPaths.add(pathElement.getText());
            }
            return solutionPaths;
        }
        return new ArrayList<String>(0);
    }
}

