/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.packager.dependencies;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.context.api.IUrlProvider;
import pt.webdetails.cpf.packager.dependencies.FileDependency;
import pt.webdetails.cpf.packager.origin.PathOrigin;
import pt.webdetails.cpf.repository.api.IRWAccess;

public abstract class PackagedFileDependency
extends FileDependency {
    private static Log logger = LogFactory.getLog(PackagedFileDependency.class);
    private Iterable<FileDependency> inputFiles;
    private IRWAccess writer;
    private boolean isSaved;

    public PackagedFileDependency(PathOrigin origin, String path, IRWAccess writer, Iterable<FileDependency> inputFiles, IUrlProvider urlProvider) {
        super(null, origin, path, urlProvider);
        this.inputFiles = inputFiles;
        this.writer = writer;
    }

    @Override
    public synchronized InputStream getFileInputStream() throws IOException {
        if (!this.isSaved) {
            long startTime = System.currentTimeMillis();
            this.isSaved = this.writer.saveFile(this.filePath, this.minifyPackage(this.inputFiles));
            if (!this.isSaved) {
                throw new IOException("Unable to save file " + this.filePath);
            }
            this.inputFiles = null;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Generated '%s' in %s", this.filePath, Util.getElapsedSeconds(startTime)));
            }
        }
        return super.getFileInputStream();
    }

    protected abstract InputStream minifyPackage(Iterable<FileDependency> var1);
}

