/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.bundle;

import java.util.Date;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.StatusUpdateXCommand;
import org.apache.oozie.executor.jpa.BundleActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.BundleActionQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;

public class BundleStatusUpdateXCommand
extends StatusUpdateXCommand {
    private final CoordinatorJobBean coordjob;
    private JPAService jpaService = null;
    private BundleActionBean bundleaction;
    private final Job.Status prevStatus;

    public BundleStatusUpdateXCommand(CoordinatorJobBean coordjob, Job.Status prevStatus) {
        super("BundleStatusUpdate", "BundleStatusUpdate", 1);
        this.coordjob = coordjob;
        this.prevStatus = prevStatus;
    }

    @Override
    protected Void execute() throws CommandException {
        try {
            this.LOG.debug("STARTED BundleStatusUpdateXCommand with bundle id : " + this.coordjob.getBundleId() + " coord job ID: " + this.coordjob.getId() + " coord Status " + this.coordjob.getStatus());
            Job.Status coordCurrentStatus = this.coordjob.getStatus();
            if (this.bundleaction.getCoordId() != null || !this.bundleaction.isTerminalStatus() || this.bundleaction.getCoordId() != null && this.bundleaction.isTerminalStatus() && this.coordjob.isTerminalStatus()) {
                this.bundleaction.setStatus(coordCurrentStatus);
            }
            if (this.bundleaction.isPending()) {
                this.bundleaction.decrementAndGetPending();
            }
            this.bundleaction.setLastModifiedTime(new Date());
            this.bundleaction.setCoordId(this.coordjob.getId());
            BundleActionQueryExecutor.getInstance().executeUpdate(BundleActionQueryExecutor.BundleActionQuery.UPDATE_BUNDLE_ACTION_STATUS_PENDING_MODTIME_COORDID, this.bundleaction);
            if (this.bundleaction.getCoordId() != null) {
                this.LOG.info("Updated bundle action [{0}] from prev status [{1}] to current coord status [{2}], and new bundle action pending [{3}]", this.bundleaction.getBundleActionId(), this.bundleaction.getStatus(), coordCurrentStatus, this.bundleaction.getPending());
            } else {
                this.LOG.info("Updated Bundle action [{0}], status = [{1}], pending = [{2}]", this.bundleaction.getBundleActionId(), this.bundleaction.getStatus(), this.bundleaction.getPending());
            }
            this.LOG.debug("ENDED BundleStatusUpdateXCommand with bundle id : " + this.coordjob.getBundleId() + " coord job ID: " + this.coordjob.getId() + " coord Status " + this.coordjob.getStatus());
        }
        catch (Exception ex) {
            throw new CommandException(ErrorCode.E1309, this.bundleaction.getBundleId(), this.bundleaction.getCoordName());
        }
        return null;
    }

    @Override
    public String getEntityKey() {
        return this.coordjob.getBundleId();
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    protected void loadState() throws CommandException {
        try {
            if (this.jpaService == null) {
                this.jpaService = Services.get().get(JPAService.class);
            }
            if (this.jpaService == null) {
                throw new CommandException(ErrorCode.E0610, new Object[0]);
            }
            this.bundleaction = this.jpaService.execute(new BundleActionGetJPAExecutor(this.coordjob.getBundleId(), this.coordjob.getAppName()));
        }
        catch (XException ex) {
            throw new CommandException(ex);
        }
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        if (this.bundleaction.getStatusStr().compareToIgnoreCase(this.prevStatus.toString()) != 0 && this.bundleaction.getCoordId() != null) {
            if (this.bundleaction.isTerminalStatus() && this.coordjob.isTerminalStatus()) {
                this.LOG.info("Bundle action [{0}] status [{1}] is different from prev coord status [{2}], but coord job is currently in terminal state = [{3}]", this.bundleaction.getBundleActionId(), this.bundleaction.getStatusStr(), this.prevStatus.toString(), this.coordjob.getStatus());
                return;
            }
            if (this.bundleaction.isPending() && this.coordjob.getStatus().equals((Object)this.bundleaction.getStatus())) {
                this.bundleaction.decrementAndGetPending();
            }
            this.bundleaction.setLastModifiedTime(new Date());
            try {
                BundleActionQueryExecutor.getInstance().executeUpdate(BundleActionQueryExecutor.BundleActionQuery.UPDATE_BUNDLE_ACTION_PENDING_MODTIME, this.bundleaction);
            }
            catch (JPAExecutorException je) {
                throw new CommandException(je);
            }
            this.LOG.info("Bundle action [{0}] status [{1}] is different from prev coord status [{2}] and current coord status [{3}], decrement pending so new pending = [{4}]", this.bundleaction.getBundleActionId(), this.bundleaction.getStatusStr(), this.prevStatus.toString(), this.coordjob.getStatusStr(), this.bundleaction.getPending());
            throw new PreconditionException(ErrorCode.E1308, this.bundleaction.getStatusStr(), this.prevStatus.toString());
        }
        if (this.bundleaction.getStatusStr().compareToIgnoreCase(this.prevStatus.toString()) != 0) {
            this.LOG.info("Bundle action [{0}] status [{1}] is different from prev coord status [{2}], pending = [{3}] and bundle not yet updated with coord-id", this.bundleaction.getBundleActionId(), this.bundleaction.getStatusStr(), this.prevStatus.toString(), this.bundleaction.getPending());
        }
    }
}

