/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.jsp.el.ELException;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.FaultInjection;
import org.apache.oozie.SLAEventBean;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.XException;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.action.control.ControlNodeActionExecutor;
import org.apache.oozie.client.SLAEvent;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.wf.ActionEndXCommand;
import org.apache.oozie.command.wf.ActionXCommand;
import org.apache.oozie.command.wf.NotificationXCommand;
import org.apache.oozie.command.wf.WfEndXCommand;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowActionQueryExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.service.ActionService;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.util.ELEvaluationException;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.XmlUtils;
import org.apache.oozie.util.db.SLADbXOperations;
import org.jdom.JDOMException;

public class ActionStartXCommand
extends ActionXCommand<Void> {
    public static final String EL_ERROR = "EL_ERROR";
    public static final String EL_EVAL_ERROR = "EL_EVAL_ERROR";
    public static final String COULD_NOT_START = "COULD_NOT_START";
    public static final String START_DATA_MISSING = "START_DATA_MISSING";
    public static final String EXEC_DATA_MISSING = "EXEC_DATA_MISSING";
    private String jobId = null;
    private String actionId = null;
    private WorkflowJobBean wfJob = null;
    private WorkflowActionBean wfAction = null;
    private JPAService jpaService = null;
    private ActionExecutor executor = null;
    private List<BatchQueryExecutor.UpdateEntry> updateList = new ArrayList<BatchQueryExecutor.UpdateEntry>();
    private List<JsonBean> insertList = new ArrayList<JsonBean>();

    public ActionStartXCommand(String actionId, String type) {
        super("action.start", type, 0);
        this.actionId = actionId;
        this.jobId = Services.get().get(UUIDService.class).getId(actionId);
    }

    public ActionStartXCommand(WorkflowJobBean job, String actionId, String type) {
        super("action.start", type, 0);
        this.actionId = actionId;
        this.wfJob = job;
        this.jobId = this.wfJob.getId();
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    public String getEntityKey() {
        return this.jobId;
    }

    @Override
    protected void loadState() throws CommandException {
        try {
            this.jpaService = Services.get().get(JPAService.class);
            if (this.jpaService != null) {
                if (this.wfJob == null) {
                    this.wfJob = WorkflowJobQueryExecutor.getInstance().get(WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW, this.jobId);
                }
            } else {
                throw new CommandException(ErrorCode.E0610, new Object[0]);
            }
            this.wfAction = WorkflowActionQueryExecutor.getInstance().get(WorkflowActionQueryExecutor.WorkflowActionQuery.GET_ACTION, this.actionId);
            LogUtils.setLogInfo(this.wfJob, this.logInfo);
            LogUtils.setLogInfo(this.wfAction, this.logInfo);
        }
        catch (XException ex) {
            throw new CommandException(ex);
        }
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        if (this.wfJob == null) {
            throw new PreconditionException(ErrorCode.E0604, this.jobId);
        }
        if (this.wfAction == null) {
            throw new PreconditionException(ErrorCode.E0605, this.actionId);
        }
        if (this.wfAction.isPending() && (this.wfAction.getStatus() == WorkflowAction.Status.PREP || this.wfAction.getStatus() == WorkflowAction.Status.START_RETRY || this.wfAction.getStatus() == WorkflowAction.Status.START_MANUAL || this.wfAction.getStatus() == WorkflowAction.Status.USER_RETRY)) {
            if (this.wfJob.getStatus() != WorkflowJob.Status.RUNNING) {
                throw new PreconditionException(ErrorCode.E0810, WorkflowJob.Status.RUNNING.toString());
            }
        } else {
            throw new PreconditionException(ErrorCode.E0816, this.wfAction.isPending(), this.wfAction.getStatusStr());
        }
        this.executor = Services.get().get(ActionService.class).getExecutor(this.wfAction.getType());
        if (this.executor == null) {
            throw new CommandException(ErrorCode.E0802, this.wfAction.getType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void execute() throws CommandException {
        this.LOG.debug("STARTED ActionStartXCommand for wf actionId=" + this.actionId);
        Configuration conf = this.wfJob.getWorkflowInstance().getConf();
        int maxRetries = 0;
        long retryInterval = 0L;
        boolean execSynchronous = false;
        if (!(this.executor instanceof ControlNodeActionExecutor)) {
            maxRetries = conf.getInt("oozie.wf.action.max.retries", this.executor.getMaxRetries());
            retryInterval = conf.getLong("oozie.wf.action.retry.interval", this.executor.getRetryInterval());
        }
        this.executor.setMaxRetries(maxRetries);
        this.executor.setRetryInterval(retryInterval);
        ActionXCommand.ActionExecutorContext context = null;
        try {
            boolean isRetry = false;
            if (this.wfAction.getStatus() == WorkflowAction.Status.START_RETRY || this.wfAction.getStatus() == WorkflowAction.Status.START_MANUAL) {
                isRetry = true;
                this.prepareForRetry(this.wfAction);
            }
            boolean isUserRetry = false;
            if (this.wfAction.getStatus() == WorkflowAction.Status.USER_RETRY) {
                isUserRetry = true;
                this.prepareForRetry(this.wfAction);
            }
            context = new ActionXCommand.ActionExecutorContext(this.wfJob, this.wfAction, isRetry, isUserRetry);
            boolean caught = false;
            try {
                if (!(this.executor instanceof ControlNodeActionExecutor)) {
                    String tmpActionConf = XmlUtils.removeComments(this.wfAction.getConf());
                    String actionConf = context.getELEvaluator().evaluate(tmpActionConf, String.class);
                    this.wfAction.setConf(actionConf);
                    this.LOG.debug("Start, name [{0}] type [{1}] configuration{E}{E}{2}{E}", this.wfAction.getName(), this.wfAction.getType(), actionConf);
                }
            }
            catch (ELEvaluationException ex) {
                caught = true;
                throw new ActionExecutorException(ActionExecutorException.ErrorType.TRANSIENT, EL_EVAL_ERROR, ex.getMessage(), ex);
            }
            catch (ELException ex) {
                caught = true;
                context.setErrorInfo(EL_ERROR, ex.getMessage());
                this.LOG.warn("ELException in ActionStartXCommand ", new Object[]{ex.getMessage(), ex});
                this.handleError(context, this.wfJob, this.wfAction);
            }
            catch (JDOMException je) {
                caught = true;
                context.setErrorInfo("ParsingError", je.getMessage());
                this.LOG.warn("JDOMException in ActionStartXCommand ", new Object[]{je.getMessage(), je});
                this.handleError(context, this.wfJob, this.wfAction);
            }
            catch (Exception ex) {
                caught = true;
                context.setErrorInfo(EL_ERROR, ex.getMessage());
                this.LOG.warn("Exception in ActionStartXCommand ", ex.getMessage(), ex);
                this.handleError(context, this.wfJob, this.wfAction);
            }
            if (!caught) {
                this.wfAction.setErrorInfo(null, null);
                this.incrActionCounter(this.wfAction.getType(), 1);
                this.LOG.info("Start action [{0}] with user-retry state : userRetryCount [{1}], userRetryMax [{2}], userRetryInterval [{3}]", this.wfAction.getId(), this.wfAction.getUserRetryCount(), this.wfAction.getUserRetryMax(), this.wfAction.getUserRetryInterval());
                Instrumentation.Cron cron = new Instrumentation.Cron();
                cron.start();
                context.setStartTime();
                this.executor.start(context, this.wfAction);
                cron.stop();
                FaultInjection.activate("org.apache.oozie.command.SkipCommitFaultInjection");
                this.addActionCron(this.wfAction.getType(), cron);
                this.wfAction.setRetries(0);
                if (this.wfAction.isExecutionComplete()) {
                    if (!context.isExecuted()) {
                        this.LOG.warn(4, "Action Completed, ActionExecutor [{0}] must call setExecutionData()", this.executor.getType());
                        this.wfAction.setErrorInfo(EXEC_DATA_MISSING, "Execution Complete, but Execution Data Missing from Action");
                        this.failJob(context);
                    } else {
                        this.wfAction.setPending();
                        if (!(this.executor instanceof ControlNodeActionExecutor)) {
                            this.queue(new ActionEndXCommand(this.wfAction.getId(), this.wfAction.getType()));
                        } else {
                            execSynchronous = true;
                        }
                    }
                } else if (!context.isStarted()) {
                    this.LOG.warn(4, "Action Started, ActionExecutor [{0}] must call setStartData()", this.executor.getType());
                    this.wfAction.setErrorInfo(START_DATA_MISSING, "Execution Started, but Start Data Missing from Action");
                    this.failJob(context);
                } else {
                    this.queue(new NotificationXCommand(this.wfJob, this.wfAction));
                }
                this.LOG.warn(1, "[***" + this.wfAction.getId() + "***]" + "Action status=" + this.wfAction.getStatusStr(), new Object[0]);
                this.updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowActionQueryExecutor.WorkflowActionQuery>(WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION_START, this.wfAction));
                this.wfJob.setLastModifiedTime(new Date());
                this.updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowJobQueryExecutor.WorkflowJobQuery>(WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MODIFIED, this.wfJob));
                SLAEventBean slaEvent = SLADbXOperations.createStatusEvent(this.wfAction.getSlaXml(), this.wfAction.getId(), SLAEvent.Status.STARTED, SLAEvent.SlaAppType.WORKFLOW_ACTION);
                if (slaEvent != null) {
                    this.insertList.add(slaEvent);
                }
                this.LOG.warn(1, "[***" + this.wfAction.getId() + "***]" + "Action updated in DB!", new Object[0]);
            }
        }
        catch (ActionExecutorException ex) {
            this.LOG.warn("Error starting action [{0}]. ErrorType [{1}], ErrorCode [{2}], Message [{3}]", new Object[]{this.wfAction.getName(), ex.getErrorType(), ex.getErrorCode(), ex.getMessage(), ex});
            this.wfAction.setErrorInfo(ex.getErrorCode(), ex.getMessage());
            switch (ex.getErrorType()) {
                case TRANSIENT: {
                    if (this.handleTransient(context, this.executor, WorkflowAction.Status.START_RETRY)) break;
                    this.handleNonTransient(context, this.executor, WorkflowAction.Status.START_MANUAL);
                    this.wfAction.setPendingAge(new Date());
                    this.wfAction.setRetries(0);
                    this.wfAction.setStartTime(null);
                    break;
                }
                case NON_TRANSIENT: {
                    this.handleNonTransient(context, this.executor, WorkflowAction.Status.START_MANUAL);
                    break;
                }
                case ERROR: {
                    this.handleError(context, this.executor, WorkflowAction.Status.ERROR.toString(), true, WorkflowAction.Status.DONE);
                    break;
                }
                case FAILED: {
                    try {
                        SLAEventBean slaEvent2;
                        this.failJob(context);
                        this.updateParentIfNecessary(this.wfJob, 3);
                        new WfEndXCommand(this.wfJob).call();
                        SLAEventBean slaEvent1 = SLADbXOperations.createStatusEvent(this.wfAction.getSlaXml(), this.wfAction.getId(), SLAEvent.Status.FAILED, SLAEvent.SlaAppType.WORKFLOW_ACTION);
                        if (slaEvent1 != null) {
                            this.insertList.add(slaEvent1);
                        }
                        if ((slaEvent2 = SLADbXOperations.createStatusEvent(this.wfJob.getSlaXml(), this.wfJob.getId(), SLAEvent.Status.FAILED, SLAEvent.SlaAppType.WORKFLOW_JOB)) == null) break;
                        this.insertList.add(slaEvent2);
                        break;
                    }
                    catch (XException x) {
                        this.LOG.warn("ActionStartXCommand - case:FAILED ", x.getMessage());
                    }
                }
            }
            this.updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowActionQueryExecutor.WorkflowActionQuery>(WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION_START, this.wfAction));
            this.wfJob.setLastModifiedTime(new Date());
            this.updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowJobQueryExecutor.WorkflowJobQuery>(WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MODIFIED, this.wfJob));
        }
        finally {
            try {
                BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(this.insertList, this.updateList, null);
                if (!(this.executor instanceof ControlNodeActionExecutor) && EventHandlerService.isEnabled()) {
                    this.generateEvent(this.wfAction, this.wfJob.getUser());
                }
                if (execSynchronous) {
                    new ActionEndXCommand(this.wfAction.getId(), this.wfAction.getType()).call(this.getEntityKey());
                }
            }
            catch (JPAExecutorException e) {
                throw new CommandException(e);
            }
        }
        this.LOG.debug("ENDED ActionStartXCommand for wf actionId=" + this.actionId + ", jobId=" + this.jobId);
        return null;
    }

    private void handleError(ActionXCommand.ActionExecutorContext context, WorkflowJobBean workflow, WorkflowActionBean action) throws CommandException {
        SLAEventBean slaEvent2;
        this.failJob(context);
        this.updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowActionQueryExecutor.WorkflowActionQuery>(WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION_START, this.wfAction));
        this.wfJob.setLastModifiedTime(new Date());
        this.updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowJobQueryExecutor.WorkflowJobQuery>(WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MODIFIED, this.wfJob));
        SLAEventBean slaEvent1 = SLADbXOperations.createStatusEvent(action.getSlaXml(), action.getId(), SLAEvent.Status.FAILED, SLAEvent.SlaAppType.WORKFLOW_ACTION);
        if (slaEvent1 != null) {
            this.insertList.add(slaEvent1);
        }
        if ((slaEvent2 = SLADbXOperations.createStatusEvent(workflow.getSlaXml(), workflow.getId(), SLAEvent.Status.FAILED, SLAEvent.SlaAppType.WORKFLOW_JOB)) != null) {
            this.insertList.add(slaEvent2);
        }
        new WfEndXCommand(this.wfJob).call();
    }

    @Override
    public String getKey() {
        return this.getName() + "_" + this.actionId;
    }

    private void prepareForRetry(WorkflowActionBean wfAction) {
        if (wfAction.getType().equals("map-reduce")) {
            wfAction.setExternalChildIDs("");
        }
    }
}

