/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.dependency;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hcatalog.api.ConnectionFailureException;
import org.apache.hcatalog.api.HCatClient;
import org.apache.hcatalog.common.HCatException;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.action.hadoop.HCatLauncherURIHandler;
import org.apache.oozie.action.hadoop.LauncherURIHandler;
import org.apache.oozie.dependency.URIHandler;
import org.apache.oozie.dependency.URIHandlerException;
import org.apache.oozie.dependency.hcat.HCatMessageHandler;
import org.apache.oozie.service.HCatAccessorException;
import org.apache.oozie.service.HCatAccessorService;
import org.apache.oozie.service.PartitionDependencyManagerService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.HCatURI;
import org.apache.oozie.util.XLog;

public class HCatURIHandler
implements URIHandler {
    private Set<String> supportedSchemes;
    private Map<String, URIHandler.DependencyType> dependencyTypes;
    private List<Class<?>> classesToShip;

    @Override
    public void init(Configuration conf) {
        this.dependencyTypes = new HashMap<String, URIHandler.DependencyType>();
        this.supportedSchemes = new HashSet<String>();
        String[] schemes = conf.getStrings("oozie.service.URIHandlerService.uri.handler." + this.getClass().getSimpleName() + ".supported.schemes", new String[]{"hcat"});
        this.supportedSchemes.addAll(Arrays.asList(schemes));
        this.classesToShip = new HCatLauncherURIHandler().getClassesForLauncher();
    }

    @Override
    public Set<String> getSupportedSchemes() {
        return this.supportedSchemes;
    }

    @Override
    public Class<? extends LauncherURIHandler> getLauncherURIHandlerClass() {
        return HCatLauncherURIHandler.class;
    }

    @Override
    public List<Class<?>> getClassesForLauncher() {
        return this.classesToShip;
    }

    @Override
    public URIHandler.DependencyType getDependencyType(URI uri) throws URIHandlerException {
        URIHandler.DependencyType depType = URIHandler.DependencyType.PULL;
        HCatAccessorService hcatService = Services.get().get(HCatAccessorService.class);
        if (hcatService != null && (depType = this.dependencyTypes.get(uri.getAuthority())) == null) {
            depType = hcatService.isKnownPublisher(uri) ? URIHandler.DependencyType.PUSH : URIHandler.DependencyType.PULL;
            this.dependencyTypes.put(uri.getAuthority(), depType);
        }
        return depType;
    }

    @Override
    public void registerForNotification(URI uri, Configuration conf, String user, String actionID) throws URIHandlerException {
        HCatURI hcatURI;
        try {
            hcatURI = new HCatURI(uri);
        }
        catch (URISyntaxException e) {
            throw new URIHandlerException(ErrorCode.E0906, uri, e);
        }
        HCatAccessorService hcatService = Services.get().get(HCatAccessorService.class);
        if (!hcatService.isRegisteredForNotification(hcatURI)) {
            HCatClient client = this.getHCatClient(uri, conf, user);
            try {
                String topic = client.getMessageBusTopicName(hcatURI.getDb(), hcatURI.getTable());
                if (topic == null) {
                    return;
                }
                hcatService.registerForNotification(hcatURI, topic, new HCatMessageHandler(uri.getAuthority()));
            }
            catch (HCatException e) {
                throw new HCatAccessorException(ErrorCode.E1501, new Object[]{e});
            }
            finally {
                this.closeQuietly(client, true);
            }
        }
        PartitionDependencyManagerService pdmService = Services.get().get(PartitionDependencyManagerService.class);
        pdmService.addMissingDependency(hcatURI, actionID);
    }

    @Override
    public boolean unregisterFromNotification(URI uri, String actionID) {
        HCatURI hcatURI;
        try {
            hcatURI = new HCatURI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        PartitionDependencyManagerService pdmService = Services.get().get(PartitionDependencyManagerService.class);
        return pdmService.removeMissingDependency(hcatURI, actionID);
    }

    @Override
    public URIHandler.Context getContext(URI uri, Configuration conf, String user) throws URIHandlerException {
        HCatClient client = this.getHCatClient(uri, conf, user);
        return new HCatContext(conf, user, client);
    }

    @Override
    public boolean exists(URI uri, URIHandler.Context context) throws URIHandlerException {
        HCatClient client = ((HCatContext)context).getHCatClient();
        return this.exists(uri, client, false);
    }

    @Override
    public boolean exists(URI uri, Configuration conf, String user) throws URIHandlerException {
        HCatClient client = this.getHCatClient(uri, conf, user);
        return this.exists(uri, client, true);
    }

    @Override
    public String getURIWithDoneFlag(String uri, String doneFlag) throws URIHandlerException {
        return uri;
    }

    @Override
    public void validate(String uri) throws URIHandlerException {
        try {
            new HCatURI(uri);
        }
        catch (URISyntaxException e) {
            throw new URIHandlerException(ErrorCode.E0906, uri, e);
        }
    }

    @Override
    public void destroy() {
    }

    private HCatClient getHCatClient(URI uri, Configuration conf, String user) throws HCatAccessorException {
        HCatAccessorService hcatService = Services.get().get(HCatAccessorService.class);
        if (hcatService.getHCatConf() != null) {
            conf = hcatService.getHCatConf();
        }
        HiveConf hiveConf = new HiveConf(conf, this.getClass());
        String serverURI = this.getMetastoreConnectURI(uri);
        if (!serverURI.equals("")) {
            hiveConf.set("hive.metastore.local", "false");
        }
        hiveConf.set(HiveConf.ConfVars.METASTOREURIS.varname, serverURI);
        try {
            XLog.getLog(HCatURIHandler.class).info("Creating HCatClient for user [{0}] login_user [{1}] and server [{2}] ", user, UserGroupInformation.getLoginUser(), serverURI);
            return HCatClient.create((Configuration)hiveConf);
        }
        catch (HCatException e) {
            throw new HCatAccessorException(ErrorCode.E1501, new Object[]{e});
        }
        catch (IOException e) {
            throw new HCatAccessorException(ErrorCode.E1501, e);
        }
    }

    private String getMetastoreConnectURI(URI uri) {
        String metastoreURI = uri.getAuthority().equals("unittest-local") ? "" : "thrift://" + uri.getAuthority();
        return metastoreURI;
    }

    private boolean exists(URI uri, HCatClient client, boolean closeClient) throws HCatAccessorException {
        try {
            HCatURI hcatURI = new HCatURI(uri.toString());
            List partitions = client.getPartitions(hcatURI.getDb(), hcatURI.getTable(), hcatURI.getPartitionMap());
            boolean bl = partitions != null && !partitions.isEmpty();
            return bl;
        }
        catch (ConnectionFailureException e) {
            throw new HCatAccessorException(ErrorCode.E1501, new Object[]{e});
        }
        catch (HCatException e) {
            throw new HCatAccessorException(ErrorCode.E0902, new Object[]{e});
        }
        catch (URISyntaxException e) {
            throw new HCatAccessorException(ErrorCode.E0902, e);
        }
        finally {
            this.closeQuietly(client, closeClient);
        }
    }

    private void closeQuietly(HCatClient client, boolean close) {
        if (close && client != null) {
            try {
                client.close();
            }
            catch (Exception ignore) {
                XLog.getLog(HCatURIHandler.class).warn((Object)"Error closing hcat client", ignore);
            }
        }
    }

    static class HCatContext
    extends URIHandler.Context {
        private HCatClient hcatClient;

        public HCatContext(Configuration conf, String user, HCatClient hcatClient) {
            super(conf, user);
            this.hcatClient = hcatClient;
        }

        public HCatClient getHCatClient() {
            return this.hcatClient;
        }

        @Override
        public void destroy() {
            try {
                this.hcatClient.close();
            }
            catch (Exception ignore) {
                XLog.getLog(HCatContext.class).warn((Object)"Error closing hcat client", ignore);
            }
        }
    }
}

