/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.ParamChecker;

public class CoordJobGetActionsByDatesForKillJPAExecutor
implements JPAExecutor<List<CoordinatorActionBean>> {
    private String jobId = null;
    private Date startDate;
    private Date endDate;

    public CoordJobGetActionsByDatesForKillJPAExecutor(String jobId, Date startDate, Date endDate) {
        ParamChecker.notNull(jobId, "jobId");
        this.jobId = jobId;
        this.startDate = startDate;
        this.endDate = endDate;
    }

    @Override
    public String getName() {
        return "CoordJobGetActionsByDatesForKillJPAExecutor";
    }

    @Override
    public List<CoordinatorActionBean> execute(EntityManager em) throws JPAExecutorException {
        ArrayList<CoordinatorActionBean> actionList = new ArrayList<CoordinatorActionBean>();
        try {
            Query q = em.createNamedQuery("GET_ACTIONS_BY_DATES_FOR_KILL");
            q.setParameter("jobId", (Object)this.jobId);
            q.setParameter("startTime", (Object)new Timestamp(this.startDate.getTime()));
            q.setParameter("endTime", (Object)new Timestamp(this.endDate.getTime()));
            List actions = q.getResultList();
            for (Object[] a : actions) {
                CoordinatorActionBean aa = this.getBeanForRunningCoordAction(a);
                actionList.add(aa);
            }
            return actionList;
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
    }

    private CoordinatorActionBean getBeanForRunningCoordAction(Object[] arr) {
        CoordinatorActionBean action = new CoordinatorActionBean();
        if (arr[0] != null) {
            action.setId((String)arr[0]);
        }
        if (arr[1] != null) {
            action.setJobId((String)arr[1]);
        }
        if (arr[2] != null) {
            action.setStatus(CoordinatorAction.Status.valueOf((String)((String)arr[2])));
        }
        if (arr[3] != null) {
            action.setExternalId((String)arr[3]);
        }
        if (arr[4] != null) {
            action.setPending((Integer)arr[4]);
        }
        if (arr[5] != null) {
            action.setNominalTime(DateUtils.toDate((Timestamp)arr[5]));
        }
        if (arr[6] != null) {
            action.setCreatedTime(DateUtils.toDate((Timestamp)arr[6]));
        }
        return action;
    }
}

