/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MappingRule {
    private static Pattern variableNamePattern = Pattern.compile("\\$\\{[0-9]\\}");
    private Pattern fromPattern;
    private String fromString;
    private String toString;
    private boolean patternMatch;

    public MappingRule(String fromRule, String toRule) {
        if (fromRule.contains("$")) {
            this.patternMatch = true;
            fromRule = fromRule.replaceAll("\\.", "\\\\.");
            Matcher match = variableNamePattern.matcher(fromRule);
            fromRule = match.replaceAll("(.*)");
            this.fromPattern = Pattern.compile(fromRule);
        } else {
            this.fromString = fromRule;
        }
        this.toString = toRule;
    }

    public String getFromRule() {
        return this.fromString;
    }

    public String getToRule() {
        return this.toString;
    }

    public String applyRule(String input) {
        if (this.patternMatch) {
            Matcher match = this.fromPattern.matcher(input);
            if (match.matches()) {
                String result = this.toString;
                int count = match.groupCount();
                for (int i = 1; i <= count; ++i) {
                    result = result.replace("${" + i + "}", match.group(i));
                }
                return result;
            }
        } else if (input.equals(this.fromString)) {
            return this.toString;
        }
        return null;
    }
}

