/*
 * Decompiled with CFR 0.152.
 */
package parquet.format;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;
import parquet.format.KeyValue;
import parquet.format.RowGroup;
import parquet.format.SchemaElement;
import parquet.org.apache.thrift.TBase;
import parquet.org.apache.thrift.TBaseHelper;
import parquet.org.apache.thrift.TException;
import parquet.org.apache.thrift.TFieldIdEnum;
import parquet.org.apache.thrift.meta_data.FieldMetaData;
import parquet.org.apache.thrift.meta_data.FieldValueMetaData;
import parquet.org.apache.thrift.meta_data.ListMetaData;
import parquet.org.apache.thrift.meta_data.StructMetaData;
import parquet.org.apache.thrift.protocol.TCompactProtocol;
import parquet.org.apache.thrift.protocol.TField;
import parquet.org.apache.thrift.protocol.TList;
import parquet.org.apache.thrift.protocol.TProtocol;
import parquet.org.apache.thrift.protocol.TProtocolException;
import parquet.org.apache.thrift.protocol.TProtocolUtil;
import parquet.org.apache.thrift.protocol.TStruct;
import parquet.org.apache.thrift.transport.TIOStreamTransport;

public class FileMetaData
implements TBase<FileMetaData, _Fields>,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("FileMetaData");
    private static final TField VERSION_FIELD_DESC = new TField("version", 8, 1);
    private static final TField SCHEMA_FIELD_DESC = new TField("schema", 15, 2);
    private static final TField NUM_ROWS_FIELD_DESC = new TField("num_rows", 10, 3);
    private static final TField ROW_GROUPS_FIELD_DESC = new TField("row_groups", 15, 4);
    private static final TField KEY_VALUE_METADATA_FIELD_DESC = new TField("key_value_metadata", 15, 5);
    private static final TField CREATED_BY_FIELD_DESC = new TField("created_by", 11, 6);
    public int version;
    public List<SchemaElement> schema;
    public long num_rows;
    public List<RowGroup> row_groups;
    public List<KeyValue> key_value_metadata;
    public String created_by;
    private static final int __VERSION_ISSET_ID = 0;
    private static final int __NUM_ROWS_ISSET_ID = 1;
    private BitSet __isset_bit_vector = new BitSet(2);
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public FileMetaData() {
    }

    public FileMetaData(int version, List<SchemaElement> schema, long num_rows, List<RowGroup> row_groups) {
        this();
        this.version = version;
        this.setVersionIsSet(true);
        this.schema = schema;
        this.num_rows = num_rows;
        this.setNum_rowsIsSet(true);
        this.row_groups = row_groups;
    }

    public FileMetaData(FileMetaData other) {
        this.__isset_bit_vector.clear();
        this.__isset_bit_vector.or(other.__isset_bit_vector);
        this.version = other.version;
        if (other.isSetSchema()) {
            ArrayList<SchemaElement> __this__schema = new ArrayList<SchemaElement>();
            for (SchemaElement schemaElement : other.schema) {
                __this__schema.add(new SchemaElement(schemaElement));
            }
            this.schema = __this__schema;
        }
        this.num_rows = other.num_rows;
        if (other.isSetRow_groups()) {
            ArrayList<RowGroup> __this__row_groups = new ArrayList<RowGroup>();
            for (RowGroup rowGroup : other.row_groups) {
                __this__row_groups.add(new RowGroup(rowGroup));
            }
            this.row_groups = __this__row_groups;
        }
        if (other.isSetKey_value_metadata()) {
            ArrayList<KeyValue> __this__key_value_metadata = new ArrayList<KeyValue>();
            for (KeyValue keyValue : other.key_value_metadata) {
                __this__key_value_metadata.add(new KeyValue(keyValue));
            }
            this.key_value_metadata = __this__key_value_metadata;
        }
        if (other.isSetCreated_by()) {
            this.created_by = other.created_by;
        }
    }

    public FileMetaData deepCopy() {
        return new FileMetaData(this);
    }

    @Override
    public void clear() {
        this.setVersionIsSet(false);
        this.version = 0;
        this.schema = null;
        this.setNum_rowsIsSet(false);
        this.num_rows = 0L;
        this.row_groups = null;
        this.key_value_metadata = null;
        this.created_by = null;
    }

    public int getVersion() {
        return this.version;
    }

    public FileMetaData setVersion(int version) {
        this.version = version;
        this.setVersionIsSet(true);
        return this;
    }

    public void unsetVersion() {
        this.__isset_bit_vector.clear(0);
    }

    public boolean isSetVersion() {
        return this.__isset_bit_vector.get(0);
    }

    public void setVersionIsSet(boolean value) {
        this.__isset_bit_vector.set(0, value);
    }

    public int getSchemaSize() {
        return this.schema == null ? 0 : this.schema.size();
    }

    public Iterator<SchemaElement> getSchemaIterator() {
        return this.schema == null ? null : this.schema.iterator();
    }

    public void addToSchema(SchemaElement elem) {
        if (this.schema == null) {
            this.schema = new ArrayList<SchemaElement>();
        }
        this.schema.add(elem);
    }

    public List<SchemaElement> getSchema() {
        return this.schema;
    }

    public FileMetaData setSchema(List<SchemaElement> schema) {
        this.schema = schema;
        return this;
    }

    public void unsetSchema() {
        this.schema = null;
    }

    public boolean isSetSchema() {
        return this.schema != null;
    }

    public void setSchemaIsSet(boolean value) {
        if (!value) {
            this.schema = null;
        }
    }

    public long getNum_rows() {
        return this.num_rows;
    }

    public FileMetaData setNum_rows(long num_rows) {
        this.num_rows = num_rows;
        this.setNum_rowsIsSet(true);
        return this;
    }

    public void unsetNum_rows() {
        this.__isset_bit_vector.clear(1);
    }

    public boolean isSetNum_rows() {
        return this.__isset_bit_vector.get(1);
    }

    public void setNum_rowsIsSet(boolean value) {
        this.__isset_bit_vector.set(1, value);
    }

    public int getRow_groupsSize() {
        return this.row_groups == null ? 0 : this.row_groups.size();
    }

    public Iterator<RowGroup> getRow_groupsIterator() {
        return this.row_groups == null ? null : this.row_groups.iterator();
    }

    public void addToRow_groups(RowGroup elem) {
        if (this.row_groups == null) {
            this.row_groups = new ArrayList<RowGroup>();
        }
        this.row_groups.add(elem);
    }

    public List<RowGroup> getRow_groups() {
        return this.row_groups;
    }

    public FileMetaData setRow_groups(List<RowGroup> row_groups) {
        this.row_groups = row_groups;
        return this;
    }

    public void unsetRow_groups() {
        this.row_groups = null;
    }

    public boolean isSetRow_groups() {
        return this.row_groups != null;
    }

    public void setRow_groupsIsSet(boolean value) {
        if (!value) {
            this.row_groups = null;
        }
    }

    public int getKey_value_metadataSize() {
        return this.key_value_metadata == null ? 0 : this.key_value_metadata.size();
    }

    public Iterator<KeyValue> getKey_value_metadataIterator() {
        return this.key_value_metadata == null ? null : this.key_value_metadata.iterator();
    }

    public void addToKey_value_metadata(KeyValue elem) {
        if (this.key_value_metadata == null) {
            this.key_value_metadata = new ArrayList<KeyValue>();
        }
        this.key_value_metadata.add(elem);
    }

    public List<KeyValue> getKey_value_metadata() {
        return this.key_value_metadata;
    }

    public FileMetaData setKey_value_metadata(List<KeyValue> key_value_metadata) {
        this.key_value_metadata = key_value_metadata;
        return this;
    }

    public void unsetKey_value_metadata() {
        this.key_value_metadata = null;
    }

    public boolean isSetKey_value_metadata() {
        return this.key_value_metadata != null;
    }

    public void setKey_value_metadataIsSet(boolean value) {
        if (!value) {
            this.key_value_metadata = null;
        }
    }

    public String getCreated_by() {
        return this.created_by;
    }

    public FileMetaData setCreated_by(String created_by) {
        this.created_by = created_by;
        return this;
    }

    public void unsetCreated_by() {
        this.created_by = null;
    }

    public boolean isSetCreated_by() {
        return this.created_by != null;
    }

    public void setCreated_byIsSet(boolean value) {
        if (!value) {
            this.created_by = null;
        }
    }

    @Override
    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case VERSION: {
                if (value == null) {
                    this.unsetVersion();
                    break;
                }
                this.setVersion((Integer)value);
                break;
            }
            case SCHEMA: {
                if (value == null) {
                    this.unsetSchema();
                    break;
                }
                this.setSchema((List)value);
                break;
            }
            case NUM_ROWS: {
                if (value == null) {
                    this.unsetNum_rows();
                    break;
                }
                this.setNum_rows((Long)value);
                break;
            }
            case ROW_GROUPS: {
                if (value == null) {
                    this.unsetRow_groups();
                    break;
                }
                this.setRow_groups((List)value);
                break;
            }
            case KEY_VALUE_METADATA: {
                if (value == null) {
                    this.unsetKey_value_metadata();
                    break;
                }
                this.setKey_value_metadata((List)value);
                break;
            }
            case CREATED_BY: {
                if (value == null) {
                    this.unsetCreated_by();
                    break;
                }
                this.setCreated_by((String)value);
            }
        }
    }

    @Override
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case VERSION: {
                return this.getVersion();
            }
            case SCHEMA: {
                return this.getSchema();
            }
            case NUM_ROWS: {
                return this.getNum_rows();
            }
            case ROW_GROUPS: {
                return this.getRow_groups();
            }
            case KEY_VALUE_METADATA: {
                return this.getKey_value_metadata();
            }
            case CREATED_BY: {
                return this.getCreated_by();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case VERSION: {
                return this.isSetVersion();
            }
            case SCHEMA: {
                return this.isSetSchema();
            }
            case NUM_ROWS: {
                return this.isSetNum_rows();
            }
            case ROW_GROUPS: {
                return this.isSetRow_groups();
            }
            case KEY_VALUE_METADATA: {
                return this.isSetKey_value_metadata();
            }
            case CREATED_BY: {
                return this.isSetCreated_by();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof FileMetaData) {
            return this.equals((FileMetaData)that);
        }
        return false;
    }

    public boolean equals(FileMetaData that) {
        if (that == null) {
            return false;
        }
        boolean this_present_version = true;
        boolean that_present_version = true;
        if (this_present_version || that_present_version) {
            if (!this_present_version || !that_present_version) {
                return false;
            }
            if (this.version != that.version) {
                return false;
            }
        }
        boolean this_present_schema = this.isSetSchema();
        boolean that_present_schema = that.isSetSchema();
        if (this_present_schema || that_present_schema) {
            if (!this_present_schema || !that_present_schema) {
                return false;
            }
            if (!this.schema.equals(that.schema)) {
                return false;
            }
        }
        boolean this_present_num_rows = true;
        boolean that_present_num_rows = true;
        if (this_present_num_rows || that_present_num_rows) {
            if (!this_present_num_rows || !that_present_num_rows) {
                return false;
            }
            if (this.num_rows != that.num_rows) {
                return false;
            }
        }
        boolean this_present_row_groups = this.isSetRow_groups();
        boolean that_present_row_groups = that.isSetRow_groups();
        if (this_present_row_groups || that_present_row_groups) {
            if (!this_present_row_groups || !that_present_row_groups) {
                return false;
            }
            if (!this.row_groups.equals(that.row_groups)) {
                return false;
            }
        }
        boolean this_present_key_value_metadata = this.isSetKey_value_metadata();
        boolean that_present_key_value_metadata = that.isSetKey_value_metadata();
        if (this_present_key_value_metadata || that_present_key_value_metadata) {
            if (!this_present_key_value_metadata || !that_present_key_value_metadata) {
                return false;
            }
            if (!this.key_value_metadata.equals(that.key_value_metadata)) {
                return false;
            }
        }
        boolean this_present_created_by = this.isSetCreated_by();
        boolean that_present_created_by = that.isSetCreated_by();
        if (this_present_created_by || that_present_created_by) {
            if (!this_present_created_by || !that_present_created_by) {
                return false;
            }
            if (!this.created_by.equals(that.created_by)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_version = true;
        builder.append(present_version);
        if (present_version) {
            builder.append(this.version);
        }
        boolean present_schema = this.isSetSchema();
        builder.append(present_schema);
        if (present_schema) {
            builder.append(this.schema);
        }
        boolean present_num_rows = true;
        builder.append(present_num_rows);
        if (present_num_rows) {
            builder.append(this.num_rows);
        }
        boolean present_row_groups = this.isSetRow_groups();
        builder.append(present_row_groups);
        if (present_row_groups) {
            builder.append(this.row_groups);
        }
        boolean present_key_value_metadata = this.isSetKey_value_metadata();
        builder.append(present_key_value_metadata);
        if (present_key_value_metadata) {
            builder.append(this.key_value_metadata);
        }
        boolean present_created_by = this.isSetCreated_by();
        builder.append(present_created_by);
        if (present_created_by) {
            builder.append((Object)this.created_by);
        }
        return builder.toHashCode();
    }

    @Override
    public int compareTo(FileMetaData other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        FileMetaData typedOther = other;
        lastComparison = Boolean.valueOf(this.isSetVersion()).compareTo(typedOther.isSetVersion());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetVersion() && (lastComparison = TBaseHelper.compareTo(this.version, typedOther.version)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSchema()).compareTo(typedOther.isSetSchema());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSchema() && (lastComparison = TBaseHelper.compareTo(this.schema, typedOther.schema)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetNum_rows()).compareTo(typedOther.isSetNum_rows());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNum_rows() && (lastComparison = TBaseHelper.compareTo(this.num_rows, typedOther.num_rows)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetRow_groups()).compareTo(typedOther.isSetRow_groups());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRow_groups() && (lastComparison = TBaseHelper.compareTo(this.row_groups, typedOther.row_groups)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetKey_value_metadata()).compareTo(typedOther.isSetKey_value_metadata());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetKey_value_metadata() && (lastComparison = TBaseHelper.compareTo(this.key_value_metadata, typedOther.key_value_metadata)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCreated_by()).compareTo(typedOther.isSetCreated_by());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCreated_by() && (lastComparison = TBaseHelper.compareTo(this.created_by, typedOther.created_by)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin();
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 8) {
                        this.version = iprot.readI32();
                        this.setVersionIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 2: {
                    if (field.type == 15) {
                        TList _list16 = iprot.readListBegin();
                        this.schema = new ArrayList<SchemaElement>(_list16.size);
                        for (int _i17 = 0; _i17 < _list16.size; ++_i17) {
                            SchemaElement _elem18 = new SchemaElement();
                            _elem18.read(iprot);
                            this.schema.add(_elem18);
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 3: {
                    if (field.type == 10) {
                        this.num_rows = iprot.readI64();
                        this.setNum_rowsIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 4: {
                    if (field.type == 15) {
                        TList _list19 = iprot.readListBegin();
                        this.row_groups = new ArrayList<RowGroup>(_list19.size);
                        for (int _i20 = 0; _i20 < _list19.size; ++_i20) {
                            RowGroup _elem21 = new RowGroup();
                            _elem21.read(iprot);
                            this.row_groups.add(_elem21);
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 5: {
                    if (field.type == 15) {
                        TList _list22 = iprot.readListBegin();
                        this.key_value_metadata = new ArrayList<KeyValue>(_list22.size);
                        for (int _i23 = 0; _i23 < _list22.size; ++_i23) {
                            KeyValue _elem24 = new KeyValue();
                            _elem24.read(iprot);
                            this.key_value_metadata.add(_elem24);
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 6: {
                    if (field.type == 11) {
                        this.created_by = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        if (!this.isSetVersion()) {
            throw new TProtocolException("Required field 'version' was not found in serialized data! Struct: " + this.toString());
        }
        if (!this.isSetNum_rows()) {
            throw new TProtocolException("Required field 'num_rows' was not found in serialized data! Struct: " + this.toString());
        }
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(VERSION_FIELD_DESC);
        oprot.writeI32(this.version);
        oprot.writeFieldEnd();
        if (this.schema != null) {
            oprot.writeFieldBegin(SCHEMA_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.schema.size()));
            for (SchemaElement _iter25 : this.schema) {
                _iter25.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(NUM_ROWS_FIELD_DESC);
        oprot.writeI64(this.num_rows);
        oprot.writeFieldEnd();
        if (this.row_groups != null) {
            oprot.writeFieldBegin(ROW_GROUPS_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.row_groups.size()));
            for (RowGroup _iter26 : this.row_groups) {
                _iter26.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        if (this.key_value_metadata != null && this.isSetKey_value_metadata()) {
            oprot.writeFieldBegin(KEY_VALUE_METADATA_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.key_value_metadata.size()));
            for (KeyValue _iter27 : this.key_value_metadata) {
                _iter27.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        if (this.created_by != null && this.isSetCreated_by()) {
            oprot.writeFieldBegin(CREATED_BY_FIELD_DESC);
            oprot.writeString(this.created_by);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FileMetaData(");
        boolean first = true;
        sb.append("version:");
        sb.append(this.version);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("schema:");
        if (this.schema == null) {
            sb.append("null");
        } else {
            sb.append(this.schema);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("num_rows:");
        sb.append(this.num_rows);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("row_groups:");
        if (this.row_groups == null) {
            sb.append("null");
        } else {
            sb.append(this.row_groups);
        }
        first = false;
        if (this.isSetKey_value_metadata()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("key_value_metadata:");
            if (this.key_value_metadata == null) {
                sb.append("null");
            } else {
                sb.append(this.key_value_metadata);
            }
            first = false;
        }
        if (this.isSetCreated_by()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("created_by:");
            if (this.created_by == null) {
                sb.append("null");
            } else {
                sb.append(this.created_by);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.schema == null) {
            throw new TProtocolException("Required field 'schema' was not present! Struct: " + this.toString());
        }
        if (this.row_groups == null) {
            throw new TProtocolException("Required field 'row_groups' was not present! Struct: " + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bit_vector = new BitSet(1);
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.VERSION, new FieldMetaData("version", 1, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.SCHEMA, new FieldMetaData("schema", 1, new ListMetaData(15, new StructMetaData(12, SchemaElement.class))));
        tmpMap.put(_Fields.NUM_ROWS, new FieldMetaData("num_rows", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.ROW_GROUPS, new FieldMetaData("row_groups", 1, new ListMetaData(15, new StructMetaData(12, RowGroup.class))));
        tmpMap.put(_Fields.KEY_VALUE_METADATA, new FieldMetaData("key_value_metadata", 2, new ListMetaData(15, new StructMetaData(12, KeyValue.class))));
        tmpMap.put(_Fields.CREATED_BY, new FieldMetaData("created_by", 2, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(FileMetaData.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        VERSION(1, "version"),
        SCHEMA(2, "schema"),
        NUM_ROWS(3, "num_rows"),
        ROW_GROUPS(4, "row_groups"),
        KEY_VALUE_METADATA(5, "key_value_metadata"),
        CREATED_BY(6, "created_by");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return VERSION;
                }
                case 2: {
                    return SCHEMA;
                }
                case 3: {
                    return NUM_ROWS;
                }
                case 4: {
                    return ROW_GROUPS;
                }
                case 5: {
                    return KEY_VALUE_METADATA;
                }
                case 6: {
                    return CREATED_BY;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

