/*
 * Decompiled with CFR 0.152.
 */
package org.tuckey.web.filters.urlrewrite.annotation;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.Filer;
import com.sun.mirror.apt.Messager;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.util.SourcePosition;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tuckey.web.filters.urlrewrite.annotation.HttpExceptionHandler;
import org.tuckey.web.filters.urlrewrite.annotation.HttpParam;
import org.tuckey.web.filters.urlrewrite.annotation.HttpUrl;

public class HttpUrlAnnotationProcessor
implements AnnotationProcessor {
    private AnnotationProcessorEnvironment environment;
    private AnnotationTypeDeclaration httpUrlDeclaration;
    private AnnotationTypeDeclaration httpExceptionHandlerDeclaration;
    private List<ProcessedHttpUrlAnnotation> processedAnnotations = new ArrayList<ProcessedHttpUrlAnnotation>();
    private List<ProcessedHttpExceptionAnnotation> httpExceptionHandlers = new ArrayList<ProcessedHttpExceptionAnnotation>();
    private Messager messager;
    private boolean showPositionsOfAnnotations = false;
    private boolean debug = false;

    public HttpUrlAnnotationProcessor(AnnotationProcessorEnvironment env) {
        this.environment = env;
        this.messager = env.getMessager();
        this.httpUrlDeclaration = (AnnotationTypeDeclaration)this.environment.getTypeDeclaration(HttpUrl.class.getName());
        this.httpExceptionHandlerDeclaration = (AnnotationTypeDeclaration)this.environment.getTypeDeclaration(HttpExceptionHandler.class.getName());
    }

    public void process() {
        PrintWriter pw;
        Map options = this.environment.getOptions();
        Set keys = options.keySet();
        String saveRulesTo = null;
        for (String key : keys) {
            if (key.startsWith("-AsaveRulesTo=")) {
                saveRulesTo = key.substring("-AsaveRulesTo=".length());
            }
            if (key.startsWith("-AshowPositions=")) {
                this.showPositionsOfAnnotations = "true".equalsIgnoreCase(key.substring("-AshowPositions=".length()));
            }
            if (!key.startsWith("-Adebug=")) continue;
            this.debug = "true".equalsIgnoreCase(key.substring("-Adebug=".length()));
        }
        this.debugMsg("Processing");
        if (saveRulesTo == null) {
            this.messager.printError("ERROR: conf option must be specified");
            return;
        }
        File confFile = new File(saveRulesTo);
        boolean delFile = false;
        try {
            if (!confFile.exists()) {
                HttpUrlAnnotationProcessor.checkDirsExistMkdir(confFile.getParentFile());
                confFile.createNewFile();
            }
            if (!confFile.canWrite()) {
                throw new IOException("cannot write to " + confFile.getName());
            }
            pw = this.environment.getFiler().createTextFile(Filer.Location.CLASS_TREE, "", confFile, null);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        try {
            this.debugMsg("Looking for @HttpUrl");
            Collection urlDeclarations = this.environment.getDeclarationsAnnotatedWith(this.httpUrlDeclaration);
            for (Declaration declaration : urlDeclarations) {
                ProcessedHttpUrlAnnotation pa = this.processHttpUrlAnnotation(declaration);
                if (pa == null) {
                    delFile = true;
                    continue;
                }
                this.processedAnnotations.add(pa);
            }
            this.debugMsg("Looking for @HttpExceptionHandler");
            Collection exceptionDeclarations = this.environment.getDeclarationsAnnotatedWith(this.httpExceptionHandlerDeclaration);
            for (Declaration declaration : exceptionDeclarations) {
                ProcessedHttpExceptionAnnotation phea = this.processHttpExceptionHandlerAnnotation(declaration);
                if (phea == null) {
                    delFile = true;
                    continue;
                }
                this.httpExceptionHandlers.add(phea);
            }
            if (this.processedAnnotations.size() > 0) {
                this.messager.printNotice("Got " + this.processedAnnotations.size() + " @HttpUrl annotations");
                Collections.sort(this.processedAnnotations);
            }
            if (this.httpExceptionHandlers.size() > 0) {
                this.messager.printNotice("Got " + this.httpExceptionHandlers.size() + " @HttpExceptionHandler annotations");
                Collections.sort(this.httpExceptionHandlers);
            }
            if (!delFile) {
                this.environment.getMessager().printNotice("Writing to " + confFile);
                this.outputRules(pw);
                this.outputExceptionHandlers(pw);
            } else {
                confFile.delete();
            }
        }
        catch (Throwable t) {
            delFile = true;
            t.printStackTrace();
        }
        if (delFile) {
            this.messager.printError("Error occured during processing deleting generated file.");
            confFile.delete();
        }
        pw.close();
    }

    private void outputRules(PrintWriter pw) {
        for (ProcessedHttpUrlAnnotation pa : this.processedAnnotations) {
            pw.println("<rule>");
            pw.println("    <name>" + pa.sourceRef + "</name>");
            if (!HttpUrlAnnotationProcessor.isBlank(pa.docComment)) {
                pw.println("    <note>");
                pw.println(HttpUrlAnnotationProcessor.padEachLine("        ", HttpUrlAnnotationProcessor.escapeXML(pa.docComment)));
                pw.println("    </note>");
            }
            pw.println("    <from>" + pa.value + "</from>");
            pw.println("    <run class=\"" + pa.className + "\" method=\"" + pa.methodName + pa.paramsFormatted + "\" />");
            if (!pa.chainUsed) {
                pw.println("    <to>null</to>");
            }
            pw.println("</rule>");
            pw.flush();
        }
    }

    private void outputExceptionHandlers(PrintWriter pw) {
        for (ProcessedHttpExceptionAnnotation pa : this.httpExceptionHandlers) {
            pw.println("<catch class=\"" + pa.exceptionName + "\">");
            if (!HttpUrlAnnotationProcessor.isBlank(pa.docComment)) {
                pw.println("    <note>");
                pw.println(HttpUrlAnnotationProcessor.padEachLine("        ", HttpUrlAnnotationProcessor.escapeXML(pa.docComment)));
                pw.println("    </note>");
            }
            pw.println("    <run class=\"" + pa.className + "\" method=\"" + pa.methodName + pa.paramsFormatted + "\"/>");
            pw.println("</catch>");
            pw.flush();
        }
    }

    private ProcessedHttpUrlAnnotation processHttpUrlAnnotation(Declaration declaration) {
        HttpUrl httpUrl = (HttpUrl)declaration.getAnnotation(HttpUrl.class);
        return new ProcessedHttpUrlAnnotation(HttpUrl.class.getName(), declaration, httpUrl.value(), httpUrl.weight());
    }

    private ProcessedHttpExceptionAnnotation processHttpExceptionHandlerAnnotation(Declaration declaration) {
        SourcePosition position = declaration.getPosition();
        if (!(declaration instanceof MethodDeclaration)) {
            this.messager.printWarning(declaration.getPosition(), "@HttpExceptionHandler declared on a non-method " + position);
            return null;
        }
        MethodDeclaration methodDeclaration = (MethodDeclaration)declaration;
        HttpExceptionHandler httpExceptionHandler = (HttpExceptionHandler)declaration.getAnnotation(HttpExceptionHandler.class);
        String className = methodDeclaration.getDeclaringType().getQualifiedName();
        ProcessedHttpExceptionAnnotation ea = new ProcessedHttpExceptionAnnotation();
        ea.exceptionName = httpExceptionHandler.value();
        ea.methodName = declaration.getSimpleName();
        ea.docComment = declaration.getDocComment();
        ea.className = className;
        ea.setParams(methodDeclaration.getParameters());
        if ("[ unassigned ]".equals(ea.exceptionName) && methodDeclaration.getParameters().size() > 0) {
            ea.exceptionName = ((ParameterDeclaration)methodDeclaration.getParameters().iterator().next()).getType().toString();
        }
        if (this.showPositionsOfAnnotations) {
            this.messager.printNotice(position, "@HttpExceptionHandlerUrl value " + ea.value + " weight " + ea.weight);
        }
        return ea;
    }

    private static String escapeXML(String s) {
        if (s == null) {
            return null;
        }
        int length = s.length();
        StringBuffer b = new StringBuffer();
        block5: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '&': {
                    b.append("&amp;");
                    continue block5;
                }
                case '<': {
                    b.append("&lt;");
                    continue block5;
                }
                case '>': {
                    b.append("&gt;");
                    continue block5;
                }
                default: {
                    b.append(c);
                }
            }
        }
        return b.toString();
    }

    private static String padEachLine(String padWith, String str) {
        StringBuffer out = new StringBuffer();
        String[] lines = str.split("\n");
        int i = 0;
        while (i < lines.length) {
            String line = lines[i];
            out.append(padWith);
            out.append(line);
            if (++i >= lines.length) continue;
            out.append('\n');
        }
        return out.toString();
    }

    private static boolean isBlank(String str) {
        return str == null || "".equals(str) || "".equals(str.trim());
    }

    private static void checkDirsExistMkdir(File dir) {
        if (!dir.getParentFile().exists()) {
            HttpUrlAnnotationProcessor.checkDirsExistMkdir(dir.getParentFile());
        }
        if (!dir.exists()) {
            dir.mkdir();
        }
    }

    private void debugMsg(String msg) {
        if (!this.debug) {
            return;
        }
        this.messager.printNotice("Debug: " + msg);
    }

    class ProcessedHttpExceptionAnnotation
    extends ProcessedHttpUrlAnnotation {
        public String exceptionName;

        ProcessedHttpExceptionAnnotation() {
        }

        public int compareTo(ProcessedHttpExceptionAnnotation other) {
            int comp = super.compareTo(other);
            if (comp == 0) {
                comp = this.exceptionName.compareTo(other.exceptionName);
            }
            return comp;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ProcessedHttpUrlAnnotation
    implements Comparable<ProcessedHttpUrlAnnotation> {
        public int weight = 0;
        public String value;
        public boolean chainUsed;
        public String paramsFormatted;
        public String methodName;
        public String className;
        public String docComment;
        public String sourceRef;
        private static final String FILTER_CHAIN_CLASS_NAME = "javax.servlet.FilterChain";

        public ProcessedHttpUrlAnnotation() {
        }

        public ProcessedHttpUrlAnnotation(String typeName, Declaration declaration, String value, int weight) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)declaration;
            String className = methodDeclaration.getDeclaringType().getQualifiedName();
            this.methodName = declaration.getSimpleName();
            this.docComment = declaration.getDocComment();
            this.className = className;
            this.value = value;
            this.weight = weight;
            this.setParams(methodDeclaration.getParameters());
            String typeNameShort = typeName.substring(typeName.lastIndexOf("."));
            SourcePosition positionInCode = declaration.getPosition();
            this.sourceRef = positionInCode.file().getName() + ":" + positionInCode.line();
            if (!(declaration instanceof MethodDeclaration)) {
                HttpUrlAnnotationProcessor.this.messager.printWarning(positionInCode, "@" + typeNameShort + " declared on a non-method " + positionInCode);
            }
            if (HttpUrlAnnotationProcessor.this.showPositionsOfAnnotations) {
                HttpUrlAnnotationProcessor.this.messager.printNotice(positionInCode, "@" + typeNameShort + " value " + value + " weight " + weight);
            }
        }

        @Override
        public int compareTo(ProcessedHttpUrlAnnotation other) {
            int comp;
            if (this.weight < other.weight) {
                return 1;
            }
            if (this.weight > other.weight) {
                return -1;
            }
            if (this.className != null && other.className != null && (comp = this.className.compareTo(other.className)) != 0) {
                return comp;
            }
            if (this.methodName != null && other.methodName != null) {
                return this.methodName.compareTo(other.methodName);
            }
            return 0;
        }

        void setParams(Collection<ParameterDeclaration> params) {
            this.paramsFormatted = "(";
            this.chainUsed = false;
            if (params.size() > 0) {
                int i = 1;
                for (ParameterDeclaration paramDeclaration : params) {
                    String paramType = paramDeclaration.getType().toString();
                    if (FILTER_CHAIN_CLASS_NAME.equals(paramType)) {
                        this.chainUsed = true;
                    }
                    this.paramsFormatted = this.paramsFormatted + (i == 1 ? "" : ", ") + paramType;
                    HttpParam httpParam = (HttpParam)paramDeclaration.getAnnotation(HttpParam.class);
                    if (httpParam != null) {
                        this.paramsFormatted = this.paramsFormatted + " ";
                        this.paramsFormatted = !"[ unassigned ]".equals(httpParam.value()) ? this.paramsFormatted + httpParam.value() : this.paramsFormatted + paramDeclaration.getSimpleName();
                    }
                    ++i;
                }
            }
            this.paramsFormatted = this.paramsFormatted + ")";
        }
    }
}

