/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core;

import com.orientechnologies.common.concur.resource.OSharedResourceAbstract;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.OOrientListener;
import com.orientechnologies.orient.core.OrientShutdownHook;
import com.orientechnologies.orient.core.command.script.OScriptManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseFactory;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.db.ODatabaseThreadLocalFactory;
import com.orientechnologies.orient.core.engine.OEngine;
import com.orientechnologies.orient.core.engine.local.OEngineLocal;
import com.orientechnologies.orient.core.engine.local.OEngineLocalPaginated;
import com.orientechnologies.orient.core.engine.memory.OEngineMemory;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.memory.OMemoryWatchDog;
import com.orientechnologies.orient.core.profiler.OJVMProfiler;
import com.orientechnologies.orient.core.record.ORecordFactoryManager;
import com.orientechnologies.orient.core.storage.OClusterFactory;
import com.orientechnologies.orient.core.storage.ODefaultClusterFactory;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.fs.OMMapManagerLocator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.atomic.AtomicInteger;

public class Orient
extends OSharedResourceAbstract {
    public static final String ORIENTDB_HOME = "ORIENTDB_HOME";
    public static final String URL_SYNTAX = "<engine>:<db-type>:<db-name>[?<db-param>=<db-value>[&]]*";
    protected static final Orient instance = new Orient();
    protected static boolean registerDatabaseByPath = false;
    protected final Map<String, OEngine> engines = new HashMap<String, OEngine>();
    protected final Map<String, OStorage> storages = new HashMap<String, OStorage>();
    protected final Set<ODatabaseLifecycleListener> dbLifecycleListeners = new HashSet<ODatabaseLifecycleListener>();
    protected final List<OOrientListener> listeners = new ArrayList<OOrientListener>();
    protected final ODatabaseFactory databaseFactory = new ODatabaseFactory();
    protected final OScriptManager scriptManager = new OScriptManager();
    protected OClusterFactory clusterFactory = new ODefaultClusterFactory();
    protected ORecordFactoryManager recordFactoryManager = new ORecordFactoryManager();
    protected OrientShutdownHook shutdownHook;
    protected final Timer timer = new Timer(true);
    protected final ThreadGroup threadGroup = new ThreadGroup("OrientDB");
    protected final AtomicInteger serialId = new AtomicInteger();
    protected OMemoryWatchDog memoryWatchDog;
    protected OJVMProfiler profiler;
    protected ODatabaseThreadLocalFactory databaseThreadFactory;
    protected volatile boolean active = false;

    protected Orient() {
        this.startup();
    }

    public Orient startup() {
        this.acquireExclusiveLock();
        try {
            if (this.active) {
                Orient orient = this;
                return orient;
            }
            this.shutdownHook = new OrientShutdownHook();
            this.profiler = new OJVMProfiler();
            this.registerEngine(new OEngineLocal());
            this.registerEngine(new OEngineLocalPaginated());
            this.registerEngine(new OEngineMemory());
            this.registerEngine("com.orientechnologies.orient.client.remote.OEngineRemote");
            if (OGlobalConfiguration.PROFILER_ENABLED.getValueAsBoolean()) {
                this.profiler.startRecording();
            }
            if (OGlobalConfiguration.ENVIRONMENT_DUMP_CFG_AT_STARTUP.getValueAsBoolean()) {
                OGlobalConfiguration.dumpConfiguration(System.out);
            }
            this.memoryWatchDog = new OMemoryWatchDog();
            this.active = true;
            Orient orient = this;
            return orient;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public Orient shutdown() {
        this.acquireExclusiveLock();
        try {
            if (!this.active) {
                Orient orient = this;
                return orient;
            }
            this.active = false;
            if (this.memoryWatchDog != null) {
                this.memoryWatchDog.interrupt();
                try {
                    this.memoryWatchDog.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.shutdownHook != null) {
                this.shutdownHook.cancel();
                this.shutdownHook = null;
            }
            OLogManager.instance().debug((Object)this, "Orient Engine is shutting down...", new Object[0]);
            if (this.listeners != null) {
                for (OOrientListener l : this.listeners) {
                    if (l == null) continue;
                    l.onShutdown();
                }
            }
            if (this.engines != null) {
                for (OEngine engine : this.engines.values()) {
                    engine.shutdown();
                }
                this.engines.clear();
            }
            if (this.databaseFactory != null) {
                this.databaseFactory.shutdown();
            }
            if (this.storages != null) {
                ArrayList<OStorage> storagesCopy = new ArrayList<OStorage>(this.storages.values());
                for (OStorage stg : storagesCopy) {
                    OLogManager.instance().info((Object)this, "Shutting down storage: " + stg.getName() + "...", new Object[0]);
                    stg.close(true);
                }
            }
            if (OMMapManagerLocator.getInstance() != null) {
                OMMapManagerLocator.getInstance().shutdown();
            }
            if (this.threadGroup != null) {
                this.threadGroup.interrupt();
            }
            if (this.listeners != null) {
                this.listeners.clear();
            }
            this.timer.cancel();
            if (this.profiler != null) {
                this.profiler.shutdown();
                this.profiler = null;
            }
            OLogManager.instance().info((Object)this, "Orient Engine shutdown complete\n", new Object[0]);
        }
        finally {
            this.releaseExclusiveLock();
        }
        return this;
    }

    public OStorage loadStorage(String iURL) {
        int pos;
        if (iURL == null || iURL.length() == 0) {
            throw new IllegalArgumentException("URL missed");
        }
        if (iURL.endsWith("/")) {
            iURL = iURL.substring(0, iURL.length() - 1);
        }
        if ((pos = iURL.indexOf(58)) <= 0) {
            throw new OConfigurationException("Error in database URL: the engine was not specified. Syntax is: <engine>:<db-type>:<db-name>[?<db-param>=<db-value>[&]]*. URL was: " + iURL);
        }
        String engineName = iURL.substring(0, pos);
        this.acquireExclusiveLock();
        try {
            OStorage storage;
            String dbName;
            OEngine engine = this.engines.get(engineName.toLowerCase());
            if (engine == null) {
                throw new OConfigurationException("Error on opening database: the engine '" + engineName + "' was not found. URL was: " + iURL + ". Registered engines are: " + this.engines.keySet());
            }
            iURL = iURL.substring(pos + 1);
            pos = iURL.indexOf(63);
            HashMap<String, String> parameters = null;
            String dbPath = null;
            if (pos > 0) {
                String[] pairs;
                dbPath = iURL.substring(0, pos);
                iURL = iURL.substring(pos + 1);
                parameters = new HashMap<String, String>();
                String[] stringArray = pairs = iURL.split("&");
                int n = pairs.length;
                int n2 = 0;
                while (n2 < n) {
                    String pair = stringArray[n2];
                    String[] kv = pair.split("=");
                    if (kv.length < 2) {
                        throw new OConfigurationException("Error on opening database: parameter has no value. Syntax is: <engine>:<db-type>:<db-name>[?<db-param>=<db-value>[&]]*. URL was: " + iURL);
                    }
                    parameters.put(kv[0], kv[1]);
                    ++n2;
                }
            } else {
                dbPath = iURL;
            }
            String string = dbName = registerDatabaseByPath ? dbPath : OIOUtils.getRelativePathIfAny((String)dbPath, null);
            if (engine.isShared()) {
                storage = this.storages.get(dbName);
                if (storage == null) {
                    storage = engine.createStorage(dbPath, parameters);
                    this.storages.put(dbName, storage);
                }
            } else {
                storage = engine.createStorage(dbPath, parameters);
                this.storages.put(String.valueOf(dbName) + "__" + this.serialId.incrementAndGet(), storage);
            }
            for (OOrientListener l : this.listeners) {
                l.onStorageRegistered(storage);
            }
            OStorage oStorage = storage;
            return oStorage;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public OStorage registerStorage(OStorage iStorage) throws IOException {
        this.acquireExclusiveLock();
        try {
            for (OOrientListener l : this.listeners) {
                l.onStorageRegistered(iStorage);
            }
            if (!this.storages.containsKey(iStorage.getName())) {
                this.storages.put(iStorage.getName(), iStorage);
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
        return iStorage;
    }

    public OStorage getStorage(String iDbName) {
        this.acquireSharedLock();
        try {
            OStorage oStorage = this.storages.get(iDbName);
            return oStorage;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public void registerEngine(OEngine iEngine) {
        this.acquireExclusiveLock();
        try {
            this.engines.put(iEngine.getName(), iEngine);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    private void registerEngine(String iClassName) {
        try {
            Class<?> cls = Class.forName(iClassName);
            this.registerEngine((OEngine)cls.newInstance());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public OEngine getEngine(String iEngineName) {
        this.acquireSharedLock();
        try {
            OEngine oEngine = this.engines.get(iEngineName);
            return oEngine;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public Set<String> getEngines() {
        this.acquireSharedLock();
        try {
            Set<String> set = Collections.unmodifiableSet(this.engines.keySet());
            return set;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public void unregisterStorageByName(String iName) {
        String dbName = registerDatabaseByPath ? iName : OIOUtils.getRelativePathIfAny((String)iName, null);
        OStorage stg = this.storages.get(dbName);
        this.unregisterStorage(stg);
    }

    public void unregisterStorage(OStorage iStorage) {
        if (!this.active) {
            return;
        }
        if (iStorage == null) {
            return;
        }
        this.acquireExclusiveLock();
        try {
            ArrayList<OOrientListener> listenerCopy = new ArrayList<OOrientListener>(this.listeners);
            for (OOrientListener l : listenerCopy) {
                this.listeners.remove(l);
                l.onStorageUnregistered(iStorage);
            }
            for (Map.Entry<String, OStorage> s : this.storages.entrySet()) {
                if (s.getValue() != iStorage) continue;
                this.storages.remove(s.getKey());
                break;
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public Collection<OStorage> getStorages() {
        try {
            this.acquireSharedLock();
            ArrayList<OStorage> arrayList = new ArrayList<OStorage>(this.storages.values());
            return arrayList;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void removeShutdownHook() {
        if (this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
    }

    public Iterator<ODatabaseLifecycleListener> getDbLifecycleListeners() {
        return this.dbLifecycleListeners.iterator();
    }

    public void addDbLifecycleListener(ODatabaseLifecycleListener iListener) {
        this.dbLifecycleListeners.add(iListener);
    }

    public void removeDbLifecycleListener(ODatabaseLifecycleListener iListener) {
        this.dbLifecycleListeners.remove(iListener);
    }

    public static Orient instance() {
        return instance;
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public ODatabaseThreadLocalFactory getDatabaseThreadFactory() {
        return this.databaseThreadFactory;
    }

    public OMemoryWatchDog getMemoryWatchDog() {
        return this.memoryWatchDog;
    }

    public ORecordFactoryManager getRecordFactoryManager() {
        return this.recordFactoryManager;
    }

    public OClusterFactory getClusterFactory() {
        return this.clusterFactory;
    }

    public ODatabaseFactory getDatabaseFactory() {
        return this.databaseFactory;
    }

    public void registerListener(OOrientListener iListener) {
        this.acquireExclusiveLock();
        try {
            if (!this.listeners.contains(iListener)) {
                this.listeners.add(iListener);
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void unregisterListener(OOrientListener iListener) {
        if (!this.active) {
            return;
        }
        this.acquireExclusiveLock();
        try {
            int i = 0;
            while (i < this.listeners.size()) {
                if (this.listeners.get(i) == iListener) {
                    this.listeners.remove(i);
                    break;
                }
                ++i;
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public List<OOrientListener> getListeners() {
        this.acquireExclusiveLock();
        try {
            ArrayList<OOrientListener> arrayList = new ArrayList<OOrientListener>(this.listeners);
            return arrayList;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void setRecordFactoryManager(ORecordFactoryManager iRecordFactoryManager) {
        this.recordFactoryManager = iRecordFactoryManager;
    }

    public static String getHomePath() {
        String v = System.getProperty("orient.home");
        if (v == null) {
            v = System.getProperty(ORIENTDB_HOME);
        }
        if (v == null) {
            v = System.getenv(ORIENTDB_HOME);
        }
        return v;
    }

    public void setClusterFactory(OClusterFactory clusterFactory) {
        this.clusterFactory = clusterFactory;
    }

    public OJVMProfiler getProfiler() {
        return this.profiler;
    }

    public void registerThreadDatabaseFactory(ODatabaseThreadLocalFactory iDatabaseFactory) {
        this.databaseThreadFactory = iDatabaseFactory;
    }

    public OScriptManager getScriptManager() {
        return this.scriptManager;
    }

    public static boolean isRegisterDatabaseByPath() {
        return registerDatabaseByPath;
    }

    public static void setRegisterDatabaseByPath(boolean iValue) {
        registerDatabaseByPath = iValue;
    }
}

