/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.cache;

import com.orientechnologies.common.collection.OLimitedMap;
import com.orientechnologies.common.concur.resource.OSharedResourceAdaptiveExternal;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OCache;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.memory.OMemoryWatchDog;
import com.orientechnologies.orient.core.record.ORecordInternal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class ODefaultCache
implements OCache {
    private static final int DEFAULT_LIMIT = 1000;
    private final OSharedResourceAdaptiveExternal lock = new OSharedResourceAdaptiveExternal(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean(), 0, true);
    private final AtomicBoolean enabled = new AtomicBoolean(false);
    private final OLinkedHashMapCache cache;
    private final int limit;
    protected OMemoryWatchDog.Listener lowMemoryListener;

    public ODefaultCache(String iName, int initialLimit) {
        int initialCapacity = initialLimit > 0 ? initialLimit : 1000;
        this.limit = initialLimit;
        this.cache = new OLinkedHashMapCache(initialCapacity, 0.75f, this.limit);
    }

    @Override
    public void startup() {
        this.lowMemoryListener = Orient.instance().getMemoryWatchDog().addListener(new OLowMemoryListener());
        this.enable();
    }

    @Override
    public void shutdown() {
        Orient.instance().getMemoryWatchDog().removeListener(this.lowMemoryListener);
        this.disable();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled.get();
    }

    @Override
    public boolean enable() {
        return this.enabled.compareAndSet(false, true);
    }

    @Override
    public boolean disable() {
        this.clear();
        return this.enabled.compareAndSet(true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORecordInternal<?> get(ORID id) {
        if (!this.isEnabled()) {
            return null;
        }
        this.lock.acquireExclusiveLock();
        try {
            ORecordInternal oRecordInternal = (ORecordInternal)this.cache.get(id);
            return oRecordInternal;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORecordInternal<?> put(ORecordInternal<?> record) {
        if (!this.isEnabled()) {
            return null;
        }
        this.lock.acquireExclusiveLock();
        try {
            ORecordInternal oRecordInternal = (ORecordInternal)this.cache.put(record.getIdentity(), record);
            return oRecordInternal;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORecordInternal<?> remove(ORID id) {
        if (!this.isEnabled()) {
            return null;
        }
        this.lock.acquireExclusiveLock();
        try {
            ORecordInternal oRecordInternal = (ORecordInternal)this.cache.remove(id);
            return oRecordInternal;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        if (!this.isEnabled()) {
            return;
        }
        this.lock.acquireExclusiveLock();
        try {
            this.cache.clear();
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.lock.acquireSharedLock();
        try {
            int n = this.cache.size();
            return n;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public int limit() {
        return this.limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ORID> keys() {
        this.lock.acquireExclusiveLock();
        try {
            ArrayList<ORID> arrayList = new ArrayList<ORID>(this.cache.keySet());
            return arrayList;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEldest(int threshold) {
        this.lock.acquireExclusiveLock();
        try {
            this.cache.removeEldest(threshold);
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    @Override
    public void lock(ORID id) {
        this.lock.acquireExclusiveLock();
    }

    @Override
    public void unlock(ORID id) {
        this.lock.releaseExclusiveLock();
    }

    class OLowMemoryListener
    implements OMemoryWatchDog.Listener {
        OLowMemoryListener() {
        }

        @Override
        public void memoryUsageLow(long freeMemory, long freeMemoryPercentage) {
            try {
                int oldSize = ODefaultCache.this.size();
                if (oldSize == 0) {
                    return;
                }
                if (freeMemoryPercentage < 10L) {
                    OLogManager.instance().debug((Object)this, "Low memory (%d%%): clearing %d cached records", new Object[]{freeMemoryPercentage, ODefaultCache.this.size()});
                    ODefaultCache.this.removeEldest(oldSize);
                } else {
                    int newSize = (int)((float)oldSize * 0.9f);
                    ODefaultCache.this.removeEldest(oldSize - newSize);
                    OLogManager.instance().debug((Object)this, "Low memory (%d%%): reducing cached records number from %d to %d", new Object[]{freeMemoryPercentage, oldSize, newSize});
                }
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Error occurred during default cache cleanup", (Throwable)e, new Object[0]);
            }
        }
    }

    static final class OLinkedHashMapCache
    extends OLimitedMap<ORID, ORecordInternal<?>> {
        public OLinkedHashMapCache(int initialCapacity, float loadFactor, int limit) {
            super(initialCapacity, loadFactor, limit);
        }

        void removeEldest(int amount) {
            ORID[] victims = new ORID[amount];
            int skip = this.size() - amount;
            int skipped = 0;
            int selected = 0;
            for (Map.Entry entry : this.entrySet()) {
                if (((ORecordInternal)entry.getValue()).isDirty() || ((ORecordInternal)entry.getValue()).isPinned() == Boolean.TRUE || skipped++ < skip) continue;
                victims[selected++] = (ORID)entry.getKey();
            }
            for (ORID id : victims) {
                this.remove(id);
            }
        }
    }
}

