/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.cache;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OAbstractRecordCache;
import com.orientechnologies.orient.core.cache.OCacheLevelTwoLocator;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.storage.OStorage;

public class OLevel2RecordCache
extends OAbstractRecordCache {
    private final String CACHE_HIT;
    private final String CACHE_MISS;
    private STRATEGY strategy;

    public OLevel2RecordCache(OStorage storage, OCacheLevelTwoLocator cacheLocator) {
        super(cacheLocator.primaryCache(storage.getName()));
        this.profilerPrefix = "db." + storage.getName() + ".cache.level2.";
        this.profilerMetadataPrefix = "db.*.cache.level2.";
        this.CACHE_HIT = String.valueOf(this.profilerPrefix) + "cache.found";
        this.CACHE_MISS = String.valueOf(this.profilerPrefix) + "cache.notFound";
        this.strategy = STRATEGY.values()[OGlobalConfiguration.CACHE_LEVEL2_STRATEGY.getValueAsInteger()];
    }

    @Override
    public void startup() {
        super.startup();
        this.setEnable(OGlobalConfiguration.CACHE_LEVEL2_ENABLED.getValueAsBoolean());
    }

    public void updateRecord(ORecordInternal<?> fresh) {
        if (!this.isEnabled() || fresh == null || fresh.isDirty() || fresh.getIdentity().isNew() || !fresh.getIdentity().isValid() || fresh.getIdentity().getClusterId() == this.excludedCluster || fresh.getRecordVersion().isTombstone()) {
            return;
        }
        if (fresh.isPinned() == null || fresh.isPinned().booleanValue()) {
            this.underlying.lock(fresh.getIdentity());
            try {
                ORecordInternal<?> current = this.underlying.get(fresh.getIdentity());
                if (current != null && current.getRecordVersion().compareTo(fresh.getRecordVersion()) >= 0) {
                    return;
                }
                if (ODatabaseRecordThreadLocal.INSTANCE.isDefined() && !ODatabaseRecordThreadLocal.INSTANCE.get().isClosed()) {
                    this.underlying.put((ORecordInternal)fresh.flatCopy());
                }
                fresh.detach();
                this.underlying.put(fresh);
            }
            finally {
                this.underlying.unlock(fresh.getIdentity());
            }
        } else {
            this.underlying.remove(fresh.getIdentity());
        }
    }

    protected ORecordInternal<?> retrieveRecord(ORID iRID) {
        ORecordInternal record;
        if (!this.isEnabled() || iRID.getClusterId() == this.excludedCluster) {
            return null;
        }
        this.underlying.lock(iRID);
        try {
            record = this.underlying.remove(iRID);
            if (record == null || record.isDirty()) {
                Orient.instance().getProfiler().updateCounter(this.CACHE_MISS, "Record not found in Level2 Cache", 1L, "db.*.cache.level2.cache.notFound");
                return null;
            }
            if (this.strategy == STRATEGY.COPY_RECORD) {
                ORecordInternal resident = OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean() ? (ORecordInternal)record.flatCopy() : record;
                this.underlying.put(resident);
            }
        }
        finally {
            this.underlying.unlock(iRID);
        }
        Orient.instance().getProfiler().updateCounter(this.CACHE_HIT, "Record found in Level2 Cache", 1L, "db.*.cache.level2.cache.found");
        return record;
    }

    public void setStrategy(STRATEGY newStrategy) {
        this.strategy = newStrategy;
    }

    public String toString() {
        return "STORAGE level2 cache records = " + this.getSize() + ", maxSize = " + this.getMaxSize();
    }

    public static enum STRATEGY {
        POP_RECORD,
        COPY_RECORD;

    }
}

