/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command.script;

import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.orient.core.command.OCommandRequestTextAbstract;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.serialization.OMemoryStream;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import javax.script.CompiledScript;

public class OCommandScript
extends OCommandRequestTextAbstract {
    private String language;
    private CompiledScript compiledScript;

    public OCommandScript() {
        this.useCache = true;
    }

    public OCommandScript(String iLanguage, String iText) {
        super(iText);
        this.language = iLanguage;
        this.useCache = true;
    }

    public OCommandScript(String iText) {
        super(iText);
    }

    @Override
    public boolean isIdempotent() {
        return false;
    }

    public String getLanguage() {
        return this.language;
    }

    public OCommandScript setLanguage(String language) {
        this.language = language;
        return this;
    }

    @Override
    public OSerializableStream fromStream(byte[] iStream) throws OSerializationException {
        OMemoryStream buffer = new OMemoryStream(iStream);
        this.language = buffer.getAsString();
        this.fromStream(buffer);
        return this;
    }

    @Override
    public byte[] toStream() throws OSerializationException {
        OMemoryStream buffer = new OMemoryStream();
        buffer.set(this.language);
        return this.toStream(buffer);
    }

    public void setCompiledScript(CompiledScript script) {
        this.compiledScript = script;
    }

    public CompiledScript getCompiledScript() {
        return this.compiledScript;
    }

    @Override
    public String toString() {
        if (this.language != null) {
            return this.language + "." + OIOUtils.getStringMaxLength((String)this.text, (int)50, (String)"...");
        }
        return "script." + this.text;
    }
}

