/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.document;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabasePooled;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentPool;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.raw.ODatabaseRaw;
import com.orientechnologies.orient.core.exception.ODatabaseException;

public class ODatabaseDocumentTxPooled
extends ODatabaseDocumentTx
implements ODatabasePooled {
    private ODatabaseDocumentPool ownerPool;

    public ODatabaseDocumentTxPooled(ODatabaseDocumentPool iOwnerPool, String iURL, String iUserName, String iUserPassword) {
        super(iURL);
        this.ownerPool = iOwnerPool;
        super.open(iUserName, iUserPassword);
    }

    @Override
    public void reuse(Object iOwner, Object[] iAdditionalArgs) {
        this.ownerPool = (ODatabaseDocumentPool)iOwner;
        this.getLevel1Cache().invalidate();
        ODatabaseRecordThreadLocal.INSTANCE.set(this);
        try {
            ODatabase current = this.underlying;
            while (!(current instanceof ODatabaseRaw) && ((ODatabaseComplex)current).getUnderlying() != null) {
                current = ((ODatabaseComplex)current).getUnderlying();
            }
            ((ODatabaseRaw)current).callOnOpenListeners();
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on reusing database '%s' in pool", (Throwable)e, new Object[]{this.getName()});
        }
    }

    @Override
    public ODatabaseDocumentTxPooled open(String iUserName, String iUserPassword) {
        throw new UnsupportedOperationException("Database instance was retrieved from a pool. You cannot open the database in this way. Use directly a ODatabaseDocumentTx instance if you want to manually open the connection");
    }

    @Override
    public ODatabaseDocumentTxPooled create() {
        throw new UnsupportedOperationException("Database instance was retrieved from a pool. You cannot open the database in this way. Use directly a ODatabaseDocumentTx instance if you want to manually open the connection");
    }

    @Override
    public boolean isUnderlyingOpen() {
        return !super.isClosed();
    }

    @Override
    public boolean isClosed() {
        return this.ownerPool == null || super.isClosed();
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.checkOpeness();
        try {
            this.rollback();
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on releasing database '%s' in pool", (Throwable)e, new Object[]{this.getName()});
        }
        try {
            ODatabase current = this.underlying;
            while (!(current instanceof ODatabaseRaw) && ((ODatabaseComplex)current).getUnderlying() != null) {
                current = ((ODatabaseComplex)current).getUnderlying();
            }
            ((ODatabaseRaw)current).callOnCloseListeners();
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on releasing database '%s' in pool", (Throwable)e, new Object[]{this.getName()});
        }
        this.getLevel1Cache().clear();
        ODatabaseDocumentPool localCopy = this.ownerPool;
        this.ownerPool = null;
        localCopy.release(this);
    }

    @Override
    public void forceClose() {
        super.close();
    }

    @Override
    protected void checkOpeness() {
        if (this.ownerPool == null) {
            throw new ODatabaseException("Database instance has been released to the pool. Get another database instance from the pool with the right username and password");
        }
        super.checkOpeness();
    }
}

