/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.graph;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordAbstract;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import com.orientechnologies.orient.core.tx.OTransactionNoTx;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRIDSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OGraphDatabase
extends ODatabaseDocumentTx {
    public static final String TYPE = "graph";
    public static final String VERTEX_CLASS_NAME = "OGraphVertex";
    public static final String VERTEX_ALIAS = "V";
    public static final String VERTEX_FIELD_IN = "in";
    public static final String VERTEX_FIELD_IN_EDGES = "inEdges";
    public static final String VERTEX_FIELD_OUT = "out";
    public static final String VERTEX_FIELD_OUT_EDGES = "outEdges";
    public static final String EDGE_CLASS_NAME = "OGraphEdge";
    public static final String EDGE_ALIAS = "E";
    public static final String EDGE_FIELD_IN = "in";
    public static final String EDGE_FIELD_OUT = "out";
    public static final String LABEL = "label";
    private boolean useCustomTypes = true;
    private boolean safeMode = false;
    private LOCK_MODE lockMode = LOCK_MODE.NO_LOCKING;
    protected OClass vertexBaseClass;
    protected OClass edgeBaseClass;

    public OGraphDatabase(String iURL) {
        super(iURL);
    }

    public OGraphDatabase(ODatabaseRecordTx iSource) {
        super(iSource);
        this.checkForGraphSchema();
    }

    @Override
    public <THISDB extends ODatabase> THISDB open(String iUserName, String iUserPassword) {
        super.open(iUserName, iUserPassword);
        this.checkForGraphSchema();
        return (THISDB)this;
    }

    @Override
    public <THISDB extends ODatabase> THISDB create() {
        super.create();
        this.checkForGraphSchema();
        return (THISDB)this;
    }

    @Override
    public void close() {
        super.close();
        this.vertexBaseClass = null;
        this.edgeBaseClass = null;
    }

    public long countVertexes() {
        return this.countClass(VERTEX_ALIAS);
    }

    public long countEdges() {
        return this.countClass(EDGE_ALIAS);
    }

    public Iterable<ODocument> browseVertices() {
        return this.browseElements(VERTEX_ALIAS, true);
    }

    public Iterable<ODocument> browseVertices(boolean iPolymorphic) {
        return this.browseElements(VERTEX_ALIAS, iPolymorphic);
    }

    public Iterable<ODocument> browseEdges() {
        return this.browseElements(EDGE_ALIAS, true);
    }

    public Iterable<ODocument> browseEdges(boolean iPolymorphic) {
        return this.browseElements(EDGE_ALIAS, iPolymorphic);
    }

    public Iterable<ODocument> browseElements(String iClass, boolean iPolymorphic) {
        return new ORecordIteratorClass<ODocument>(this, (ODatabaseRecordAbstract)this.getUnderlying(), iClass, iPolymorphic, true, false);
    }

    public ODocument createVertex() {
        return this.createVertex(null);
    }

    public ODocument createVertex(String iClassName) {
        return this.createVertex(iClassName, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ODocument createVertex(String iClassName, Object ... iFields) {
        OClass cls = this.checkVertexClass(iClassName);
        ODocument vertex = new ODocument(cls).setOrdered(true);
        if (iFields == null || iFields == null) return vertex;
        if (iFields.length == 1) {
            Object f = iFields[0];
            if (!(f instanceof Map)) throw new IllegalArgumentException("Invalid fields: expecting a pairs of fields as String,Object or a single Map<String,Object>, but found: " + f);
            vertex.fields((Map)f);
            return vertex;
        } else {
            int i = 0;
            while (i < iFields.length) {
                vertex.field(iFields[i].toString(), iFields[i + 1]);
                i += 2;
            }
        }
        return vertex;
    }

    public ODocument createEdge(ORID iSourceVertexRid, ORID iDestVertexRid) {
        return this.createEdge(iSourceVertexRid, iDestVertexRid, null);
    }

    public ODocument createEdge(ORID iSourceVertexRid, ORID iDestVertexRid, String iClassName) {
        ODocument sourceVertex = (ODocument)this.load(iSourceVertexRid);
        if (sourceVertex == null) {
            throw new IllegalArgumentException("Source vertex '" + iSourceVertexRid + "' does not exist");
        }
        ODocument destVertex = (ODocument)this.load(iDestVertexRid);
        if (destVertex == null) {
            throw new IllegalArgumentException("Source vertex '" + iDestVertexRid + "' does not exist");
        }
        return this.createEdge(sourceVertex, destVertex, iClassName);
    }

    public ODocument createEdge(ODocument iSourceVertex, ODocument iDestVertex) {
        return this.createEdge(iSourceVertex, iDestVertex, null);
    }

    public ODocument createEdge(ODocument iOutVertex, ODocument iInVertex, String iClassName) {
        return this.createEdge(iOutVertex, iInVertex, iClassName, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ODocument createEdge(ODocument iOutVertex, ODocument iInVertex, String iClassName, Object ... iFields) {
        if (iOutVertex == null) {
            throw new IllegalArgumentException("iOutVertex is null");
        }
        if (iInVertex == null) {
            throw new IllegalArgumentException("iInVertex is null");
        }
        OClass cls = this.checkEdgeClass(iClassName);
        boolean safeMode = this.beginBlock();
        try {
            ODocument edge = new ODocument(cls).setOrdered(true);
            edge.field("out", iOutVertex);
            edge.field("in", iInVertex);
            if (iFields != null) {
                if (iFields.length == 1) {
                    Object f = iFields[0];
                    if (!(f instanceof Map)) throw new IllegalArgumentException("Invalid fields: expecting a pairs of fields as String,Object or a single Map<String,Object>, but found: " + f);
                    edge.fields((Map)f);
                } else {
                    int i = 0;
                    while (i < iFields.length) {
                        edge.field(iFields[i].toString(), iFields[i + 1]);
                        i += 2;
                    }
                }
            }
            this.acquireWriteLock(iOutVertex);
            try {
                OMVRBTreeRIDSet out;
                Object outField = iOutVertex.field("out");
                if (outField instanceof OMVRBTreeRIDSet) {
                    out = (OMVRBTreeRIDSet)outField;
                } else if (outField instanceof Collection) {
                    out = new OMVRBTreeRIDSet(iOutVertex, (Collection)outField);
                    iOutVertex.field("out", out);
                } else {
                    out = new OMVRBTreeRIDSet(iOutVertex);
                    iOutVertex.field("out", out);
                }
                out.add(edge);
            }
            finally {
                this.releaseWriteLock(iOutVertex);
            }
            this.acquireWriteLock(iInVertex);
            try {
                OMVRBTreeRIDSet in;
                Object inField = iInVertex.field("in");
                if (inField instanceof OMVRBTreeRIDSet) {
                    in = (OMVRBTreeRIDSet)inField;
                } else if (inField instanceof Collection) {
                    in = new OMVRBTreeRIDSet(iInVertex, (Collection)inField);
                    iInVertex.field("in", in);
                } else {
                    in = new OMVRBTreeRIDSet(iInVertex);
                    iInVertex.field("in", in);
                }
                in.add(edge);
            }
            finally {
                this.releaseWriteLock(iInVertex);
            }
            edge.setDirty();
            if (!safeMode) return edge;
            this.save(edge);
            this.commitBlock(safeMode);
            return edge;
        }
        catch (RuntimeException e) {
            this.rollbackBlock(safeMode);
            throw e;
        }
    }

    public boolean removeEdge(OIdentifiable iEdge) {
        if (iEdge == null) {
            return false;
        }
        ODocument edge = (ODocument)iEdge.getRecord();
        if (edge == null) {
            return false;
        }
        boolean safeMode = this.beginBlock();
        try {
            ODocument outVertex = (ODocument)edge.field("out");
            this.acquireWriteLock(outVertex);
            try {
                if (outVertex != null) {
                    OMVRBTreeRIDSet out = this.getEdgeSet(outVertex, "out");
                    if (out != null) {
                        out.remove(edge);
                    }
                    this.save(outVertex);
                }
            }
            finally {
                this.releaseWriteLock(outVertex);
            }
            ODocument inVertex = (ODocument)edge.field("in");
            this.acquireWriteLock(inVertex);
            try {
                if (inVertex != null) {
                    OMVRBTreeRIDSet in = this.getEdgeSet(inVertex, "in");
                    if (in != null) {
                        in.remove(edge);
                    }
                    this.save(inVertex);
                }
            }
            finally {
                this.releaseWriteLock(inVertex);
            }
            this.delete((ORecordInternal)edge);
            this.commitBlock(safeMode);
        }
        catch (RuntimeException e) {
            this.rollbackBlock(safeMode);
            throw e;
        }
        return true;
    }

    public boolean removeVertex(OIdentifiable iVertex) {
        if (iVertex == null) {
            return false;
        }
        ODocument vertex = (ODocument)iVertex.getRecord();
        if (vertex == null) {
            return false;
        }
        boolean safeMode = this.beginBlock();
        try {
            this.acquireWriteLock(vertex);
            try {
                OMVRBTreeRIDSet otherEdges;
                ODocument otherVertex;
                ODocument edge;
                OMVRBTreeRIDSet edges = this.getEdgeSet(vertex, "out");
                if (edges != null) {
                    for (OIdentifiable e : edges) {
                        if (e == null || (edge = (ODocument)e.getRecord()) == null) continue;
                        otherVertex = (ODocument)edge.field("in");
                        if (otherVertex != null && (otherEdges = this.getEdgeSet(otherVertex, "in")) != null && otherEdges.remove(edge)) {
                            this.save(otherVertex);
                        }
                        this.delete((ORecordInternal)edge);
                    }
                }
                if ((edges = this.getEdgeSet(vertex, "in")) != null) {
                    for (OIdentifiable e : edges) {
                        if (e == null || e == null) continue;
                        edge = (ODocument)e.getRecord();
                        otherVertex = (ODocument)edge.field("out");
                        if (otherVertex != null && (otherEdges = this.getEdgeSet(otherVertex, "out")) != null && otherEdges.remove(edge)) {
                            this.save(otherVertex);
                        }
                        this.delete((ORecordInternal)edge);
                    }
                }
                this.delete((ORecordInternal)vertex);
            }
            finally {
                this.releaseWriteLock(vertex);
            }
            this.commitBlock(safeMode);
            return true;
        }
        catch (RuntimeException e) {
            this.rollbackBlock(safeMode);
            throw e;
        }
    }

    public Set<OIdentifiable> getEdgesBetweenVertexes(OIdentifiable iVertex1, OIdentifiable iVertex2) {
        return this.getEdgesBetweenVertexes(iVertex1, iVertex2, null, null);
    }

    public Set<OIdentifiable> getEdgesBetweenVertexes(OIdentifiable iVertex1, OIdentifiable iVertex2, String[] iLabels) {
        return this.getEdgesBetweenVertexes(iVertex1, iVertex2, iLabels, null);
    }

    public Set<OIdentifiable> getEdgesBetweenVertexes(OIdentifiable iVertex1, OIdentifiable iVertex2, String[] iLabels, String[] iClassNames) {
        HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
        if (iVertex1 != null && iVertex2 != null) {
            this.acquireReadLock(iVertex1);
            try {
                ODocument edge;
                for (OIdentifiable e : this.getOutEdges(iVertex1)) {
                    OIdentifiable in;
                    edge = (ODocument)e.getRecord();
                    if (!this.checkEdge(edge, iLabels, iClassNames) || (in = (OIdentifiable)edge.field("in")) == null || !in.equals(iVertex2)) continue;
                    result.add(edge);
                }
                for (OIdentifiable e : this.getInEdges(iVertex1)) {
                    OIdentifiable out;
                    edge = (ODocument)e.getRecord();
                    if (!this.checkEdge(edge, iLabels, iClassNames) || (out = (OIdentifiable)edge.field("out")) == null || !out.equals(iVertex2)) continue;
                    result.add(edge);
                }
            }
            finally {
                this.releaseReadLock(iVertex1);
            }
        }
        return result;
    }

    public Set<OIdentifiable> getOutEdges(OIdentifiable iVertex) {
        return this.getOutEdges(iVertex, null);
    }

    public Set<OIdentifiable> getOutEdges(OIdentifiable iVertex, String iLabel) {
        if (iVertex == null) {
            return null;
        }
        ODocument vertex = (ODocument)iVertex.getRecord();
        this.checkVertexClass(vertex);
        HashSet<OIdentifiable> result = null;
        this.acquireReadLock(iVertex);
        try {
            OMVRBTreeRIDSet set = this.getEdgeSet(vertex, "out");
            if (iLabel == null) {
                if (set != null) {
                    Set<OIdentifiable> set2 = Collections.unmodifiableSet(set);
                    return set2;
                }
                Set<OIdentifiable> set3 = Collections.emptySet();
                return set3;
            }
            result = new HashSet<OIdentifiable>();
            if (set != null) {
                for (OIdentifiable item : set) {
                    if (iLabel != null && !iLabel.equals(((ODocument)item).field(LABEL))) continue;
                    result.add(item);
                }
            }
        }
        finally {
            this.releaseReadLock(iVertex);
        }
        return result;
    }

    protected OMVRBTreeRIDSet getEdgeSet(ODocument iVertex, String iFieldName) {
        Object value = iVertex.field(iFieldName);
        if (value != null && value instanceof OMVRBTreeRIDSet) {
            return (OMVRBTreeRIDSet)value;
        }
        OMVRBTreeRIDSet set = new OMVRBTreeRIDSet();
        if (OMultiValue.isMultiValue(value)) {
            set.addAll((Collection)value);
        } else {
            set.add((OIdentifiable)value);
        }
        return set;
    }

    public Set<OIdentifiable> getOutEdgesHavingProperties(OIdentifiable iVertex, Map<String, Object> iProperties) {
        if (iVertex == null) {
            return null;
        }
        ODocument vertex = (ODocument)iVertex.getRecord();
        this.checkVertexClass(vertex);
        return this.filterEdgesByProperties(this.getEdgeSet(vertex, "out"), iProperties);
    }

    public Set<OIdentifiable> getOutEdgesHavingProperties(OIdentifiable iVertex, Iterable<String> iProperties) {
        if (iVertex == null) {
            return null;
        }
        ODocument vertex = (ODocument)iVertex.getRecord();
        this.checkVertexClass(vertex);
        return this.filterEdgesByProperties(this.getEdgeSet(vertex, "out"), iProperties);
    }

    public Set<OIdentifiable> getInEdges(OIdentifiable iVertex) {
        return this.getInEdges(iVertex, null);
    }

    public Set<OIdentifiable> getInEdges(OIdentifiable iVertex, String iLabel) {
        if (iVertex == null) {
            return null;
        }
        ODocument vertex = (ODocument)iVertex.getRecord();
        this.checkVertexClass(vertex);
        HashSet<OIdentifiable> result = null;
        this.acquireReadLock(iVertex);
        try {
            OMVRBTreeRIDSet set = this.getEdgeSet(vertex, "in");
            if (iLabel == null) {
                if (set != null) {
                    Set<OIdentifiable> set2 = Collections.unmodifiableSet(set);
                    return set2;
                }
                Set<OIdentifiable> set3 = Collections.emptySet();
                return set3;
            }
            result = new HashSet<OIdentifiable>();
            if (set != null) {
                for (OIdentifiable item : set) {
                    if (iLabel != null && !iLabel.equals(((ODocument)item).field(LABEL))) continue;
                    result.add(item);
                }
            }
        }
        finally {
            this.releaseReadLock(iVertex);
        }
        return result;
    }

    public Set<OIdentifiable> getInEdgesHavingProperties(OIdentifiable iVertex, Iterable<String> iProperties) {
        if (iVertex == null) {
            return null;
        }
        ODocument vertex = (ODocument)iVertex.getRecord();
        this.checkVertexClass(vertex);
        return this.filterEdgesByProperties(this.getEdgeSet(vertex, "in"), iProperties);
    }

    public Set<OIdentifiable> getInEdgesHavingProperties(ODocument iVertex, Map<String, Object> iProperties) {
        if (iVertex == null) {
            return null;
        }
        this.checkVertexClass(iVertex);
        return this.filterEdgesByProperties(this.getEdgeSet(iVertex, "in"), iProperties);
    }

    public ODocument getInVertex(OIdentifiable iEdge) {
        if (iEdge == null) {
            return null;
        }
        ODocument e = (ODocument)iEdge.getRecord();
        this.checkEdgeClass(e);
        OIdentifiable v = (OIdentifiable)e.field("in");
        if (v != null && v instanceof ORID) {
            v = v.getRecord();
            boolean wasDirty = e.isDirty();
            e.field("in", v);
            if (!wasDirty) {
                e.unsetDirty();
            }
        }
        return (ODocument)v;
    }

    public ODocument getOutVertex(OIdentifiable iEdge) {
        if (iEdge == null) {
            return null;
        }
        ODocument e = (ODocument)iEdge.getRecord();
        this.checkEdgeClass(e);
        OIdentifiable v = (OIdentifiable)e.field("out");
        if (v != null && v instanceof ORID) {
            v = v.getRecord();
            boolean wasDirty = e.isDirty();
            e.field("out", v);
            if (!wasDirty) {
                e.unsetDirty();
            }
        }
        return (ODocument)v;
    }

    public Set<OIdentifiable> filterEdgesByProperties(OMVRBTreeRIDSet iEdges, Iterable<String> iPropertyNames) {
        this.acquireReadLock(null);
        try {
            if (iPropertyNames == null) {
                if (iEdges != null) {
                    Set<OIdentifiable> set = Collections.unmodifiableSet(iEdges);
                    return set;
                }
                Set<OIdentifiable> set = Collections.emptySet();
                return set;
            }
            OMVRBTreeRIDSet result = new OMVRBTreeRIDSet();
            if (iEdges != null) {
                for (OIdentifiable item : iEdges) {
                    ODocument doc = (ODocument)item;
                    for (String propName : iPropertyNames) {
                        if (!doc.containsField(propName)) continue;
                        result.add(item);
                    }
                }
            }
            OMVRBTreeRIDSet oMVRBTreeRIDSet = result;
            return oMVRBTreeRIDSet;
        }
        finally {
            this.releaseReadLock(null);
        }
    }

    public Set<OIdentifiable> filterEdgesByProperties(OMVRBTreeRIDSet iEdges, Map<String, Object> iProperties) {
        this.acquireReadLock(null);
        try {
            if (iProperties == null) {
                if (iEdges != null) {
                    Set<OIdentifiable> set = Collections.unmodifiableSet(iEdges);
                    return set;
                }
                Set<OIdentifiable> set = Collections.emptySet();
                return set;
            }
            OMVRBTreeRIDSet result = new OMVRBTreeRIDSet();
            if (iEdges != null) {
                for (OIdentifiable item : iEdges) {
                    ODocument doc = (ODocument)item;
                    for (Map.Entry<String, Object> prop : iProperties.entrySet()) {
                        if (prop.getKey() == null || !doc.containsField(prop.getKey())) continue;
                        if (prop.getValue() == null) {
                            if (doc.field(prop.getKey()) != null) continue;
                            result.add(item);
                            continue;
                        }
                        if (!prop.getValue().equals(doc.field(prop.getKey()))) continue;
                        result.add(item);
                    }
                }
            }
            OMVRBTreeRIDSet oMVRBTreeRIDSet = result;
            return oMVRBTreeRIDSet;
        }
        finally {
            this.releaseReadLock(null);
        }
    }

    public ODocument getRoot(String iName) {
        return (ODocument)this.getDictionary().get(iName);
    }

    public ODocument getRoot(String iName, String iFetchPlan) {
        return (ODocument)this.getDictionary().get(iName, iFetchPlan);
    }

    public OGraphDatabase setRoot(String iName, ODocument iNode) {
        if (iNode == null) {
            this.getDictionary().remove(iName);
        } else {
            this.getDictionary().put(iName, iNode);
        }
        return this;
    }

    public OClass createVertexType(String iClassName) {
        return this.getMetadata().getSchema().createClass(iClassName, this.vertexBaseClass);
    }

    public OClass createVertexType(String iClassName, String iSuperClassName) {
        return this.getMetadata().getSchema().createClass(iClassName, this.checkVertexClass(iSuperClassName));
    }

    public OClass createVertexType(String iClassName, OClass iSuperClass) {
        this.checkVertexClass(iSuperClass);
        return this.getMetadata().getSchema().createClass(iClassName, iSuperClass);
    }

    public OClass getVertexType(String iClassName) {
        return this.getMetadata().getSchema().getClass(iClassName);
    }

    public OClass createEdgeType(String iClassName) {
        return this.getMetadata().getSchema().createClass(iClassName, this.edgeBaseClass);
    }

    public OClass createEdgeType(String iClassName, String iSuperClassName) {
        return this.getMetadata().getSchema().createClass(iClassName, this.checkEdgeClass(iSuperClassName));
    }

    public OClass createEdgeType(String iClassName, OClass iSuperClass) {
        this.checkEdgeClass(iSuperClass);
        return this.getMetadata().getSchema().createClass(iClassName, iSuperClass);
    }

    public OClass getEdgeType(String iClassName) {
        return this.getMetadata().getSchema().getClass(iClassName);
    }

    public boolean isSafeMode() {
        return this.safeMode;
    }

    public void setSafeMode(boolean safeMode) {
        this.safeMode = safeMode;
    }

    public OClass getVertexBaseClass() {
        return this.vertexBaseClass;
    }

    public OClass getEdgeBaseClass() {
        return this.edgeBaseClass;
    }

    public void checkVertexClass(ODocument iVertex) {
        iVertex.deserializeFields(new String[0]);
        if (this.useCustomTypes && !iVertex.getSchemaClass().isSubClassOf(this.vertexBaseClass)) {
            throw new IllegalArgumentException("The document received is not a vertex. Found class '" + iVertex.getSchemaClass() + "'");
        }
    }

    public OClass checkVertexClass(String iVertexTypeName) {
        if (iVertexTypeName == null || !this.useCustomTypes) {
            return this.getVertexBaseClass();
        }
        OClass cls = this.getMetadata().getSchema().getClass(iVertexTypeName);
        if (cls == null) {
            throw new IllegalArgumentException("The class '" + iVertexTypeName + "' was not found");
        }
        if (!cls.isSubClassOf(this.vertexBaseClass)) {
            throw new IllegalArgumentException("The class '" + iVertexTypeName + "' does not extend the vertex type");
        }
        return cls;
    }

    public void checkVertexClass(OClass iVertexType) {
        if (this.useCustomTypes && iVertexType != null && !iVertexType.isSubClassOf(this.vertexBaseClass)) {
            throw new IllegalArgumentException("The class '" + iVertexType + "' does not extend the vertex type");
        }
    }

    public void checkEdgeClass(ODocument iEdge) {
        iEdge.deserializeFields(new String[0]);
        if (this.useCustomTypes && !iEdge.getSchemaClass().isSubClassOf(this.edgeBaseClass)) {
            throw new IllegalArgumentException("The document received is not an edge. Found class '" + iEdge.getSchemaClass() + "'");
        }
    }

    public OClass checkEdgeClass(String iEdgeTypeName) {
        if (iEdgeTypeName == null || !this.useCustomTypes) {
            return this.getEdgeBaseClass();
        }
        OClass cls = this.getMetadata().getSchema().getClass(iEdgeTypeName);
        if (cls == null) {
            throw new IllegalArgumentException("The class '" + iEdgeTypeName + "' was not found");
        }
        if (!cls.isSubClassOf(this.edgeBaseClass)) {
            throw new IllegalArgumentException("The class '" + iEdgeTypeName + "' does not extend the edge type");
        }
        return cls;
    }

    public void checkEdgeClass(OClass iEdgeType) {
        if (this.useCustomTypes && iEdgeType != null && !iEdgeType.isSubClassOf(this.edgeBaseClass)) {
            throw new IllegalArgumentException("The class '" + iEdgeType + "' does not extend the edge type");
        }
    }

    public boolean isUseCustomTypes() {
        return this.useCustomTypes;
    }

    public void setUseCustomTypes(boolean useCustomTypes) {
        this.useCustomTypes = useCustomTypes;
    }

    public boolean isVertex(ODocument iRecord) {
        return iRecord != null ? iRecord.getSchemaClass().isSubClassOf(this.vertexBaseClass) : false;
    }

    public boolean isEdge(ODocument iRecord) {
        return iRecord != null ? iRecord.getSchemaClass().isSubClassOf(this.edgeBaseClass) : false;
    }

    public OGraphDatabase acquireWriteLock(OIdentifiable iRecord) {
        switch (this.lockMode) {
            case DATABASE_LEVEL_LOCKING: {
                this.getStorage().getLock().acquireExclusiveLock();
                break;
            }
            case RECORD_LEVEL_LOCKING: {
                ((OStorageEmbedded)this.getStorage()).acquireWriteLock(iRecord.getIdentity());
                break;
            }
        }
        return this;
    }

    public OGraphDatabase releaseWriteLock(OIdentifiable iRecord) {
        switch (this.lockMode) {
            case DATABASE_LEVEL_LOCKING: {
                this.getStorage().getLock().releaseExclusiveLock();
                break;
            }
            case RECORD_LEVEL_LOCKING: {
                ((OStorageEmbedded)this.getStorage()).releaseWriteLock(iRecord.getIdentity());
                break;
            }
        }
        return this;
    }

    public OGraphDatabase acquireReadLock(OIdentifiable iRecord) {
        switch (this.lockMode) {
            case DATABASE_LEVEL_LOCKING: {
                this.getStorage().getLock().acquireSharedLock();
                break;
            }
            case RECORD_LEVEL_LOCKING: {
                ((OStorageEmbedded)this.getStorage()).acquireReadLock(iRecord.getIdentity());
                break;
            }
        }
        return this;
    }

    public OGraphDatabase releaseReadLock(OIdentifiable iRecord) {
        switch (this.lockMode) {
            case DATABASE_LEVEL_LOCKING: {
                this.getStorage().getLock().releaseSharedLock();
                break;
            }
            case RECORD_LEVEL_LOCKING: {
                ((OStorageEmbedded)this.getStorage()).releaseReadLock(iRecord.getIdentity());
                break;
            }
        }
        return this;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public void checkForGraphSchema() {
        this.getMetadata().getSchema().getOrCreateClass("ORIDs");
        this.vertexBaseClass = this.getMetadata().getSchema().getClass(VERTEX_ALIAS);
        this.edgeBaseClass = this.getMetadata().getSchema().getClass(EDGE_ALIAS);
        if (this.vertexBaseClass == null) {
            this.vertexBaseClass = this.getMetadata().getSchema().createClass(VERTEX_ALIAS);
            this.vertexBaseClass.setOverSize(2.0f);
        }
        if (this.edgeBaseClass == null) {
            this.edgeBaseClass = this.getMetadata().getSchema().createClass(EDGE_ALIAS);
            this.edgeBaseClass.setShortName(EDGE_ALIAS);
        }
    }

    protected boolean beginBlock() {
        if (this.safeMode && !(this.getTransaction() instanceof OTransactionNoTx)) {
            this.begin();
            return true;
        }
        return false;
    }

    protected void commitBlock(boolean iOpenTxInSafeMode) {
        if (iOpenTxInSafeMode) {
            this.commit();
        }
    }

    protected void rollbackBlock(boolean iOpenTxInSafeMode) {
        if (iOpenTxInSafeMode) {
            this.rollback();
        }
    }

    protected boolean checkEdge(ODocument iEdge, String[] iLabels, String[] iClassNames) {
        String c;
        int n;
        int n2;
        String[] stringArray;
        boolean good = true;
        if (iClassNames != null) {
            good = false;
            stringArray = iClassNames;
            n2 = iClassNames.length;
            n = 0;
            while (n < n2) {
                c = stringArray[n];
                if (c.equals(iEdge.getClassName())) {
                    good = true;
                    break;
                }
                ++n;
            }
        }
        if (good && iLabels != null) {
            good = false;
            stringArray = iLabels;
            n2 = iLabels.length;
            n = 0;
            while (n < n2) {
                c = stringArray[n];
                if (c.equals(iEdge.field(LABEL))) {
                    good = true;
                    break;
                }
                ++n;
            }
        }
        return good;
    }

    public LOCK_MODE getLockMode() {
        return this.lockMode;
    }

    public void setLockMode(LOCK_MODE lockMode) {
        if (lockMode == LOCK_MODE.RECORD_LEVEL_LOCKING && !(this.getStorage() instanceof OStorageEmbedded)) {
            throw new IllegalArgumentException("Record leve locking is not supported for remote connections");
        }
        this.lockMode = lockMode;
    }

    public static enum DIRECTION {
        BOTH,
        IN,
        OUT;

    }

    public static enum LOCK_MODE {
        NO_LOCKING,
        DATABASE_LEVEL_LOCKING,
        RECORD_LEVEL_LOCKING;

    }
}

