/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.graph;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabasePooled;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.graph.OGraphDatabase;
import com.orientechnologies.orient.core.db.graph.OGraphDatabasePool;
import com.orientechnologies.orient.core.db.raw.ODatabaseRaw;
import com.orientechnologies.orient.core.exception.ODatabaseException;

public class OGraphDatabasePooled
extends OGraphDatabase
implements ODatabasePooled {
    private OGraphDatabasePool ownerPool;

    public OGraphDatabasePooled(OGraphDatabasePool iOwnerPool, String iURL, String iUserName, String iUserPassword) {
        super(iURL);
        this.ownerPool = iOwnerPool;
        super.open(iUserName, iUserPassword);
    }

    @Override
    public void reuse(Object iOwner, Object[] iAdditionalArgs) {
        this.ownerPool = (OGraphDatabasePool)iOwner;
        if (this.isClosed()) {
            this.open((String)iAdditionalArgs[0], (String)iAdditionalArgs[1]);
        }
        this.getLevel1Cache().invalidate();
        ODatabaseRecordThreadLocal.INSTANCE.set(this);
        this.checkForGraphSchema();
        try {
            ODatabase current = this.underlying;
            while (!(current instanceof ODatabaseRaw) && ((ODatabaseComplex)current).getUnderlying() != null) {
                current = ((ODatabaseComplex)current).getUnderlying();
            }
            ((ODatabaseRaw)current).callOnOpenListeners();
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on reusing database '%s' in pool", (Throwable)e, new Object[]{this.getName()});
        }
    }

    @Override
    public OGraphDatabasePooled open(String iUserName, String iUserPassword) {
        throw new UnsupportedOperationException("Database instance was retrieved from a pool. You cannot open the database in this way. Use directly a OGraphDatabase instance if you want to manually open the connection");
    }

    @Override
    public OGraphDatabasePooled create() {
        throw new UnsupportedOperationException("Database instance was retrieved from a pool. You cannot open the database in this way. Use directly a OGraphDatabase instance if you want to manually open the connection");
    }

    @Override
    public boolean isUnderlyingOpen() {
        return !super.isClosed();
    }

    @Override
    public boolean isClosed() {
        return this.ownerPool == null || super.isClosed();
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.vertexBaseClass = null;
        this.edgeBaseClass = null;
        this.checkOpeness();
        try {
            this.rollback();
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on releasing database '%s' in pool", (Throwable)e, new Object[]{this.getName()});
        }
        try {
            ODatabase current = this.underlying;
            while (!(current instanceof ODatabaseRaw) && ((ODatabaseComplex)current).getUnderlying() != null) {
                current = ((ODatabaseComplex)current).getUnderlying();
            }
            ((ODatabaseRaw)current).callOnCloseListeners();
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on releasing database '%s' in pool", (Throwable)e, new Object[]{this.getName()});
        }
        this.getLevel1Cache().clear();
        OGraphDatabasePool pool = this.ownerPool;
        this.ownerPool = null;
        pool.release(this);
    }

    @Override
    public void forceClose() {
        super.close();
    }

    @Override
    protected void checkOpeness() {
        if (this.ownerPool == null) {
            throw new ODatabaseException("Database instance has been released to the pool. Get another database instance from the pool with the right username and password");
        }
        super.checkOpeness();
    }
}

