/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OCacheLevelOneLocatorImpl;
import com.orientechnologies.orient.core.cache.OLevel1RecordCache;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestInternal;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODataSegmentStrategy;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.ODatabaseWrapperAbstract;
import com.orientechnologies.orient.core.db.ODefaultDataSegmentStrategy;
import com.orientechnologies.orient.core.db.raw.ODatabaseRaw;
import com.orientechnologies.orient.core.db.record.OClassTrigger;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.dictionary.ODictionary;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.fetch.OFetchHelper;
import com.orientechnologies.orient.core.hook.OHookThreadLocal;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.id.OClusterPosition;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OClassIndexManager;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.iterator.ORecordIteratorCluster;
import com.orientechnologies.orient.core.metadata.OMetadata;
import com.orientechnologies.orient.core.metadata.function.OFunctionTrigger;
import com.orientechnologies.orient.core.metadata.security.ORestrictedAccessHook;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.metadata.security.OUserTrigger;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.schedule.OSchedulerTrigger;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.tx.OTransactionRealAbstract;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public abstract class ODatabaseRecordAbstract
extends ODatabaseWrapperAbstract<ODatabaseRaw>
implements ODatabaseRecord {
    private OMetadata metadata;
    private OUser user;
    private static final String DEF_RECORD_FORMAT = "csv";
    private byte recordType;
    private String recordFormat;
    private Map<ORecordHook, ORecordHook.HOOK_POSITION> hooks = new LinkedHashMap<ORecordHook, ORecordHook.HOOK_POSITION>();
    private final Set<ORecordHook> unmodifiableHooks;
    private boolean retainRecords = true;
    private OLevel1RecordCache level1Cache;
    private boolean mvcc;
    private boolean validation;
    private ODataSegmentStrategy dataSegmentStrategy = new ODefaultDataSegmentStrategy();

    public ODatabaseRecordAbstract(String iURL, byte iRecordType) {
        super(new ODatabaseRaw(iURL));
        this.setCurrentDatabaseinThreadLocal();
        ((ODatabaseRaw)this.underlying).setOwner(this);
        this.unmodifiableHooks = Collections.unmodifiableSet(this.hooks.keySet());
        this.databaseOwner = this;
        this.recordType = iRecordType;
        this.level1Cache = new OLevel1RecordCache(new OCacheLevelOneLocatorImpl());
        this.mvcc = OGlobalConfiguration.DB_MVCC.getValueAsBoolean();
        this.validation = OGlobalConfiguration.DB_VALIDATION.getValueAsBoolean();
    }

    @Override
    public <DB extends ODatabase> DB open(String iUserName, String iUserPassword) {
        this.setCurrentDatabaseinThreadLocal();
        try {
            super.open(iUserName, iUserPassword);
            this.level1Cache.startup();
            this.metadata = new OMetadata();
            this.metadata.load();
            this.recordFormat = DEF_RECORD_FORMAT;
            if (!(this.getStorage() instanceof OStorageProxy)) {
                Set<ORole> roles;
                this.user = this.getMetadata().getSecurity().authenticate(iUserName, iUserPassword);
                if (this.user != null && ((roles = this.user.getRoles()) == null || roles.isEmpty() || roles.iterator().next() == null)) {
                    for (ODatabaseListener l : ((ODatabaseRaw)this.underlying).getListeners()) {
                        if (!l.onCorruptionRepairDatabase(this, "Security metadata is broken: current user '" + this.user.getName() + "' has no roles defined", "The 'admin' user will be reinstalled with default role ('admin') and password 'admin'")) continue;
                        this.user = null;
                        this.user = this.metadata.getSecurity().repair();
                        break;
                    }
                }
                this.registerHook(new OClassTrigger(), ORecordHook.HOOK_POSITION.FIRST);
                this.registerHook(new ORestrictedAccessHook(), ORecordHook.HOOK_POSITION.FIRST);
                this.registerHook(new OUserTrigger(), ORecordHook.HOOK_POSITION.EARLY);
                this.registerHook(new OFunctionTrigger(), ORecordHook.HOOK_POSITION.REGULAR);
                this.registerHook(new OClassIndexManager(), ORecordHook.HOOK_POSITION.LAST);
                this.registerHook(new OSchedulerTrigger(), ORecordHook.HOOK_POSITION.LAST);
            } else {
                this.user = new OUser(iUserName, OUser.encryptPassword(iUserPassword)).addRole(new ORole("passthrough", null, ORole.ALLOW_MODES.ALLOW_ALL_BUT));
            }
            this.checkSecurity("database", ORole.PERMISSION_READ);
            if (!this.metadata.getSchema().existsClass("ORIDs")) {
                this.metadata.getSchema().createClass("ORIDs");
            }
            if (this.metadata.getIndexManager().autoRecreateIndexesAfterCrash()) {
                this.metadata.getIndexManager().recreateIndexes();
            }
        }
        catch (OException e) {
            this.close();
            throw e;
        }
        catch (Exception e) {
            this.close();
            throw new ODatabaseException("Cannot open database", e);
        }
        return (DB)this;
    }

    @Override
    public <DB extends ODatabase> DB create() {
        this.setCurrentDatabaseinThreadLocal();
        try {
            super.create();
            this.level1Cache.startup();
            this.getStorage().getConfiguration().update();
            if (!(this.getStorage() instanceof OStorageProxy)) {
                this.registerHook(new OClassTrigger(), ORecordHook.HOOK_POSITION.FIRST);
                this.registerHook(new ORestrictedAccessHook(), ORecordHook.HOOK_POSITION.FIRST);
                this.registerHook(new OUserTrigger(), ORecordHook.HOOK_POSITION.EARLY);
                this.registerHook(new OFunctionTrigger(), ORecordHook.HOOK_POSITION.REGULAR);
                this.registerHook(new OClassIndexManager(), ORecordHook.HOOK_POSITION.LAST);
                this.registerHook(new OSchedulerTrigger(), ORecordHook.HOOK_POSITION.LAST);
            }
            this.metadata = new OMetadata();
            this.metadata.create();
            this.user = this.getMetadata().getSecurity().getUser("admin");
            if (!this.metadata.getSchema().existsClass("ORIDs")) {
                this.metadata.getSchema().createClass("ORIDs");
            }
        }
        catch (Exception e) {
            throw new ODatabaseException("Cannot create database", e);
        }
        return (DB)this;
    }

    @Override
    public void drop() {
        this.checkOpeness();
        this.checkSecurity("database", ORole.PERMISSION_DELETE);
        this.setCurrentDatabaseinThreadLocal();
        if (this.metadata != null) {
            this.metadata.close();
            this.metadata = null;
        }
        super.drop();
    }

    @Override
    public void close() {
        this.setCurrentDatabaseinThreadLocal();
        if (this.metadata != null) {
            OIndexManagerProxy indexManager;
            if (!(this.getStorage() instanceof OStorageProxy) && (indexManager = this.metadata.getIndexManager()) != null) {
                indexManager.waitTillIndexRestore();
            }
            this.metadata.close();
            this.metadata = null;
        }
        super.close();
        this.hooks.clear();
        this.user = null;
        this.level1Cache.shutdown();
        ODatabaseRecordThreadLocal.INSTANCE.remove();
    }

    @Override
    public ODictionary<ORecordInternal<?>> getDictionary() {
        this.checkOpeness();
        return this.metadata.getIndexManager().getDictionary();
    }

    @Override
    public <RET extends ORecordInternal<?>> RET getRecord(OIdentifiable iIdentifiable) {
        if (iIdentifiable instanceof ORecord) {
            return (RET)((ORecordInternal)iIdentifiable);
        }
        return (RET)this.load(iIdentifiable.getIdentity());
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORecordInternal<?> iRecord) {
        return this.load(iRecord, (String)null);
    }

    @Override
    public void reload() {
        this.metadata.reload();
        super.reload();
    }

    public <RET extends ORecordInternal<?>> RET reload(ORecordInternal<?> iRecord) {
        return this.executeReadRecord((ORecordId)iRecord.getIdentity(), iRecord, null, true, false);
    }

    public <RET extends ORecordInternal<?>> RET reload(ORecordInternal<?> iRecord, String iFetchPlan) {
        return this.executeReadRecord((ORecordId)iRecord.getIdentity(), iRecord, iFetchPlan, true, false);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET reload(ORecordInternal<?> iRecord, String iFetchPlan, boolean iIgnoreCache) {
        return this.executeReadRecord((ORecordId)iRecord.getIdentity(), iRecord, iFetchPlan, iIgnoreCache, false);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORecordInternal<?> iRecord, String iFetchPlan) {
        return this.executeReadRecord((ORecordId)iRecord.getIdentity(), iRecord, iFetchPlan, false, false);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORecordInternal<?> iRecord, String iFetchPlan, boolean iIgnoreCache) {
        return this.executeReadRecord((ORecordId)iRecord.getIdentity(), iRecord, iFetchPlan, iIgnoreCache, false);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORecordInternal<?> iRecord, String iFetchPlan, boolean iIgnoreCache, boolean loadTombstone) {
        return this.executeReadRecord((ORecordId)iRecord.getIdentity(), iRecord, iFetchPlan, iIgnoreCache, loadTombstone);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORID iRecordId) {
        return this.executeReadRecord((ORecordId)iRecordId, null, null, false, false);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORID iRecordId, String iFetchPlan) {
        return this.executeReadRecord((ORecordId)iRecordId, null, iFetchPlan, false, false);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORID iRecordId, String iFetchPlan, boolean iIgnoreCache) {
        return this.executeReadRecord((ORecordId)iRecordId, null, iFetchPlan, iIgnoreCache, false);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORID iRecordId, String iFetchPlan, boolean iIgnoreCache, boolean loadTombstone) {
        return this.executeReadRecord((ORecordId)iRecordId, null, iFetchPlan, iIgnoreCache, loadTombstone);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET save(ORecordInternal<?> iContent) {
        return this.executeSaveRecord(iContent, null, iContent.getRecordVersion(), iContent.getRecordType(), true, ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS, false, null, null);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET save(ORecordInternal<?> iContent, ODatabaseComplex.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<ORecordVersion> iRecordUpdatedCallback) {
        return this.executeSaveRecord(iContent, null, iContent.getRecordVersion(), iContent.getRecordType(), true, iMode, iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET save(ORecordInternal<?> iContent, String iClusterName) {
        return this.executeSaveRecord(iContent, iClusterName, iContent.getRecordVersion(), iContent.getRecordType(), true, ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS, false, null, null);
    }

    @Override
    public boolean updatedReplica(ORecordInternal<?> record) {
        return this.executeUpdateReplica(record);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET save(ORecordInternal<?> iContent, String iClusterName, ODatabaseComplex.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<ORecordVersion> iRecordUpdatedCallback) {
        return this.executeSaveRecord(iContent, iClusterName, iContent.getRecordVersion(), iContent.getRecordType(), true, iMode, iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback);
    }

    public ODatabaseRecord delete(ORID iRecord) {
        this.executeDeleteRecord(iRecord, OVersionFactory.instance().createUntrackedVersion(), true, true, ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS, false);
        return this;
    }

    public ODatabaseRecord delete(ORID iRecord, ORecordVersion iVersion) {
        this.executeDeleteRecord(iRecord, iVersion, true, true, ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS, false);
        return this;
    }

    public ODatabaseRecord cleanOutRecord(ORID iRecord, ORecordVersion iVersion) {
        this.executeDeleteRecord(iRecord, iVersion, true, true, ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS, true);
        return this;
    }

    public ODatabaseRecord delete(ORID iRecord, ODatabaseComplex.OPERATION_MODE iMode) {
        this.executeDeleteRecord(iRecord, OVersionFactory.instance().createUntrackedVersion(), true, true, iMode, false);
        return this;
    }

    public ODatabaseRecord delete(ORecordInternal<?> iRecord) {
        this.executeDeleteRecord(iRecord, OVersionFactory.instance().createUntrackedVersion(), true, true, ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS, false);
        return this;
    }

    public ODatabaseRecord delete(ORecordInternal<?> iRecord, ODatabaseComplex.OPERATION_MODE iMode) {
        this.executeDeleteRecord(iRecord, OVersionFactory.instance().createUntrackedVersion(), true, true, iMode, false);
        return this;
    }

    @Override
    public <REC extends ORecordInternal<?>> ORecordIteratorCluster<REC> browseCluster(String iClusterName, Class<REC> iClass) {
        this.checkSecurity("database.cluster", ORole.PERMISSION_READ, (Object)iClusterName);
        this.setCurrentDatabaseinThreadLocal();
        int clusterId = this.getClusterIdByName(iClusterName);
        return new ORecordIteratorCluster((ODatabaseRecord)this, this, clusterId, true);
    }

    @Override
    public <REC extends ORecordInternal<?>> ORecordIteratorCluster<REC> browseCluster(String iClusterName, Class<REC> iRecordClass, OClusterPosition startClusterPosition, OClusterPosition endClusterPosition, boolean loadTombstones) {
        this.checkSecurity("database.cluster", ORole.PERMISSION_READ, (Object)iClusterName);
        this.setCurrentDatabaseinThreadLocal();
        int clusterId = this.getClusterIdByName(iClusterName);
        return new ORecordIteratorCluster(this, this, clusterId, startClusterPosition, endClusterPosition, true, loadTombstones);
    }

    @Override
    public <REC extends ORecordInternal<?>> ORecordIteratorCluster<REC> browseCluster(String iClusterName, OClusterPosition startClusterPosition, OClusterPosition endClusterPosition, boolean loadTombstones) {
        this.checkSecurity("database.cluster", ORole.PERMISSION_READ, (Object)iClusterName);
        this.setCurrentDatabaseinThreadLocal();
        int clusterId = this.getClusterIdByName(iClusterName);
        return new ORecordIteratorCluster(this, this, clusterId, startClusterPosition, endClusterPosition, true, loadTombstones);
    }

    public ORecordIteratorCluster<?> browseCluster(String iClusterName) {
        this.checkSecurity("database.cluster", ORole.PERMISSION_READ, (Object)iClusterName);
        this.setCurrentDatabaseinThreadLocal();
        int clusterId = this.getClusterIdByName(iClusterName);
        return new ORecordIteratorCluster((ODatabaseRecord)this, this, clusterId, true);
    }

    @Override
    public OCommandRequest command(OCommandRequest iCommand) {
        this.checkSecurity("database.command", ORole.PERMISSION_READ);
        this.setCurrentDatabaseinThreadLocal();
        OCommandRequestInternal command = (OCommandRequestInternal)iCommand;
        try {
            command.reset();
            return command;
        }
        catch (Exception e) {
            throw new ODatabaseException("Error on command execution", e);
        }
    }

    @Override
    public <RET extends List<?>> RET query(OQuery<? extends Object> iCommand, Object ... iArgs) {
        this.setCurrentDatabaseinThreadLocal();
        iCommand.reset();
        return (RET)((List)iCommand.execute(iArgs));
    }

    @Override
    public byte getRecordType() {
        return this.recordType;
    }

    @Override
    public <RET> RET newInstance() {
        return (RET)Orient.instance().getRecordFactoryManager().newInstance(this.recordType);
    }

    @Override
    public long countClusterElements(int[] iClusterIds) {
        return this.countClusterElements(iClusterIds, false);
    }

    @Override
    public long countClusterElements(int iClusterId) {
        return this.countClusterElements(iClusterId, false);
    }

    @Override
    public long countClusterElements(int iClusterId, boolean countTombstones) {
        String name = this.getClusterNameById(iClusterId);
        if (name == null) {
            return 0L;
        }
        this.checkSecurity("database.cluster", ORole.PERMISSION_READ, (Object)name);
        this.setCurrentDatabaseinThreadLocal();
        return super.countClusterElements(iClusterId, countTombstones);
    }

    @Override
    public long countClusterElements(int[] iClusterIds, boolean countTombstones) {
        int[] nArray = iClusterIds;
        int n = iClusterIds.length;
        int n2 = 0;
        while (n2 < n) {
            int iClusterId = nArray[n2];
            String name = this.getClusterNameById(iClusterId);
            this.checkSecurity("database.cluster", ORole.PERMISSION_READ, (Object)name);
            ++n2;
        }
        return super.countClusterElements(iClusterIds, countTombstones);
    }

    @Override
    public long countClusterElements(String iClusterName) {
        this.checkSecurity("database.cluster", ORole.PERMISSION_READ, (Object)iClusterName);
        this.setCurrentDatabaseinThreadLocal();
        return super.countClusterElements(iClusterName);
    }

    @Override
    public OMetadata getMetadata() {
        this.checkOpeness();
        return this.metadata;
    }

    @Override
    public <DB extends ODatabaseRecord> DB checkSecurity(String iResource, int iOperation) {
        if (this.user != null) {
            try {
                this.user.allow(iResource, iOperation);
            }
            catch (OSecurityAccessException e) {
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "[checkSecurity] User '%s' tried to access to the reserved resource '%s', operation '%s'", new Object[]{this.getUser(), iResource, iOperation});
                }
                throw e;
            }
        }
        return (DB)this;
    }

    @Override
    public <DB extends ODatabaseRecord> DB checkSecurity(String iResourceGeneric, int iOperation, Object ... iResourcesSpecific) {
        if (this.user != null) {
            try {
                StringBuilder keyBuffer = new StringBuilder();
                boolean ruleFound = false;
                Object[] objectArray = iResourcesSpecific;
                int n = iResourcesSpecific.length;
                int n2 = 0;
                while (n2 < n) {
                    Object target = objectArray[n2];
                    if (target != null) {
                        keyBuffer.setLength(0);
                        keyBuffer.append(iResourceGeneric);
                        keyBuffer.append('.');
                        keyBuffer.append(target.toString());
                        String key = keyBuffer.toString();
                        if (this.user.isRuleDefined(key)) {
                            ruleFound = true;
                            this.user.allow(key, iOperation);
                        }
                    }
                    ++n2;
                }
                if (!ruleFound) {
                    keyBuffer.setLength(0);
                    keyBuffer.append(iResourceGeneric);
                    keyBuffer.append('.');
                    keyBuffer.append("*");
                    this.user.allow(keyBuffer.toString(), iOperation);
                }
            }
            catch (OSecurityAccessException e) {
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "[checkSecurity] User '%s' tried to access to the reserved resource '%s', target(s) '%s', operation '%s'", new Object[]{this.getUser(), iResourceGeneric, Arrays.toString(iResourcesSpecific), iOperation});
                }
                throw e;
            }
        }
        return (DB)this;
    }

    @Override
    public <DB extends ODatabaseRecord> DB checkSecurity(String iResourceGeneric, int iOperation, Object iResourceSpecific) {
        if (this.user != null) {
            try {
                StringBuilder keyBuffer = new StringBuilder();
                boolean ruleFound = false;
                if (iResourceSpecific != null) {
                    keyBuffer.setLength(0);
                    keyBuffer.append(iResourceGeneric);
                    keyBuffer.append('.');
                    keyBuffer.append(iResourceSpecific.toString());
                    String key = keyBuffer.toString();
                    if (this.user.isRuleDefined(key)) {
                        ruleFound = true;
                        this.user.allow(key, iOperation);
                    }
                }
                if (!ruleFound) {
                    keyBuffer.setLength(0);
                    keyBuffer.append(iResourceGeneric);
                    keyBuffer.append('.');
                    keyBuffer.append("*");
                    this.user.allow(keyBuffer.toString(), iOperation);
                }
            }
            catch (OSecurityAccessException e) {
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "[checkSecurity] User '%s' tried to access to the reserved resource '%s', target '%s', operation '%s'", new Object[]{this.getUser(), iResourceGeneric, iResourceSpecific, iOperation});
                }
                throw e;
            }
        }
        return (DB)this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <RET extends ORecordInternal<?>> RET executeReadRecord(ORecordId iRid, ORecordInternal<?> iRecord, String iFetchPlan, boolean iIgnoreCache, boolean loadTombstones) {
        this.checkOpeness();
        try {
            this.checkSecurity("database.cluster", ORole.PERMISSION_READ, (Object)this.getClusterNameById(iRid.getClusterId()));
            ORecordInternal<?> record = this.getTransaction().getRecord(iRid);
            if (record == OTransactionRealAbstract.DELETED_RECORD) {
                return null;
            }
            if (record == null && !iIgnoreCache) {
                record = this.getLevel1Cache().findRecord(iRid);
            }
            if (record != null) {
                if (iRecord != null) {
                    iRecord.fromStream(record.toStream());
                    iRecord.getRecordVersion().copyFrom(record.getRecordVersion());
                    record = iRecord;
                }
                OFetchHelper.checkFetchPlanValid(iFetchPlan);
                if (this.callbackHooks(ORecordHook.TYPE.BEFORE_READ, record) == ORecordHook.RESULT.SKIP) {
                    return null;
                }
                if (record.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
                    record.reload();
                }
                this.callbackHooks(ORecordHook.TYPE.AFTER_READ, record);
                return (RET)record;
            }
            ORawBuffer recordBuffer = ((ODatabaseRaw)this.underlying).read(iRid, iFetchPlan, iIgnoreCache, loadTombstones).getResult();
            if (recordBuffer == null) {
                return null;
            }
            if (iRecord == null || iRecord.getRecordType() != recordBuffer.recordType) {
                iRecord = Orient.instance().getRecordFactoryManager().newInstance(recordBuffer.recordType);
            }
            iRecord.fill(iRid, recordBuffer.version, recordBuffer.buffer, false);
            if (iRecord.getRecordVersion().isTombstone()) {
                return (RET)iRecord;
            }
            if (this.callbackHooks(ORecordHook.TYPE.BEFORE_READ, iRecord) == ORecordHook.RESULT.SKIP) {
                return null;
            }
            iRecord.fromStream(recordBuffer.buffer);
            this.callbackHooks(ORecordHook.TYPE.AFTER_READ, iRecord);
            if (!iIgnoreCache) {
                this.getLevel1Cache().updateRecord(iRecord);
            }
            return (RET)iRecord;
        }
        catch (OException e) {
            throw e;
        }
        catch (Exception e) {
            OLogManager.instance().exception("Error on retrieving record " + iRid, e, ODatabaseException.class, new Object[0]);
            return null;
        }
    }

    public <RET extends ORecordInternal<?>> RET executeSaveRecord(ORecordInternal<?> iRecord, String iClusterName, ORecordVersion iVersion, byte iRecordType, boolean iCallTriggers, ODatabaseComplex.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<ORecordVersion> iRecordUpdatedCallback) {
        this.checkOpeness();
        if (!iRecord.isDirty()) {
            return (RET)iRecord;
        }
        ORecordId rid = (ORecordId)iRecord.getIdentity();
        if (rid == null) {
            throw new ODatabaseException("Cannot create record because it has no identity. Probably is not a regular record or contains projections of fields rather than a full record");
        }
        this.setCurrentDatabaseinThreadLocal();
        try {
            boolean isNew;
            boolean wasNew;
            boolean bl = wasNew = iForceCreate || rid.isNew();
            if (wasNew && rid.clusterId == -1 && iClusterName != null) {
                rid.clusterId = this.getClusterIdByName(iClusterName);
            }
            byte[] stream = iRecord.toStream();
            boolean bl2 = isNew = iForceCreate || rid.isNew();
            if (isNew) {
                iRecord.onBeforeIdentityChanged(rid);
            } else if (stream == null || stream.length == 0) {
                return (RET)iRecord;
            }
            if (isNew && rid.clusterId < 0) {
                int n = rid.clusterId = iClusterName != null ? this.getClusterIdByName(iClusterName) : this.getDefaultClusterId();
            }
            if (rid.clusterId > -1 && iClusterName == null) {
                iClusterName = this.getClusterNameById(rid.clusterId);
            }
            if (stream != null && stream.length > 0 && iCallTriggers) {
                if (wasNew) {
                    this.checkSecurity("database.cluster", ORole.PERMISSION_CREATE, (Object)iClusterName);
                    if (this.callbackHooks(ORecordHook.TYPE.BEFORE_CREATE, iRecord) == ORecordHook.RESULT.RECORD_CHANGED) {
                        stream = iRecord.toStream();
                    }
                } else {
                    this.checkSecurity("database.cluster", ORole.PERMISSION_UPDATE, (Object)iClusterName);
                    if (this.callbackHooks(ORecordHook.TYPE.BEFORE_UPDATE, iRecord) == ORecordHook.RESULT.RECORD_CHANGED) {
                        stream = iRecord.toStream();
                    }
                }
            }
            if (!iRecord.isDirty()) {
                return (RET)iRecord;
            }
            ORecordVersion realVersion = !this.mvcc || iVersion.isUntracked() ? OVersionFactory.instance().createUntrackedVersion() : iRecord.getRecordVersion();
            int dataSegmentId = this.dataSegmentStrategy.assignDataSegmentId(this, iRecord);
            try {
                OStorageOperationResult<ORecordVersion> operationResult = ((ODatabaseRaw)this.underlying).save(dataSegmentId, rid, stream == null ? new byte[]{} : stream, realVersion, iRecord.getRecordType(), iMode.ordinal(), iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback);
                ORecordVersion version = operationResult.getResult();
                if (isNew) {
                    ((ORecordId)iRecord.getIdentity()).copyFrom(rid);
                    iRecord.onAfterIdentityChanged(iRecord);
                    iRecord.fill(rid, version, stream, stream == null || stream.length == 0);
                } else {
                    iRecord.fill(rid, version, stream, stream == null || stream.length == 0);
                }
                if (iCallTriggers && stream != null && stream.length > 0) {
                    if (!operationResult.isMoved()) {
                        this.callbackHooks(wasNew ? ORecordHook.TYPE.AFTER_CREATE : ORecordHook.TYPE.AFTER_UPDATE, iRecord);
                    } else {
                        this.callbackHooks(wasNew ? ORecordHook.TYPE.CREATE_REPLICATED : ORecordHook.TYPE.UPDATE_REPLICATED, iRecord);
                    }
                }
                if (stream != null && stream.length > 0 && !operationResult.isMoved()) {
                    this.getLevel1Cache().updateRecord(iRecord);
                }
            }
            catch (Throwable t) {
                if (iCallTriggers && stream != null && stream.length > 0) {
                    this.callbackHooks(wasNew ? ORecordHook.TYPE.CREATE_FAILED : ORecordHook.TYPE.UPDATE_FAILED, iRecord);
                }
                throw t;
            }
        }
        catch (OException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ODatabaseException("Error on saving record in cluster #" + iRecord.getIdentity().getClusterId(), t);
        }
        return (RET)iRecord;
    }

    public boolean executeUpdateReplica(ORecordInternal<?> record) {
        this.checkOpeness();
        ORecordId rid = (ORecordId)record.getIdentity();
        if (rid == null) {
            throw new ODatabaseException("Cannot create record because it has no identity. Probably is not a regular record or contains projections of fields rather than a full record");
        }
        if (rid.isNew()) {
            throw new ODatabaseException("Passed in record was not saved and can not be treated as replica");
        }
        return this.callInRecordLock(new ExecuteReplicaUpdateCallable(record), rid, true);
    }

    public void executeDeleteRecord(OIdentifiable iRecord, ORecordVersion iVersion, boolean iRequired, boolean iCallTriggers, ODatabaseComplex.OPERATION_MODE iMode, boolean prohibitTombstones) {
        this.checkOpeness();
        ORecordId rid = (ORecordId)iRecord.getIdentity();
        if (rid == null) {
            throw new ODatabaseException("Cannot delete record because it has no identity. Probably was created from scratch or contains projections of fields rather than a full record");
        }
        if (!rid.isValid()) {
            return;
        }
        this.checkSecurity("database.cluster", ORole.PERMISSION_DELETE, (Object)this.getClusterNameById(rid.clusterId));
        this.setCurrentDatabaseinThreadLocal();
        try {
            Object rec = iRecord.getRecord();
            if (iCallTriggers && rec != null) {
                this.callbackHooks(ORecordHook.TYPE.BEFORE_DELETE, (OIdentifiable)rec);
            }
            ORecordVersion realVersion = this.mvcc ? iVersion : OVersionFactory.instance().createUntrackedVersion();
            try {
                OStorageOperationResult<Boolean> operationResult = prohibitTombstones ? new OStorageOperationResult<Boolean>(((ODatabaseRaw)this.underlying).cleanOutRecord(rid, realVersion, iRequired, (byte)iMode.ordinal())) : ((ODatabaseRaw)this.underlying).delete(rid, realVersion, iRequired, (byte)iMode.ordinal());
                if (iCallTriggers) {
                    if (!operationResult.isMoved() && rec != null) {
                        this.callbackHooks(ORecordHook.TYPE.AFTER_DELETE, (OIdentifiable)rec);
                    } else if (rec != null) {
                        this.callbackHooks(ORecordHook.TYPE.DELETE_REPLICATED, (OIdentifiable)rec);
                    }
                }
                if (!operationResult.isMoved()) {
                    this.getLevel1Cache().deleteRecord(rid);
                }
            }
            catch (Throwable t) {
                if (iCallTriggers) {
                    this.callbackHooks(ORecordHook.TYPE.DELETE_FAILED, (OIdentifiable)rec);
                }
                throw t;
            }
        }
        catch (OException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ODatabaseException("Error on deleting record in cluster #" + iRecord.getIdentity().getClusterId(), t);
        }
    }

    @Override
    public ODatabaseComplex<?> getDatabaseOwner() {
        ODatabaseComplex<?> current = this.databaseOwner;
        while (current != null && current != this && current.getDatabaseOwner() != current) {
            current = current.getDatabaseOwner();
        }
        return current;
    }

    @Override
    public ODatabaseComplex<ORecordInternal<?>> setDatabaseOwner(ODatabaseComplex<?> iOwner) {
        this.databaseOwner = iOwner;
        return this;
    }

    @Override
    public boolean isRetainRecords() {
        return this.retainRecords;
    }

    @Override
    public ODatabaseRecord setRetainRecords(boolean retainRecords) {
        this.retainRecords = retainRecords;
        return this;
    }

    @Override
    public <DB extends ODatabase> DB setStatus(ODatabase.STATUS status) {
        String cmd = String.format("alter database status %s", status.toString());
        this.command(new OCommandSQL(cmd)).execute(new Object[0]);
        return (DB)this;
    }

    public void setStatusInternal(ODatabase.STATUS status) {
        ((ODatabaseRaw)this.underlying).setStatus(status);
    }

    public void setDefaultClusterIdInternal(int iDefClusterId) {
        this.getStorage().setDefaultClusterId(iDefClusterId);
    }

    @Override
    public void setInternal(ODatabase.ATTRIBUTES iAttribute, Object iValue) {
        ((ODatabaseRaw)this.underlying).set(iAttribute, iValue);
    }

    @Override
    public OUser getUser() {
        return this.user;
    }

    @Override
    public void setUser(OUser user) {
        this.user = user;
    }

    @Override
    public boolean isMVCC() {
        return this.mvcc;
    }

    @Override
    public <DB extends ODatabaseComplex<?>> DB setMVCC(boolean mvcc) {
        this.mvcc = mvcc;
        return (DB)this;
    }

    @Override
    public <DB extends ODatabaseComplex<?>> DB registerHook(ORecordHook iHookImpl, ORecordHook.HOOK_POSITION iPosition) {
        LinkedHashMap<ORecordHook, ORecordHook.HOOK_POSITION> tmp = new LinkedHashMap<ORecordHook, ORecordHook.HOOK_POSITION>(this.hooks);
        tmp.put(iHookImpl, iPosition);
        this.hooks.clear();
        ORecordHook.HOOK_POSITION[] hOOK_POSITIONArray = ORecordHook.HOOK_POSITION.values();
        int n = hOOK_POSITIONArray.length;
        int n2 = 0;
        while (n2 < n) {
            ORecordHook.HOOK_POSITION p = hOOK_POSITIONArray[n2];
            for (Map.Entry e : tmp.entrySet()) {
                if (e.getValue() != p) continue;
                this.hooks.put((ORecordHook)e.getKey(), (ORecordHook.HOOK_POSITION)((Object)e.getValue()));
            }
            ++n2;
        }
        return (DB)this;
    }

    @Override
    public <DB extends ODatabaseComplex<?>> DB registerHook(ORecordHook iHookImpl) {
        return this.registerHook(iHookImpl, ORecordHook.HOOK_POSITION.REGULAR);
    }

    @Override
    public <DB extends ODatabaseComplex<?>> DB unregisterHook(ORecordHook iHookImpl) {
        this.hooks.remove(iHookImpl);
        return (DB)this;
    }

    @Override
    public OLevel1RecordCache getLevel1Cache() {
        return this.level1Cache;
    }

    @Override
    public Set<ORecordHook> getHooks() {
        return this.unmodifiableHooks;
    }

    @Override
    public ORecordHook.RESULT callbackHooks(ORecordHook.TYPE iType, OIdentifiable id) {
        if (id == null || !OHookThreadLocal.INSTANCE.push(id)) {
            return ORecordHook.RESULT.RECORD_NOT_CHANGED;
        }
        try {
            Object rec = id.getRecord();
            if (rec == null) {
                ORecordHook.RESULT rESULT = ORecordHook.RESULT.RECORD_NOT_CHANGED;
                return rESULT;
            }
            boolean recordChanged = false;
            for (ORecordHook hook : this.hooks.keySet()) {
                ORecordHook.RESULT res = hook.onTrigger(iType, (ORecord<?>)rec);
                if (res == ORecordHook.RESULT.RECORD_CHANGED) {
                    recordChanged = true;
                    continue;
                }
                if (res != ORecordHook.RESULT.SKIP) continue;
                ORecordHook.RESULT rESULT = res;
                return rESULT;
            }
            ORecordHook.RESULT rESULT = recordChanged ? ORecordHook.RESULT.RECORD_CHANGED : ORecordHook.RESULT.RECORD_NOT_CHANGED;
            return rESULT;
        }
        finally {
            OHookThreadLocal.INSTANCE.pop(id);
        }
    }

    protected ORecordSerializer resolveFormat(Object iObject) {
        return ORecordSerializerFactory.instance().getFormatForObject(iObject, this.recordFormat);
    }

    @Override
    protected void checkOpeness() {
        if (this.isClosed()) {
            throw new ODatabaseException("Database '" + this.getURL() + "' is closed");
        }
    }

    protected void setCurrentDatabaseinThreadLocal() {
        ODatabaseRecordThreadLocal.INSTANCE.set(this);
    }

    @Override
    public boolean isValidationEnabled() {
        return !this.getStatus().equals((Object)ODatabase.STATUS.IMPORTING) && this.validation;
    }

    @Override
    public <DB extends ODatabaseRecord> DB setValidationEnabled(boolean iEnabled) {
        this.validation = iEnabled;
        return (DB)this;
    }

    @Override
    public ODataSegmentStrategy getDataSegmentStrategy() {
        return this.dataSegmentStrategy;
    }

    @Override
    public void setDataSegmentStrategy(ODataSegmentStrategy dataSegmentStrategy) {
        this.dataSegmentStrategy = dataSegmentStrategy;
    }

    private class ExecuteReplicaUpdateCallable
    implements Callable<Boolean> {
        private final ORecordId rid;
        private final ORecordInternal<?> record;

        public ExecuteReplicaUpdateCallable(ORecordInternal<?> record) {
            this.rid = (ORecordId)record.getIdentity();
            this.record = record;
        }

        @Override
        public Boolean call() throws Exception {
            boolean result;
            ORecordMetadata loadedRecordMetadata = ODatabaseRecordAbstract.this.getRecordMetadata(this.rid);
            if (loadedRecordMetadata == null) {
                result = this.processReplicaAdd();
            } else if (loadedRecordMetadata.getRecordVersion().compareTo(this.record.getRecordVersion()) < 0) {
                result = this.processReplicaUpdate(loadedRecordMetadata);
            } else {
                return false;
            }
            if (!result) {
                throw new IllegalStateException("Passed in replica was not stored in DB");
            }
            return true;
        }

        private boolean processReplicaUpdate(ORecordMetadata loadedRecordMetadata) throws Exception {
            boolean result;
            Object replicaToUpdate = this.record;
            ORecordVersion replicaVersion = this.record.getRecordVersion();
            byte recordType = this.record.getRecordType();
            try {
                if (loadedRecordMetadata.getRecordVersion().isTombstone() && !replicaVersion.isTombstone()) {
                    replicaToUpdate = this.mergeWithRecord(null);
                    ODatabaseRecordAbstract.this.callbackHooks(ORecordHook.TYPE.BEFORE_REPLICA_ADD, (OIdentifiable)replicaToUpdate);
                } else if (!loadedRecordMetadata.getRecordVersion().isTombstone() && !replicaVersion.isTombstone()) {
                    replicaToUpdate = this.mergeWithRecord(this.rid);
                    ODatabaseRecordAbstract.this.callbackHooks(ORecordHook.TYPE.BEFORE_REPLICA_UPDATE, (OIdentifiable)replicaToUpdate);
                } else if (!loadedRecordMetadata.getRecordVersion().isTombstone() && replicaVersion.isTombstone()) {
                    replicaToUpdate = ODatabaseRecordAbstract.this.load(this.rid, "*:0", false, true);
                    replicaToUpdate.getRecordVersion().copyFrom(replicaVersion);
                    ODatabaseRecordAbstract.this.callbackHooks(ORecordHook.TYPE.BEFORE_REPLICA_DELETE, (OIdentifiable)replicaToUpdate);
                }
                byte[] stream = replicaToUpdate.toStream();
                int dataSegmentId = ODatabaseRecordAbstract.this.dataSegmentStrategy.assignDataSegmentId(ODatabaseRecordAbstract.this, (ORecord<?>)replicaToUpdate);
                result = ((ODatabaseRaw)ODatabaseRecordAbstract.this.underlying).updateReplica(dataSegmentId, this.rid, stream, replicaVersion, recordType);
                if (loadedRecordMetadata.getRecordVersion().isTombstone() && !replicaVersion.isTombstone()) {
                    ODatabaseRecordAbstract.this.callbackHooks(ORecordHook.TYPE.AFTER_REPLICA_ADD, (OIdentifiable)replicaToUpdate);
                    replicaToUpdate.unsetDirty();
                    ODatabaseRecordAbstract.this.getLevel1Cache().updateRecord((ORecordInternal<?>)replicaToUpdate);
                } else if (!loadedRecordMetadata.getRecordVersion().isTombstone() && !replicaVersion.isTombstone()) {
                    ODatabaseRecordAbstract.this.callbackHooks(ORecordHook.TYPE.AFTER_REPLICA_UPDATE, (OIdentifiable)replicaToUpdate);
                    replicaToUpdate.unsetDirty();
                    ODatabaseRecordAbstract.this.getLevel1Cache().updateRecord((ORecordInternal<?>)replicaToUpdate);
                } else if (!loadedRecordMetadata.getRecordVersion().isTombstone() && replicaVersion.isTombstone()) {
                    ODatabaseRecordAbstract.this.callbackHooks(ORecordHook.TYPE.AFTER_REPLICA_DELETE, (OIdentifiable)replicaToUpdate);
                    replicaToUpdate.unsetDirty();
                    ODatabaseRecordAbstract.this.getLevel1Cache().deleteRecord(this.rid);
                }
            }
            catch (Exception e) {
                if (loadedRecordMetadata.getRecordVersion().isTombstone() && !replicaVersion.isTombstone()) {
                    ODatabaseRecordAbstract.this.callbackHooks(ORecordHook.TYPE.REPLICA_ADD_FAILED, (OIdentifiable)replicaToUpdate);
                } else if (!loadedRecordMetadata.getRecordVersion().isTombstone() && !replicaVersion.isTombstone()) {
                    ODatabaseRecordAbstract.this.callbackHooks(ORecordHook.TYPE.REPLICA_UPDATE_FAILED, (OIdentifiable)replicaToUpdate);
                } else if (!loadedRecordMetadata.getRecordVersion().isTombstone() && replicaVersion.isTombstone()) {
                    ODatabaseRecordAbstract.this.callbackHooks(ORecordHook.TYPE.REPLICA_DELETE_FAILED, (OIdentifiable)replicaToUpdate);
                }
                throw e;
            }
            return result;
        }

        private boolean processReplicaAdd() throws Exception {
            boolean result;
            ORecordInternal replicaToAdd = this.record;
            ORecordVersion replicaVersion = this.record.getRecordVersion();
            try {
                if (!replicaVersion.isTombstone()) {
                    replicaToAdd = this.mergeWithRecord(null);
                    ODatabaseRecordAbstract.this.callbackHooks(ORecordHook.TYPE.BEFORE_REPLICA_ADD, replicaToAdd);
                } else {
                    replicaToAdd = (ORecordInternal)this.record.copy();
                }
                byte[] stream = replicaToAdd.toStream();
                int dataSegmentId = ODatabaseRecordAbstract.this.dataSegmentStrategy.assignDataSegmentId(ODatabaseRecordAbstract.this, replicaToAdd);
                result = ((ODatabaseRaw)ODatabaseRecordAbstract.this.underlying).updateReplica(dataSegmentId, this.rid, stream, replicaVersion, replicaToAdd.getRecordType());
                if (!replicaVersion.isTombstone()) {
                    ODatabaseRecordAbstract.this.callbackHooks(ORecordHook.TYPE.AFTER_REPLICA_ADD, replicaToAdd);
                    replicaToAdd.unsetDirty();
                    ODatabaseRecordAbstract.this.getLevel1Cache().updateRecord(replicaToAdd);
                }
            }
            catch (Exception e) {
                if (!replicaVersion.isTombstone()) {
                    ODatabaseRecordAbstract.this.callbackHooks(ORecordHook.TYPE.AFTER_REPLICA_ADD, replicaToAdd);
                }
                throw e;
            }
            return result;
        }

        private ORecordInternal<?> mergeWithRecord(ORID rid) {
            Object replicaToAdd;
            if (this.record instanceof ODocument) {
                replicaToAdd = rid == null ? new ODocument() : ODatabaseRecordAbstract.this.load(rid, "*:0", false, true);
                ((ODocument)replicaToAdd).merge((ODocument)this.record, false, false);
                replicaToAdd.getRecordVersion().copyFrom(this.record.getRecordVersion());
                replicaToAdd.setIdentity(this.rid);
            } else {
                replicaToAdd = (ORecordInternal)this.record.copy();
            }
            return replicaToAdd;
        }
    }
}

