/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.collection.OCompositeKey;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeTimeLine;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.OTrackedMultiValue;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.OFastConcurrentModificationException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.hook.ODocumentHookAbstract;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.index.OCompositeIndexDefinition;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinitionMultiValue;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.version.ORecordVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class OClassIndexManager
extends ODocumentHookAbstract {
    @Override
    public ORecordHook.RESULT onRecordBeforeCreate(ODocument iDocument) {
        this.checkIndexesAndAquireLock(iDocument, ORecordHook.TYPE.BEFORE_CREATE);
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeReplicaAdd(ODocument iDocument) {
        this.checkIndexesAndAquireLock(iDocument, ORecordHook.TYPE.BEFORE_CREATE);
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    @Override
    public void onRecordAfterCreate(ODocument iDocument) {
        this.addIndexesEntriesAndReleaseLock(iDocument);
    }

    @Override
    public void onRecordAfterReplicaAdd(ODocument iDocument) {
        this.addIndexesEntriesAndReleaseLock(iDocument);
    }

    private void addIndexesEntriesAndReleaseLock(ODocument document) {
        ORecord<Object> rid = (document = OClassIndexManager.checkForLoading(document)).getIdentity().isPersistent() ? document.placeholder() : document;
        OClass cls = document.getSchemaClass();
        if (cls != null) {
            Set<OIndex<?>> indexes = cls.getIndexes();
            for (OIndex oIndex : indexes) {
                Object key = oIndex.getDefinition().getDocumentValueToIndex(document);
                if (key instanceof Collection) {
                    for (Object keyItem : (Collection)key) {
                        if (keyItem == null) continue;
                        oIndex.put(keyItem, rid);
                    }
                    continue;
                }
                if (key == null) continue;
                oIndex.put(key, rid);
            }
            OClassIndexManager.releaseModificationLock(document, indexes);
        }
    }

    @Override
    public void onRecordCreateFailed(ODocument iDocument) {
        OClassIndexManager.releaseModificationLock(iDocument);
    }

    @Override
    public void onRecordReplicaAddFailed(ODocument iDocument) {
        OClassIndexManager.releaseModificationLock(iDocument);
    }

    @Override
    public void onRecordCreateReplicated(ODocument iDocument) {
        OClassIndexManager.releaseModificationLock(iDocument);
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeUpdate(ODocument iDocument) {
        this.checkIndexesAndAquireLock(iDocument, ORecordHook.TYPE.BEFORE_UPDATE);
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeReplicaUpdate(ODocument iDocument) {
        this.checkIndexesAndAquireLock(iDocument, ORecordHook.TYPE.BEFORE_UPDATE);
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    @Override
    public void onRecordAfterUpdate(ODocument iDocument) {
        this.updateIndexEntries(iDocument);
    }

    @Override
    public void onRecordAfterReplicaUpdate(ODocument iDocument) {
        this.updateIndexEntries(iDocument);
    }

    private void updateIndexEntries(ODocument iDocument) {
        HashSet<String> dirtyFields;
        OClass cls = (iDocument = OClassIndexManager.checkForLoading(iDocument)).getSchemaClass();
        if (cls == null) {
            return;
        }
        Set<OIndex<?>> indexes = cls.getIndexes();
        if (!indexes.isEmpty() && !(dirtyFields = new HashSet<String>(Arrays.asList(iDocument.getDirtyFields()))).isEmpty()) {
            for (OIndex oIndex : indexes) {
                if (oIndex.getDefinition() instanceof OCompositeIndexDefinition) {
                    OClassIndexManager.processCompositeIndexUpdate(oIndex, dirtyFields, iDocument);
                    continue;
                }
                OClassIndexManager.processSingleIndexUpdate(oIndex, dirtyFields, iDocument);
            }
        }
        OClassIndexManager.releaseModificationLock(iDocument, indexes);
        if (iDocument.isTrackingChanges()) {
            iDocument.setTrackingChanges(false);
            iDocument.setTrackingChanges(true);
        }
    }

    @Override
    public void onRecordUpdateFailed(ODocument iDocument) {
        OClassIndexManager.releaseModificationLock(iDocument);
    }

    @Override
    public void onRecordUpdateReplicated(ODocument iDocument) {
        OClassIndexManager.releaseModificationLock(iDocument);
    }

    @Override
    public void onRecordReplicaUpdateFailed(ODocument iDocument) {
        OClassIndexManager.releaseModificationLock(iDocument);
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeDelete(ODocument iDocument) {
        ORecordVersion version = iDocument.getRecordVersion();
        if (iDocument.fields() == 0) {
            iDocument.reload();
            if (version.getCounter() > -1 && iDocument.getRecordVersion().compareTo(version) != 0) {
                if (OFastConcurrentModificationException.enabled()) {
                    throw OFastConcurrentModificationException.instance();
                }
                throw new OConcurrentModificationException(iDocument.getIdentity(), iDocument.getRecordVersion(), version, 2);
            }
        }
        OClassIndexManager.acquireModificationLock(iDocument, iDocument.getSchemaClass() != null ? iDocument.getSchemaClass().getIndexes() : null);
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeReplicaDelete(ODocument iDocument) {
        OClassIndexManager.checkForLoading(iDocument);
        OClassIndexManager.acquireModificationLock(iDocument, iDocument.getSchemaClass() != null ? iDocument.getSchemaClass().getIndexes() : null);
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    @Override
    public void onRecordAfterDelete(ODocument iDocument) {
        this.deleteIndexEntries(iDocument);
    }

    @Override
    public void onRecordAfterReplicaDelete(ODocument iDocument) {
        this.deleteIndexEntries(iDocument);
    }

    private void deleteIndexEntries(ODocument iDocument) {
        OClass cls = iDocument.getSchemaClass();
        if (cls == null) {
            return;
        }
        ArrayList indexes = new ArrayList(cls.getIndexes());
        if (!indexes.isEmpty()) {
            HashSet<String> dirtyFields = new HashSet<String>(Arrays.asList(iDocument.getDirtyFields()));
            if (!dirtyFields.isEmpty()) {
                Iterator iterator = indexes.iterator();
                while (iterator.hasNext()) {
                    OIndex index = (OIndex)iterator.next();
                    boolean result = index.getDefinition() instanceof OCompositeIndexDefinition ? OClassIndexManager.processCompositeIndexDelete(index, dirtyFields, iDocument) : OClassIndexManager.processSingleIndexDelete(index, dirtyFields, iDocument);
                    if (!result) continue;
                    iterator.remove();
                }
            }
            for (OIndex oIndex : indexes) {
                Object key = oIndex.getDefinition().getDocumentValueToIndex(iDocument);
                OClassIndexManager.deleteIndexKey(oIndex, iDocument, key);
            }
        }
        OClassIndexManager.releaseModificationLock(iDocument, indexes);
        if (iDocument.isTrackingChanges()) {
            iDocument.setTrackingChanges(false);
            iDocument.setTrackingChanges(true);
        }
    }

    @Override
    public void onRecordDeleteFailed(ODocument iDocument) {
        OClassIndexManager.releaseModificationLock(iDocument);
    }

    @Override
    public void onRecordDeleteReplicated(ODocument iDocument) {
        OClassIndexManager.releaseModificationLock(iDocument);
    }

    @Override
    public void onRecordReplicaDeleteFailed(ODocument iDocument) {
        OClassIndexManager.releaseModificationLock(iDocument);
    }

    private static void processCompositeIndexUpdate(OIndex<?> index, Set<String> dirtyFields, ODocument iRecord) {
        OCompositeIndexDefinition indexDefinition = (OCompositeIndexDefinition)index.getDefinition();
        List<String> indexFields = indexDefinition.getFields();
        String multiValueField = indexDefinition.getMultiValueField();
        for (String indexField : indexFields) {
            if (!dirtyFields.contains(indexField)) continue;
            ArrayList<Object> origValues = new ArrayList<Object>(indexFields.size());
            for (String field : indexFields) {
                if (field.equals(multiValueField)) continue;
                if (dirtyFields.contains(field)) {
                    origValues.add(iRecord.getOriginalValue(field));
                    continue;
                }
                origValues.add(iRecord.field(field));
            }
            if (multiValueField == null) {
                Object origValue = indexDefinition.createValue(origValues);
                Object newValue = indexDefinition.getDocumentValueToIndex(iRecord);
                if (origValue != null) {
                    index.remove(origValue, iRecord);
                }
                if (newValue != null) {
                    index.put(newValue, iRecord.placeholder());
                }
            } else {
                OMultiValueChangeTimeLine<String, Object> multiValueChangeTimeLine = iRecord.getCollectionTimeLine(multiValueField);
                if (multiValueChangeTimeLine == null) {
                    if (dirtyFields.contains(multiValueField)) {
                        origValues.add(indexDefinition.getMultiValueDefinitionIndex(), iRecord.getOriginalValue(multiValueField));
                    } else {
                        origValues.add(indexDefinition.getMultiValueDefinitionIndex(), iRecord.field(multiValueField));
                    }
                    Object origValue = indexDefinition.createValue(origValues);
                    Object newValue = indexDefinition.getDocumentValueToIndex(iRecord);
                    OClassIndexManager.processIndexUpdateFieldAssignment(index, iRecord, origValue, newValue);
                } else if (dirtyFields.size() == 1) {
                    HashMap<OCompositeKey, Integer> keysToAdd = new HashMap<OCompositeKey, Integer>();
                    HashMap<OCompositeKey, Integer> keysToRemove = new HashMap<OCompositeKey, Integer>();
                    for (OMultiValueChangeEvent<String, Object> changeEvent : multiValueChangeTimeLine.getMultiValueChangeEvents()) {
                        indexDefinition.processChangeEvent(changeEvent, keysToAdd, keysToRemove, origValues.toArray());
                    }
                    for (OMultiValueChangeEvent<String, Object> keyToRemove : keysToRemove.keySet()) {
                        index.remove(keyToRemove, iRecord);
                    }
                    for (OMultiValueChangeEvent<String, Object> keyToAdd : keysToAdd.keySet()) {
                        index.put(keyToAdd, iRecord.placeholder());
                    }
                } else {
                    OTrackedMultiValue fieldValue = (OTrackedMultiValue)iRecord.field(multiValueField);
                    Object restoredMultiValue = fieldValue.returnOriginalState(multiValueChangeTimeLine.getMultiValueChangeEvents());
                    origValues.add(indexDefinition.getMultiValueDefinitionIndex(), restoredMultiValue);
                    Object origValue = indexDefinition.createValue(origValues);
                    Object newValue = indexDefinition.getDocumentValueToIndex(iRecord);
                    OClassIndexManager.processIndexUpdateFieldAssignment(index, iRecord, origValue, newValue);
                }
            }
            return;
        }
    }

    private static void processSingleIndexUpdate(OIndex<?> index, Set<String> dirtyFields, ODocument iRecord) {
        OIndexDefinition indexDefinition = index.getDefinition();
        List<String> indexFields = indexDefinition.getFields();
        if (indexFields.isEmpty()) {
            return;
        }
        String indexField = indexFields.get(0);
        if (!dirtyFields.contains(indexField)) {
            return;
        }
        OMultiValueChangeTimeLine<String, Object> multiValueChangeTimeLine = iRecord.getCollectionTimeLine(indexField);
        if (multiValueChangeTimeLine != null) {
            OIndexDefinitionMultiValue indexDefinitionMultiValue = (OIndexDefinitionMultiValue)indexDefinition;
            HashMap<Object, Integer> keysToAdd = new HashMap<Object, Integer>();
            HashMap<Object, Integer> keysToRemove = new HashMap<Object, Integer>();
            for (OMultiValueChangeEvent<String, Object> changeEvent : multiValueChangeTimeLine.getMultiValueChangeEvents()) {
                indexDefinitionMultiValue.processChangeEvent(changeEvent, keysToAdd, keysToRemove);
            }
            for (OMultiValueChangeEvent<String, Object> keyToRemove : keysToRemove.keySet()) {
                index.remove(keyToRemove, iRecord);
            }
            for (OMultiValueChangeEvent<String, Object> keyToAdd : keysToAdd.keySet()) {
                index.put(keyToAdd, iRecord.placeholder());
            }
        } else {
            Object origValue = indexDefinition.createValue(iRecord.getOriginalValue(indexField));
            Object newValue = indexDefinition.getDocumentValueToIndex(iRecord);
            OClassIndexManager.processIndexUpdateFieldAssignment(index, iRecord, origValue, newValue);
        }
    }

    private static void processIndexUpdateFieldAssignment(OIndex<?> index, ODocument iRecord, Object origValue, Object newValue) {
        if (origValue instanceof Collection && newValue instanceof Collection) {
            HashSet valuesToRemove = new HashSet((Collection)origValue);
            HashSet valuesToAdd = new HashSet((Collection)newValue);
            valuesToRemove.removeAll((Collection)newValue);
            valuesToAdd.removeAll((Collection)origValue);
            for (Object valueToRemove : valuesToRemove) {
                if (valueToRemove == null) continue;
                index.remove(valueToRemove, iRecord);
            }
            for (Object valueToAdd : valuesToAdd) {
                if (valueToAdd == null) continue;
                index.put(valueToAdd, iRecord);
            }
        } else {
            OClassIndexManager.deleteIndexKey(index, iRecord, origValue);
            if (newValue instanceof Collection) {
                for (Object newValueItem : (Collection)newValue) {
                    index.put(newValueItem, iRecord.placeholder());
                }
            } else if (newValue != null) {
                index.put(newValue, iRecord.placeholder());
            }
        }
    }

    private static boolean processCompositeIndexDelete(OIndex<?> index, Set<String> dirtyFields, ODocument iRecord) {
        OCompositeIndexDefinition indexDefinition = (OCompositeIndexDefinition)index.getDefinition();
        String multiValueField = indexDefinition.getMultiValueField();
        List<String> indexFields = indexDefinition.getFields();
        for (String indexField : indexFields) {
            if (!dirtyFields.contains(indexField)) continue;
            ArrayList<Object> origValues = new ArrayList<Object>(indexFields.size());
            for (String field : indexFields) {
                if (field.equals(multiValueField)) continue;
                if (dirtyFields.contains(field)) {
                    origValues.add(iRecord.getOriginalValue(field));
                    continue;
                }
                origValues.add(iRecord.field(field));
            }
            if (multiValueField != null) {
                OMultiValueChangeTimeLine<String, Object> multiValueChangeTimeLine = iRecord.getCollectionTimeLine(multiValueField);
                if (multiValueChangeTimeLine != null) {
                    OTrackedMultiValue fieldValue = (OTrackedMultiValue)iRecord.field(multiValueField);
                    Object restoredMultiValue = fieldValue.returnOriginalState(multiValueChangeTimeLine.getMultiValueChangeEvents());
                    origValues.add(indexDefinition.getMultiValueDefinitionIndex(), restoredMultiValue);
                } else if (dirtyFields.contains(multiValueField)) {
                    origValues.add(indexDefinition.getMultiValueDefinitionIndex(), iRecord.getOriginalValue(multiValueField));
                } else {
                    origValues.add(indexDefinition.getMultiValueDefinitionIndex(), iRecord.field(multiValueField));
                }
            }
            Object origValue = indexDefinition.createValue(origValues);
            OClassIndexManager.deleteIndexKey(index, iRecord, origValue);
            return true;
        }
        return false;
    }

    private static void deleteIndexKey(OIndex<?> index, ODocument iRecord, Object origValue) {
        if (origValue instanceof Collection) {
            for (Object valueItem : (Collection)origValue) {
                if (valueItem == null) continue;
                index.remove(valueItem, iRecord);
            }
        } else if (origValue != null) {
            index.remove(origValue, iRecord);
        }
    }

    private static boolean processSingleIndexDelete(OIndex<?> index, Set<String> dirtyFields, ODocument iRecord) {
        OIndexDefinition indexDefinition = index.getDefinition();
        List<String> indexFields = indexDefinition.getFields();
        if (indexFields.isEmpty()) {
            return false;
        }
        String indexField = indexFields.iterator().next();
        if (dirtyFields.contains(indexField)) {
            Object origValue;
            OMultiValueChangeTimeLine<String, Object> multiValueChangeTimeLine = iRecord.getCollectionTimeLine(indexField);
            if (multiValueChangeTimeLine != null) {
                OTrackedMultiValue fieldValue = (OTrackedMultiValue)iRecord.field(indexField);
                Object restoredMultiValue = fieldValue.returnOriginalState(multiValueChangeTimeLine.getMultiValueChangeEvents());
                origValue = indexDefinition.createValue(restoredMultiValue);
            } else {
                origValue = indexDefinition.createValue(iRecord.getOriginalValue(indexField));
            }
            OClassIndexManager.deleteIndexKey(index, iRecord, origValue);
            return true;
        }
        return false;
    }

    private void checkIndexesAndAquireLock(ODocument document, ORecordHook.TYPE hookType) {
        OClass cls = (document = OClassIndexManager.checkForLoading(document)).getSchemaClass();
        if (cls != null) {
            Set<OIndex<?>> indexes = cls.getIndexes();
            switch (hookType) {
                case BEFORE_CREATE: {
                    OClassIndexManager.checkIndexedPropertiesOnCreation(document, indexes);
                    break;
                }
                case BEFORE_UPDATE: {
                    OClassIndexManager.checkIndexedPropertiesOnUpdate(document, indexes);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid hook type: " + (Object)((Object)hookType));
                }
            }
            OClassIndexManager.acquireModificationLock(document, indexes);
        }
    }

    private static void checkIndexedPropertiesOnCreation(ODocument iRecord, Collection<OIndex<?>> iIndexes) {
        for (OIndex<?> index : iIndexes) {
            Object key = index.getDefinition().getDocumentValueToIndex(iRecord);
            if (key instanceof Collection) {
                for (Object keyItem : (Collection)key) {
                    if (keyItem == null) continue;
                    index.checkEntry(iRecord, keyItem);
                }
                continue;
            }
            if (key == null) continue;
            index.checkEntry(iRecord, key);
        }
    }

    private static void acquireModificationLock(ODocument iRecord, Collection<OIndex<?>> iIndexes) {
        if (iIndexes == null) {
            return;
        }
        TreeSet indexesToLock = new TreeSet(new Comparator<OIndex<?>>(){

            @Override
            public int compare(OIndex<?> indexOne, OIndex<?> indexTwo) {
                return indexOne.getName().compareTo(indexTwo.getName());
            }
        });
        indexesToLock.addAll(iIndexes);
        for (OIndex oIndex : indexesToLock) {
            oIndex.getInternal().acquireModificationLock();
        }
    }

    private static void releaseModificationLock(ODocument iRecord) {
        OClass cls = iRecord.getSchemaClass();
        if (cls != null) {
            OClassIndexManager.releaseModificationLock(iRecord, cls.getIndexes());
        }
    }

    private static void releaseModificationLock(ODocument iRecord, Collection<OIndex<?>> iIndexes) {
        for (OIndex<?> index : iIndexes) {
            index.getInternal().releaseModificationLock();
        }
    }

    private static void checkIndexedPropertiesOnUpdate(ODocument iRecord, Collection<OIndex<?>> iIndexes) {
        HashSet<String> dirtyFields = new HashSet<String>(Arrays.asList(iRecord.getDirtyFields()));
        if (dirtyFields.isEmpty()) {
            return;
        }
        block0: for (OIndex<?> index : iIndexes) {
            OIndexDefinition indexDefinition = index.getDefinition();
            List<String> indexFields = indexDefinition.getFields();
            for (String indexField : indexFields) {
                if (!dirtyFields.contains(indexField)) continue;
                Object key = index.getDefinition().getDocumentValueToIndex(iRecord);
                if (key instanceof Collection) {
                    for (Object keyItem : (Collection)key) {
                        if (keyItem == null) continue;
                        index.checkEntry(iRecord, keyItem);
                    }
                    continue block0;
                }
                if (key == null) continue block0;
                index.checkEntry(iRecord, key);
                continue block0;
            }
        }
    }

    private static ODocument checkForLoading(ODocument iRecord) {
        if (iRecord.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
            try {
                return (ODocument)iRecord.load();
            }
            catch (ORecordNotFoundException e) {
                throw new OIndexException("Error during loading of record with id : " + iRecord.getIdentity());
            }
        }
        return iRecord;
    }
}

