/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexOneValue;

public class OIndexDictionary
extends OIndexOneValue {
    public OIndexDictionary(String typeId, OIndexEngine<OIdentifiable> engine) {
        super(typeId, engine);
    }

    public OIndexOneValue put(Object key, OIdentifiable iSingleValue) {
        this.modificationLock.requestModificationLock();
        try {
            OIndexDictionary oIndexDictionary;
            this.acquireExclusiveLock();
            try {
                this.checkForKeyType(key);
                OIdentifiable value = (OIdentifiable)this.indexEngine.get(key);
                if (value == null || !value.equals(iSingleValue)) {
                    this.indexEngine.put(key, iSingleValue);
                }
                oIndexDictionary = this;
            }
            catch (Throwable throwable) {
                this.releaseExclusiveLock();
                throw throwable;
            }
            this.releaseExclusiveLock();
            return oIndexDictionary;
        }
        finally {
            this.modificationLock.releaseModificationLock();
        }
    }

    @Override
    public void checkEntry(OIdentifiable iRecord, Object key) {
    }

    @Override
    public boolean canBeUsedInEqualityOperators() {
        return true;
    }

    @Override
    public boolean supportsOrderedIterations() {
        return false;
    }
}

