/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.index.OIndexManagerAbstract;
import com.orientechnologies.orient.core.index.OIndexMultiValues;
import com.orientechnologies.orient.core.index.OIndexRemoteMultiValue;
import com.orientechnologies.orient.core.index.OIndexRemoteOneValue;
import com.orientechnologies.orient.core.index.OIndexes;
import com.orientechnologies.orient.core.index.OSimpleKeyIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.util.Collection;
import java.util.Set;

public class OIndexManagerRemote
extends OIndexManagerAbstract {
    private static final String QUERY_DROP = "drop index %s";

    public OIndexManagerRemote(ODatabaseRecord iDatabase) {
        super(iDatabase);
    }

    protected OIndex<?> getRemoteIndexInstance(boolean isMultiValueIndex, String type, String name, Set<String> clustersToIndex, OIndexDefinition indexDefinition, ORID identity, ODocument configuration) {
        if (isMultiValueIndex) {
            return new OIndexRemoteMultiValue(name, type, identity, indexDefinition, configuration, clustersToIndex);
        }
        return new OIndexRemoteOneValue(name, type, identity, indexDefinition, configuration, clustersToIndex);
    }

    @Override
    public OIndex<?> createIndex(String iName, String iType, OIndexDefinition iIndexDefinition, int[] iClusterIdsToIndex, OProgressListener iProgressListener) {
        String createIndexDDL = iIndexDefinition != null ? iIndexDefinition.toCreateIndexDDL(iName, iType) : new OSimpleKeyIndexDefinition().toCreateIndexDDL(iName, iType);
        this.acquireExclusiveLock();
        try {
            if (iProgressListener != null) {
                iProgressListener.onBegin((Object)this, 0L);
            }
            this.getDatabase().command(new OCommandSQL(createIndexDDL)).execute(new Object[0]);
            this.document.setIdentity(new ORecordId(this.document.getDatabase().getStorage().getConfiguration().indexMgrRecordId));
            if (iProgressListener != null) {
                iProgressListener.onCompletition((Object)this, true);
            }
            this.reload();
            OIndex<?> oIndex = this.preProcessBeforeReturn((OIndex)this.indexes.get(iName.toLowerCase()));
            return oIndex;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public OIndexManager dropIndex(String iIndexName) {
        this.acquireExclusiveLock();
        try {
            String text = String.format(QUERY_DROP, iIndexName);
            this.getDatabase().command(new OCommandSQL(text)).execute(new Object[0]);
            this.indexes.remove(iIndexName.toLowerCase());
            this.reload();
            OIndexManagerRemote oIndexManagerRemote = this;
            return oIndexManagerRemote;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    protected void fromStream() {
        this.acquireExclusiveLock();
        try {
            this.clearMetadata();
            Collection idxs = (Collection)this.document.field("indexes");
            if (idxs != null) {
                for (ODocument d : idxs) {
                    try {
                        OIndexInternal<?> newIndex = OIndexes.createIndex(this.getDatabase(), (String)d.field("type"));
                        OIndexInternal.IndexMetadata newIndexMetadata = newIndex.loadMetadata(d);
                        this.addIndexInternal(this.getRemoteIndexInstance(newIndex instanceof OIndexMultiValues, newIndexMetadata.getType(), newIndexMetadata.getName(), newIndexMetadata.getClustersToIndex(), newIndexMetadata.getIndexDefinition(), (ORID)d.field("mapRid", OType.LINK), d));
                    }
                    catch (Exception e) {
                        OLogManager.instance().error((Object)this, "Error on loading of index by configuration: %s", (Throwable)e, new Object[]{d});
                    }
                }
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public ODocument toStream() {
        throw new UnsupportedOperationException("Remote index cannot be streamed");
    }

    @Override
    public void recreateIndexes() {
        throw new UnsupportedOperationException("recreateIndexes()");
    }

    @Override
    public void waitTillIndexRestore() {
    }

    @Override
    public boolean autoRecreateIndexesAfterCrash() {
        return false;
    }
}

