/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.collection.OMultiCollectionIterator;
import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.concur.resource.OSharedResourceAdaptiveExternal;
import com.orientechnologies.common.concur.resource.OSharedResourceIterator;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.ODocumentFieldsHashSet;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerListRID;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRIDSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class OIndexMultiValues
extends OIndexAbstract<Set<OIdentifiable>> {
    public OIndexMultiValues(String type, OIndexEngine<Set<OIdentifiable>> indexEngine) {
        super(type, indexEngine);
    }

    @Override
    public Set<OIdentifiable> get(Object key) {
        this.checkForRebuild();
        this.acquireSharedLock();
        try {
            OMVRBTreeRIDSet values = (OMVRBTreeRIDSet)this.indexEngine.get(key);
            if (values == null) {
                Set<OIdentifiable> set = Collections.emptySet();
                return set;
            }
            HashSet<OIdentifiable> hashSet = new HashSet<OIdentifiable>(values);
            return hashSet;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public long count(Object key) {
        this.checkForRebuild();
        this.acquireSharedLock();
        try {
            OMVRBTreeRIDSet values = (OMVRBTreeRIDSet)this.indexEngine.get(key);
            if (values == null) {
                return 0L;
            }
            long l = values.size();
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public OIndexMultiValues put(Object key, OIdentifiable iSingleValue) {
        this.checkForRebuild();
        this.modificationLock.requestModificationLock();
        try {
            OIndexMultiValues oIndexMultiValues;
            this.acquireExclusiveLock();
            try {
                this.checkForKeyType(key);
                Set values = (Set)this.indexEngine.get(key);
                if (values == null) {
                    values = new OMVRBTreeRIDSet();
                    ((OMVRBTreeRIDSet)values).setAutoConvertToRecord(false);
                }
                if (!iSingleValue.getIdentity().isValid()) {
                    ((ORecord)iSingleValue).save();
                }
                values.add(iSingleValue.getIdentity());
                this.indexEngine.put(key, values);
                oIndexMultiValues = this;
            }
            catch (Throwable throwable) {
                this.releaseExclusiveLock();
                throw throwable;
            }
            this.releaseExclusiveLock();
            return oIndexMultiValues;
        }
        finally {
            this.modificationLock.releaseModificationLock();
        }
    }

    @Override
    public int remove(OIdentifiable iRecord) {
        this.checkForRebuild();
        this.acquireExclusiveLock();
        try {
            int n = this.indexEngine.removeValue(iRecord, MultiValuesTransformer.INSTANCE);
            return n;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public boolean remove(Object key, OIdentifiable value) {
        this.checkForRebuild();
        this.modificationLock.requestModificationLock();
        try {
            block11: {
                block12: {
                    Set recs;
                    block10: {
                        this.acquireExclusiveLock();
                        try {
                            recs = (Set)this.indexEngine.get(key);
                            if (recs != null) break block10;
                        }
                        catch (Throwable throwable) {
                            this.releaseExclusiveLock();
                            throw throwable;
                        }
                        this.releaseExclusiveLock();
                        return false;
                    }
                    if (!recs.remove(value)) break block11;
                    if (recs.isEmpty()) {
                        this.indexEngine.remove(key);
                        break block12;
                    }
                    this.indexEngine.put(key, recs);
                }
                this.releaseExclusiveLock();
                return true;
            }
            this.releaseExclusiveLock();
            return false;
        }
        finally {
            this.modificationLock.releaseModificationLock();
        }
    }

    public OIndexMultiValues create(String name, OIndexDefinition indexDefinition, String clusterIndexName, Set<String> clustersToIndex, boolean rebuild, OProgressListener progressListener) {
        return (OIndexMultiValues)super.create(name, indexDefinition, clusterIndexName, clustersToIndex, rebuild, progressListener, OStreamSerializerListRID.INSTANCE);
    }

    @Override
    public Collection<OIdentifiable> getValuesBetween(Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, int maxValuesToFetch) {
        this.checkForRebuild();
        this.acquireSharedLock();
        try {
            Collection<OIdentifiable> collection = this.indexEngine.getValuesBetween(rangeFrom, fromInclusive, rangeTo, toInclusive, maxValuesToFetch, MultiValuesTransformer.INSTANCE);
            return collection;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Collection<OIdentifiable> getValuesMajor(Object fromKey, boolean isInclusive, int maxValuesToFetch) {
        this.checkForRebuild();
        this.acquireSharedLock();
        try {
            Collection<OIdentifiable> collection = this.indexEngine.getValuesMajor(fromKey, isInclusive, maxValuesToFetch, MultiValuesTransformer.INSTANCE);
            return collection;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Collection<OIdentifiable> getValuesMinor(Object toKey, boolean isInclusive, int maxValuesToFetch) {
        this.checkForRebuild();
        this.acquireSharedLock();
        try {
            Collection<OIdentifiable> collection = this.indexEngine.getValuesMinor(toKey, isInclusive, maxValuesToFetch, MultiValuesTransformer.INSTANCE);
            return collection;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Collection<OIdentifiable> getValues(Collection<?> iKeys, int maxValuesToFetch) {
        this.checkForRebuild();
        ArrayList sortedKeys = new ArrayList(iKeys);
        Collections.sort(sortedKeys, ODefaultComparator.INSTANCE);
        this.acquireSharedLock();
        try {
            HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
            for (Object key : sortedKeys) {
                OMVRBTreeRIDSet values = (OMVRBTreeRIDSet)this.indexEngine.get(key);
                if (values == null || values.isEmpty()) continue;
                for (OIdentifiable value : values) {
                    if (maxValuesToFetch > -1 && maxValuesToFetch == result.size()) {
                        HashSet<OIdentifiable> hashSet = result;
                        return hashSet;
                    }
                    result.add(value);
                }
            }
            HashSet<OIdentifiable> hashSet = result;
            return hashSet;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Collection<ODocument> getEntriesMajor(Object fromKey, boolean isInclusive, int maxEntriesToFetch) {
        this.checkForRebuild();
        this.acquireSharedLock();
        try {
            Collection<ODocument> collection = this.indexEngine.getEntriesMajor(fromKey, isInclusive, maxEntriesToFetch, MultiValuesTransformer.INSTANCE);
            return collection;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Collection<ODocument> getEntriesMinor(Object toKey, boolean isInclusive, int maxEntriesToFetch) {
        this.checkForRebuild();
        this.acquireSharedLock();
        try {
            Collection<ODocument> collection = this.indexEngine.getEntriesMinor(toKey, isInclusive, maxEntriesToFetch, MultiValuesTransformer.INSTANCE);
            return collection;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Collection<ODocument> getEntriesBetween(Object rangeFrom, Object rangeTo, boolean inclusive, int maxEntriesToFetch) {
        this.checkForRebuild();
        OType[] types = this.getDefinition().getTypes();
        if (types.length == 1) {
            rangeFrom = OType.convert(rangeFrom, types[0].getDefaultJavaType());
            rangeTo = OType.convert(rangeTo, types[0].getDefaultJavaType());
        }
        this.acquireSharedLock();
        try {
            Collection<ODocument> collection = this.indexEngine.getEntriesBetween(rangeFrom, rangeTo, inclusive, maxEntriesToFetch, MultiValuesTransformer.INSTANCE);
            return collection;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public long count(Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, int maxValuesToFetch) {
        this.checkForRebuild();
        OType[] types = this.getDefinition().getTypes();
        if (types.length == 1) {
            rangeFrom = OType.convert(rangeFrom, types[0].getDefaultJavaType());
            rangeTo = OType.convert(rangeTo, types[0].getDefaultJavaType());
        }
        if (rangeFrom != null && rangeTo != null && rangeFrom.getClass() != rangeTo.getClass()) {
            throw new IllegalArgumentException("Range from-to parameters are of different types");
        }
        this.acquireSharedLock();
        try {
            long l = this.indexEngine.count(rangeFrom, fromInclusive, rangeTo, toInclusive, maxValuesToFetch, MultiValuesTransformer.INSTANCE);
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Collection<ODocument> getEntries(Collection<?> iKeys, int maxEntriesToFetch) {
        this.checkForRebuild();
        ArrayList sortedKeys = new ArrayList(iKeys);
        Collections.sort(sortedKeys, ODefaultComparator.INSTANCE);
        this.acquireSharedLock();
        try {
            ODocumentFieldsHashSet result = new ODocumentFieldsHashSet();
            for (Object key : sortedKeys) {
                OMVRBTreeRIDSet values = (OMVRBTreeRIDSet)this.indexEngine.get(key);
                if (values == null || values.isEmpty()) continue;
                for (OIdentifiable value : values) {
                    if (maxEntriesToFetch > -1 && maxEntriesToFetch == result.size()) {
                        ODocumentFieldsHashSet oDocumentFieldsHashSet = result;
                        return oDocumentFieldsHashSet;
                    }
                    ODocument document = new ODocument();
                    document.field("key", key);
                    document.field("rid", value.getIdentity());
                    document.unsetDirty();
                    result.add(document);
                }
            }
            ODocumentFieldsHashSet oDocumentFieldsHashSet = result;
            return oDocumentFieldsHashSet;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public long getSize() {
        this.checkForRebuild();
        this.acquireSharedLock();
        try {
            long l = this.indexEngine.size(MultiValuesTransformer.INSTANCE);
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public long getKeySize() {
        this.checkForRebuild();
        this.acquireSharedLock();
        try {
            long l = this.indexEngine.size(null);
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Iterator<OIdentifiable> valuesIterator() {
        this.checkForRebuild();
        this.acquireSharedLock();
        try {
            OSharedResourceIterator oSharedResourceIterator = new OSharedResourceIterator((OSharedResourceAdaptiveExternal)this, (Iterator)new OMultiCollectionIterator(this.indexEngine.valuesIterator()));
            return oSharedResourceIterator;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Iterator<OIdentifiable> valuesInverseIterator() {
        this.checkForRebuild();
        this.acquireSharedLock();
        try {
            OSharedResourceIterator oSharedResourceIterator = new OSharedResourceIterator((OSharedResourceAdaptiveExternal)this, (Iterator)new OMultiCollectionIterator(this.indexEngine.inverseValuesIterator()));
            return oSharedResourceIterator;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private static final class MultiValuesTransformer
    implements OIndexEngine.ValuesTransformer<Set<OIdentifiable>> {
        private static final MultiValuesTransformer INSTANCE = new MultiValuesTransformer();

        private MultiValuesTransformer() {
        }

        @Override
        public Collection<OIdentifiable> transformFromValue(Set<OIdentifiable> value) {
            return value;
        }

        @Override
        public Set<OIdentifiable> transformToValue(Collection<OIdentifiable> collection) {
            return (Set)collection;
        }
    }
}

