/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.index.OIndex;

public class OIndexRebuildOutputListener
implements OProgressListener {
    private final OIndex<?> idx;
    long startTime;
    long lastDump;
    long lastCounter = 0L;

    public OIndexRebuildOutputListener(OIndex<?> idx) {
        this.idx = idx;
    }

    public void onBegin(Object iTask, long iTotal) {
        this.lastDump = this.startTime = System.currentTimeMillis();
        OLogManager.instance().debug((Object)this, "- Building index %s...", new Object[]{this.idx.getName()});
    }

    public boolean onProgress(Object iTask, long iCounter, float iPercent) {
        long now = System.currentTimeMillis();
        if (now - this.lastDump > 10000L) {
            OLogManager.instance().debug((Object)this, "--> %3.2f%% progress, %,d indexed so far (%,d items/sec)", new Object[]{Float.valueOf(iPercent), iCounter, (iCounter - this.lastCounter) / 10L});
            this.lastDump = now;
            this.lastCounter = iCounter;
        }
        return true;
    }

    public void onCompletition(Object iTask, boolean iSucceed) {
        OLogManager.instance().debug((Object)this, "--> OK, indexed %,d items in %,d ms", new Object[]{this.idx.getSize(), System.currentTimeMillis() - this.startTime});
    }
}

