/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.ODocumentFieldsHashSet;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexTxAware;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class OIndexTxAwareOneValue
extends OIndexTxAware<OIdentifiable> {
    public OIndexTxAwareOneValue(ODatabaseRecord iDatabase, OIndex<OIdentifiable> iDelegate) {
        super(iDatabase, iDelegate);
    }

    @Override
    public void checkEntry(OIdentifiable iRecord, Object iKey) {
        OIdentifiable previousRecord = this.get(iKey);
        if (previousRecord != null && !previousRecord.equals(iRecord)) {
            OLogManager.instance().exception("Cannot index record %s: found duplicated key '%s' in index '%s' previously assigned to the record %s", null, OIndexException.class, new Object[]{iRecord, iKey, this.getName(), previousRecord});
        }
        super.checkEntry(iRecord, iKey);
    }

    @Override
    public OIdentifiable get(Object iKey) {
        OTransactionIndexChanges indexChanges = this.database.getTransaction().getIndexChanges(this.delegate.getName());
        OIdentifiable result = indexChanges == null || !indexChanges.cleared ? (OIdentifiable)super.get(iKey) : null;
        return this.filterIndexChanges(indexChanges, iKey, result, null);
    }

    @Override
    public boolean contains(Object iKey) {
        OTransactionIndexChanges indexChanges;
        OIdentifiable result = (indexChanges = this.database.getTransaction().getIndexChanges(this.delegate.getName())) == null || !indexChanges.cleared ? (OIdentifiable)super.get(iKey) : null;
        return this.filterIndexChanges(indexChanges, iKey, result, null) != null;
    }

    @Override
    public Collection<OIdentifiable> getValues(Collection<?> iKeys) {
        ArrayList<Object> keys = new ArrayList<Object>(iKeys);
        HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
        OTransactionIndexChanges indexChanges = this.database.getTransaction().getIndexChanges(this.delegate.getName());
        if (indexChanges == null) {
            result.addAll(super.getValues(keys));
            return result;
        }
        HashSet<Object> keysToRemove = new HashSet<Object>();
        for (Object e : keys) {
            OIdentifiable keyResult;
            if (indexChanges.cleared) {
                keysToRemove.add(e);
            }
            if ((keyResult = this.filterIndexChanges(indexChanges, e, null, keysToRemove)) == null) continue;
            result.add(keyResult);
        }
        keys.removeAll(keysToRemove);
        if (!keys.isEmpty()) {
            result.addAll(super.getValues(keys));
        }
        return result;
    }

    @Override
    public Collection<ODocument> getEntries(Collection<?> iKeys) {
        ArrayList<Object> keys = new ArrayList<Object>(iKeys);
        ODocumentFieldsHashSet result = new ODocumentFieldsHashSet();
        OTransactionIndexChanges indexChanges = this.database.getTransaction().getIndexChanges(this.delegate.getName());
        if (indexChanges == null) {
            result.addAll(super.getEntries(keys));
            return result;
        }
        HashSet<Object> keysToRemove = new HashSet<Object>();
        for (Object e : keys) {
            OIdentifiable keyResult;
            if (indexChanges.cleared) {
                keysToRemove.add(e);
            }
            if ((keyResult = this.filterIndexChanges(indexChanges, e, null, keysToRemove)) == null) continue;
            ODocument document = new ODocument();
            document.field("key", e);
            document.field("rid", keyResult.getIdentity());
            document.unsetDirty();
            result.add(document);
        }
        keys.removeAll(keysToRemove);
        if (!keys.isEmpty()) {
            result.addAll(super.getEntries(keys));
        }
        return result;
    }

    protected OIdentifiable filterIndexChanges(OTransactionIndexChanges indexChanges, Object key, OIdentifiable iValue, Set<Object> keysToRemove) {
        OTransactionIndexChangesPerKey value;
        if (indexChanges == null) {
            return iValue;
        }
        OIdentifiable keyResult = iValue;
        if (indexChanges.containsChangesPerKey(key) && (value = indexChanges.getChangesPerKey(key)) != null) {
            for (OTransactionIndexChangesPerKey.OTransactionIndexEntry entry : value.entries) {
                if (entry.operation == OTransactionIndexChanges.OPERATION.REMOVE) {
                    if (entry.value != null && !entry.value.equals(keyResult)) continue;
                    if (keysToRemove != null) {
                        keysToRemove.add(key);
                    }
                    keyResult = null;
                    continue;
                }
                if (entry.operation != OTransactionIndexChanges.OPERATION.PUT) continue;
                if (keysToRemove != null) {
                    keysToRemove.add(key);
                }
                keyResult = entry.value;
            }
        }
        if (indexChanges.containsChangesCrossKey() && (value = indexChanges.getChangesCrossKey()) != null) {
            for (OTransactionIndexChangesPerKey.OTransactionIndexEntry entry : value.entries) {
                if (entry.operation == OTransactionIndexChanges.OPERATION.REMOVE) {
                    if (entry.value != null && !entry.value.equals(keyResult)) continue;
                    if (keysToRemove != null) {
                        keysToRemove.add(key);
                    }
                    keyResult = null;
                    continue;
                }
                if (entry.operation != OTransactionIndexChanges.OPERATION.PUT) continue;
                if (keysToRemove != null) {
                    keysToRemove.add(key);
                }
                keyResult = entry.value;
            }
        }
        return keyResult;
    }
}

