/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.engine;

import com.orientechnologies.common.collection.OMVRBTree;
import com.orientechnologies.common.collection.OMVRBTreeEntry;
import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.concur.resource.OSharedResourceAdaptiveExternal;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.ODocumentFieldsHashSet;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.ORuntimeKeyIndexDefinition;
import com.orientechnologies.orient.core.memory.OMemoryWatchDog;
import com.orientechnologies.orient.core.profiler.OJVMProfiler;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.index.OCompositeKeySerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.index.OSimpleKeySerializer;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeDatabaseLazySave;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeProviderAbstract;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class OMVRBTreeIndexEngine<V>
extends OSharedResourceAdaptiveExternal
implements OIndexEngine<V> {
    private int maxUpdatesBeforeSave;
    private OMemoryWatchDog.Listener watchDog;
    private OMVRBTreeDatabaseLazySave<Object, V> map;

    public OMVRBTreeIndexEngine() {
        super(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean(), OGlobalConfiguration.MVRBTREE_TIMEOUT.getValueAsInteger(), true);
    }

    @Override
    public void init() {
        this.acquireExclusiveLock();
        try {
            this.watchDog = new OMemoryWatchDog.Listener(){

                @Override
                public void memoryUsageLow(long iFreeMemory, long iFreeMemoryPercentage) {
                    OMVRBTreeIndexEngine.this.map.setOptimization(iFreeMemoryPercentage < 10L ? 2 : 1);
                }
            };
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void flush() {
        this.acquireExclusiveLock();
        try {
            this.map.lazySave();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void create(String indexName, OIndexDefinition indexDefinition, String clusterIndexName, OStreamSerializer valueSerializer, boolean isAutomatic) {
        this.acquireExclusiveLock();
        try {
            this.maxUpdatesBeforeSave = this.lazyUpdates(isAutomatic);
            if (indexDefinition != null) {
                if (indexDefinition instanceof ORuntimeKeyIndexDefinition) {
                    this.map = new OMVRBTreeDatabaseLazySave(clusterIndexName, ((ORuntimeKeyIndexDefinition)indexDefinition).getSerializer(), valueSerializer, 1, this.maxUpdatesBeforeSave);
                } else {
                    OBinarySerializer<?> keySerializer = indexDefinition.getTypes().length > 1 ? OCompositeKeySerializer.INSTANCE : OBinarySerializerFactory.INSTANCE.getObjectSerializer(indexDefinition.getTypes()[0]);
                    this.map = new OMVRBTreeDatabaseLazySave(clusterIndexName, keySerializer, valueSerializer, indexDefinition.getTypes().length, this.maxUpdatesBeforeSave);
                }
            } else {
                this.map = new OMVRBTreeDatabaseLazySave(clusterIndexName, new OSimpleKeySerializer(), valueSerializer, 1, this.maxUpdatesBeforeSave);
            }
            this.installHooks(indexName);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    private void installHooks(String indexName) {
        OJVMProfiler profiler = Orient.instance().getProfiler();
        String profilerPrefix = profiler.getDatabaseMetric(this.getDatabase().getName(), "index." + indexName + '.');
        String profilerMetadataPrefix = "db.*.index.*.";
        profiler.registerHookValue(String.valueOf(profilerPrefix) + "items", "Index size", OProfiler.METRIC_TYPE.SIZE, new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                OMVRBTreeIndexEngine.this.acquireSharedLock();
                try {
                    String string = OMVRBTreeIndexEngine.this.map != null ? Integer.valueOf(OMVRBTreeIndexEngine.this.map.size()) : "-";
                    return string;
                }
                finally {
                    OMVRBTreeIndexEngine.this.releaseSharedLock();
                }
            }
        }, "db.*.index.*.items");
        profiler.registerHookValue(String.valueOf(profilerPrefix) + "entryPointSize", "Number of entrypoints in an index", OProfiler.METRIC_TYPE.SIZE, new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OMVRBTreeIndexEngine.this.map != null ? Integer.valueOf(OMVRBTreeIndexEngine.this.map.getEntryPointSize()) : "-";
            }
        }, "db.*.index.*.items");
        profiler.registerHookValue(String.valueOf(profilerPrefix) + "maxUpdateBeforeSave", "Maximum number of updates in a index before force saving", OProfiler.METRIC_TYPE.SIZE, new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OMVRBTreeIndexEngine.this.map != null ? Integer.valueOf(OMVRBTreeIndexEngine.this.map.getMaxUpdatesBeforeSave()) : "-";
            }
        }, "db.*.index.*.maxUpdateBeforeSave");
        Orient.instance().getMemoryWatchDog().addListener(this.watchDog);
    }

    @Override
    public void delete() {
        this.acquireExclusiveLock();
        try {
            if (this.map != null) {
                this.map.delete();
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void load(ORID indexRid, String indexName, boolean isAutomatic) {
        this.acquireExclusiveLock();
        try {
            this.maxUpdatesBeforeSave = this.lazyUpdates(isAutomatic);
            this.map = new OMVRBTreeDatabaseLazySave(this.getDatabase(), indexRid, this.maxUpdatesBeforeSave);
            this.map.load();
            this.installHooks(indexName);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public boolean contains(Object key) {
        this.acquireExclusiveLock();
        try {
            boolean bl = this.map.containsKey(key);
            return bl;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public ORID getIdentity() {
        this.acquireSharedLock();
        try {
            ORID oRID = ((OMVRBTreeProviderAbstract)this.map.getProvider()).getRecord().getIdentity();
            return oRID;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void clear() {
        this.acquireExclusiveLock();
        try {
            this.map.clear();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public boolean remove(Object key) {
        this.acquireExclusiveLock();
        try {
            boolean bl = this.map.remove(key) != null;
            return bl;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public int removeValue(OIdentifiable valueToRemove, OIndexEngine.ValuesTransformer<V> transformer) {
        this.acquireExclusiveLock();
        try {
            TreeMap<Object, Object> entriesToUpdate = new TreeMap<Object, Object>((Comparator<Object>)ODefaultComparator.INSTANCE);
            OMVRBTreeEntry firstEntry = this.map.getFirstEntry();
            if (firstEntry == null) {
                return 0;
            }
            OMVRBTreeEntry entry = firstEntry;
            while (entry != null) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (transformer != null) {
                    Collection<OIdentifiable> rids = transformer.transformFromValue(value);
                    if (rids.remove(valueToRemove)) {
                        entriesToUpdate.put(key, transformer.transformToValue(rids));
                    }
                } else if (value.equals(valueToRemove)) {
                    entriesToUpdate.put(key, value);
                }
                entry = OMVRBTree.next(entry);
            }
            for (Map.Entry entryToUpdate : entriesToUpdate.entrySet()) {
                Object value = entryToUpdate.getValue();
                if (value instanceof Collection) {
                    Collection col = (Collection)value;
                    if (col.isEmpty()) {
                        this.map.remove(entryToUpdate.getKey());
                        continue;
                    }
                    this.map.put(entryToUpdate.getKey(), value);
                    continue;
                }
                this.map.remove(entryToUpdate.getKey());
            }
            int n = entriesToUpdate.size();
            return n;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public Iterator<Map.Entry<Object, V>> iterator() {
        this.acquireExclusiveLock();
        try {
            Iterator<Map.Entry<Object, V>> iterator = this.map.entrySet().iterator();
            return iterator;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public Iterator<Map.Entry<Object, V>> inverseIterator() {
        this.acquireExclusiveLock();
        try {
            Iterator iterator = ((OMVRBTree.EntrySet)this.map.entrySet()).inverseIterator();
            return iterator;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public Iterable<Object> keys() {
        this.acquireExclusiveLock();
        try {
            Set set = this.map.keySet();
            return set;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void unload() {
        this.acquireExclusiveLock();
        try {
            this.map.unload();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void startTransaction() {
        this.acquireExclusiveLock();
        try {
            this.map.setRunningTransaction(true);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void stopTransaction() {
        this.acquireExclusiveLock();
        try {
            this.map.setRunningTransaction(false);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void afterTxRollback() {
        this.acquireExclusiveLock();
        try {
            this.map.unload();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void afterTxCommit() {
        this.acquireExclusiveLock();
        try {
            this.map.onAfterTxCommit();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void closeDb() {
        this.acquireExclusiveLock();
        try {
            this.map.commitChanges(true);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void beforeTxBegin() {
        this.acquireExclusiveLock();
        try {
            this.map.commitChanges(true);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public V get(Object key) {
        this.acquireExclusiveLock();
        try {
            Object v = this.map.get(key);
            return v;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void put(Object key, V value) {
        this.acquireExclusiveLock();
        try {
            this.map.put(key, value);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public Collection<OIdentifiable> getValuesBetween(Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, int maxValuesToFetch, OIndexEngine.ValuesTransformer<V> transformer) {
        this.acquireExclusiveLock();
        try {
            Object firstEntry = fromInclusive ? this.map.getCeilingEntry(rangeFrom, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY) : this.map.getHigherEntry(rangeFrom);
            if (firstEntry == null) {
                Set<OIdentifiable> set = Collections.emptySet();
                return set;
            }
            int firstEntryIndex = this.map.getPageIndex();
            OMVRBTreeEntry lastEntry = toInclusive ? this.map.getHigherEntry(rangeTo) : this.map.getCeilingEntry(rangeTo, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY);
            int lastEntryIndex = lastEntry != null ? this.map.getPageIndex() : -1;
            OMVRBTreeEntry entry = firstEntry;
            this.map.setPageIndex(firstEntryIndex);
            HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
            while (entry != null && (entry != lastEntry || this.map.getPageIndex() != lastEntryIndex)) {
                Object value = entry.getValue();
                this.addToResult(transformer, result, value, maxValuesToFetch);
                if (maxValuesToFetch > -1 && result.size() == maxValuesToFetch) {
                    HashSet<OIdentifiable> hashSet = result;
                    return hashSet;
                }
                entry = OMVRBTree.next(entry);
            }
            HashSet<OIdentifiable> hashSet = result;
            return hashSet;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public Collection<OIdentifiable> getValuesMajor(Object fromKey, boolean isInclusive, int maxValuesToFetch, OIndexEngine.ValuesTransformer<V> transformer) {
        this.acquireExclusiveLock();
        try {
            Object firstEntry = isInclusive ? this.map.getCeilingEntry(fromKey, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY) : this.map.getHigherEntry(fromKey);
            if (firstEntry == null) {
                Set<OIdentifiable> set = Collections.emptySet();
                return set;
            }
            OMVRBTreeEntry entry = firstEntry;
            HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
            while (entry != null) {
                Object value = entry.getValue();
                this.addToResult(transformer, result, value, maxValuesToFetch);
                if (maxValuesToFetch > -1 && result.size() == maxValuesToFetch) {
                    HashSet<OIdentifiable> hashSet = result;
                    return hashSet;
                }
                entry = OMVRBTree.next(entry);
            }
            HashSet<OIdentifiable> hashSet = result;
            return hashSet;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public Collection<OIdentifiable> getValuesMinor(Object toKey, boolean isInclusive, int maxValuesToFetch, OIndexEngine.ValuesTransformer<V> transformer) {
        this.acquireExclusiveLock();
        try {
            Object lastEntry = isInclusive ? this.map.getFloorEntry(toKey, OMVRBTree.PartialSearchMode.HIGHEST_BOUNDARY) : this.map.getLowerEntry(toKey);
            if (lastEntry == null) {
                Set<OIdentifiable> set = Collections.emptySet();
                return set;
            }
            OMVRBTreeEntry entry = lastEntry;
            HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
            while (entry != null) {
                Object value = entry.getValue();
                this.addToResult(transformer, result, value, maxValuesToFetch);
                if (maxValuesToFetch > -1 && result.size() == maxValuesToFetch) {
                    HashSet<OIdentifiable> hashSet = result;
                    return hashSet;
                }
                entry = OMVRBTree.previous(entry);
            }
            HashSet<OIdentifiable> hashSet = result;
            return hashSet;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public Collection<ODocument> getEntriesMajor(Object fromKey, boolean isInclusive, int maxEntriesToFetch, OIndexEngine.ValuesTransformer<V> transformer) {
        this.acquireExclusiveLock();
        try {
            Object firstEntry = isInclusive ? this.map.getCeilingEntry(fromKey, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY) : this.map.getHigherEntry(fromKey);
            if (firstEntry == null) {
                Set<ODocument> set = Collections.emptySet();
                return set;
            }
            OMVRBTreeEntry entry = firstEntry;
            ODocumentFieldsHashSet result = new ODocumentFieldsHashSet();
            while (entry != null) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                this.addToEntriesResult(transformer, result, key, value, maxEntriesToFetch);
                if (maxEntriesToFetch > -1 && result.size() == maxEntriesToFetch) {
                    ODocumentFieldsHashSet oDocumentFieldsHashSet = result;
                    return oDocumentFieldsHashSet;
                }
                entry = OMVRBTree.next(entry);
            }
            ODocumentFieldsHashSet oDocumentFieldsHashSet = result;
            return oDocumentFieldsHashSet;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public Collection<ODocument> getEntriesMinor(Object toKey, boolean isInclusive, int maxEntriesToFetch, OIndexEngine.ValuesTransformer<V> transformer) {
        this.acquireExclusiveLock();
        try {
            Object lastEntry = isInclusive ? this.map.getFloorEntry(toKey, OMVRBTree.PartialSearchMode.HIGHEST_BOUNDARY) : this.map.getLowerEntry(toKey);
            if (lastEntry == null) {
                Set<ODocument> set = Collections.emptySet();
                return set;
            }
            OMVRBTreeEntry entry = lastEntry;
            ODocumentFieldsHashSet result = new ODocumentFieldsHashSet();
            while (entry != null) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                this.addToEntriesResult(transformer, result, key, value, maxEntriesToFetch);
                if (maxEntriesToFetch > -1 && result.size() == maxEntriesToFetch) {
                    ODocumentFieldsHashSet oDocumentFieldsHashSet = result;
                    return oDocumentFieldsHashSet;
                }
                entry = OMVRBTree.previous(entry);
            }
            ODocumentFieldsHashSet oDocumentFieldsHashSet = result;
            return oDocumentFieldsHashSet;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public Collection<ODocument> getEntriesBetween(Object iRangeFrom, Object iRangeTo, boolean iInclusive, int maxEntriesToFetch, OIndexEngine.ValuesTransformer<V> transformer) {
        this.acquireExclusiveLock();
        try {
            Object firstEntry = iInclusive ? this.map.getCeilingEntry(iRangeFrom, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY) : this.map.getHigherEntry(iRangeFrom);
            if (firstEntry == null) {
                Set<ODocument> set = Collections.emptySet();
                return set;
            }
            int firstEntryIndex = this.map.getPageIndex();
            OMVRBTreeEntry lastEntry = iInclusive ? this.map.getHigherEntry(iRangeTo) : this.map.getCeilingEntry(iRangeTo, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY);
            int lastEntryIndex = lastEntry != null ? this.map.getPageIndex() : -1;
            OMVRBTreeEntry entry = firstEntry;
            this.map.setPageIndex(firstEntryIndex);
            ODocumentFieldsHashSet result = new ODocumentFieldsHashSet();
            while (entry != null && (entry != lastEntry || this.map.getPageIndex() != lastEntryIndex)) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                this.addToEntriesResult(transformer, result, key, value, maxEntriesToFetch);
                if (maxEntriesToFetch > -1 && maxEntriesToFetch == result.size()) {
                    ODocumentFieldsHashSet oDocumentFieldsHashSet = result;
                    return oDocumentFieldsHashSet;
                }
                entry = OMVRBTree.next(entry);
            }
            ODocumentFieldsHashSet oDocumentFieldsHashSet = result;
            return oDocumentFieldsHashSet;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public long size(OIndexEngine.ValuesTransformer<V> valuesTransformer) {
        this.acquireExclusiveLock();
        try {
            if (valuesTransformer == null) {
                long l = this.map.size();
                return l;
            }
            OMVRBTreeEntry rootEntry = this.map.getRoot();
            long size = 0L;
            OMVRBTreeEntry currentEntry = rootEntry;
            this.map.setPageIndex(0);
            while (currentEntry != null) {
                size += (long)valuesTransformer.transformFromValue(currentEntry.getValue()).size();
                currentEntry = OMVRBTree.next((OMVRBTreeEntry)currentEntry);
            }
            this.map.setPageIndex(0);
            currentEntry = OMVRBTree.previous((OMVRBTreeEntry)rootEntry);
            while (currentEntry != null) {
                size += (long)valuesTransformer.transformFromValue(currentEntry.getValue()).size();
                currentEntry = OMVRBTree.previous((OMVRBTreeEntry)currentEntry);
            }
            long l = size;
            return l;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public long count(Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, int maxValuesToFetch, OIndexEngine.ValuesTransformer<V> transformer) {
        this.acquireExclusiveLock();
        try {
            Object firstEntry = rangeFrom == null ? (OMVRBTreeEntry)this.map.firstEntry() : (fromInclusive ? this.map.getCeilingEntry(rangeFrom, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY) : this.map.getHigherEntry(rangeFrom));
            if (firstEntry == null) {
                return 0L;
            }
            long count = 0L;
            int firstEntryIndex = this.map.getPageIndex();
            OMVRBTreeEntry lastEntry = rangeFrom == null ? (OMVRBTreeEntry)this.map.lastEntry() : (toInclusive ? this.map.getHigherEntry(rangeTo) : this.map.getCeilingEntry(rangeTo, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY));
            int lastEntryIndex = lastEntry != null ? this.map.getPageIndex() : -1;
            OMVRBTreeEntry entry = firstEntry;
            this.map.setPageIndex(firstEntryIndex);
            while (entry != null && (entry != lastEntry || this.map.getPageIndex() != lastEntryIndex)) {
                Object value = entry.getValue();
                count = transformer != null ? (count += (long)transformer.transformFromValue(value).size()) : ++count;
                if (maxValuesToFetch > -1 && (long)maxValuesToFetch == count) {
                    long l = maxValuesToFetch;
                    return l;
                }
                entry = OMVRBTree.next(entry);
            }
            long l = count;
            return l;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public Iterator<V> valuesIterator() {
        this.acquireExclusiveLock();
        try {
            Iterator iterator = this.map.values().iterator();
            return iterator;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public Iterator<V> inverseValuesIterator() {
        this.acquireExclusiveLock();
        try {
            Iterator iterator = ((OMVRBTree.Values)this.map.values()).inverseIterator();
            return iterator;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public boolean hasRangeQuerySupport() {
        return true;
    }

    private void addToResult(OIndexEngine.ValuesTransformer<V> transformer, Set<OIdentifiable> result, V value, int maxValuesToFetch) {
        if (transformer != null) {
            Collection<OIdentifiable> transformResult = transformer.transformFromValue(value);
            for (OIdentifiable transformedValue : transformResult) {
                result.add(transformedValue);
                if (maxValuesToFetch <= -1 || result.size() != maxValuesToFetch) continue;
                return;
            }
        } else {
            result.add((OIdentifiable)value);
        }
    }

    private void addToEntriesResult(OIndexEngine.ValuesTransformer<V> transformer, Set<ODocument> result, Object key, V value, int maxValuesToFetch) {
        if (transformer != null) {
            Collection<OIdentifiable> transformResult = transformer.transformFromValue(value);
            for (OIdentifiable transformedValue : transformResult) {
                ODocument document = new ODocument();
                document.field("key", key);
                document.field("rid", transformedValue.getIdentity());
                document.unsetDirty();
                result.add(document);
                if (maxValuesToFetch <= -1 || result.size() != maxValuesToFetch) continue;
                return;
            }
        } else {
            ODocument document = new ODocument();
            document.field("key", key);
            document.field("rid", ((OIdentifiable)value).getIdentity());
            document.unsetDirty();
            result.add(document);
        }
    }

    private ODatabaseRecord getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    private int lazyUpdates(boolean isAutomatic) {
        return isAutomatic ? OGlobalConfiguration.INDEX_AUTO_LAZY_UPDATES.getValueAsInteger() : OGlobalConfiguration.INDEX_MANUAL_LAZY_UPDATES.getValueAsInteger();
    }
}

