/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.hashindex.local;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.directmemory.ODirectMemory;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class OHashIndexBucket<K, V>
implements Iterable<Entry<K, V>> {
    private static final int MAGIC_NUMBER_OFFSET = 0;
    private static final int CRC32_OFFSET = 8;
    private static final int WAL_SEGMENT_OFFSET = 12;
    private static final int WAL_POSITION_OFFSET = 16;
    private static final int FREE_POINTER_OFFSET = 24;
    private static final int DEPTH_OFFSET = 28;
    private static final int SIZE_OFFSET = 29;
    private static final int HISTORY_OFFSET = 33;
    private static final int NEXT_REMOVED_BUCKET_OFFSET = 545;
    private static final int POSITIONS_ARRAY_OFFSET = 553;
    public static final int MAX_BUCKET_SIZE_BYTES = OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024;
    private final long bufferPointer;
    private final ODirectMemory directMemory;
    private final Comparator<? super K> comparator = ODefaultComparator.INSTANCE;
    private final OBinarySerializer<K> keySerializer;
    private final OBinarySerializer<V> valueSerializer;

    public OHashIndexBucket(int depth, long bufferPointer, ODirectMemory directMemory, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer) {
        this.bufferPointer = bufferPointer;
        this.directMemory = directMemory;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        directMemory.setByte(bufferPointer + 28L, (byte)depth);
        OIntegerSerializer.INSTANCE.serializeInDirectMemory(Integer.valueOf(MAX_BUCKET_SIZE_BYTES), directMemory, bufferPointer + 24L);
    }

    public OHashIndexBucket(long bufferPointer, ODirectMemory directMemory, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer) {
        this.bufferPointer = bufferPointer;
        this.directMemory = directMemory;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    public Entry<K, V> find(K key) {
        int index = this.binarySearch(key);
        if (index < 0) {
            return null;
        }
        return this.getEntry(index);
    }

    private int binarySearch(K key) {
        int low = 0;
        int high = this.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            K midVal = this.getKey(mid);
            int cmp = this.comparator.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public Entry<K, V> getEntry(int index) {
        int entryPosition = OIntegerSerializer.INSTANCE.deserializeFromDirectMemory(this.directMemory, this.bufferPointer + 553L + (long)(index * 4));
        Object key = this.keySerializer.deserializeFromDirectMemory(this.directMemory, this.bufferPointer + (long)entryPosition);
        entryPosition += this.keySerializer.getObjectSizeInDirectMemory(this.directMemory, this.bufferPointer + (long)entryPosition);
        Object value = this.valueSerializer.deserializeFromDirectMemory(this.directMemory, this.bufferPointer + (long)entryPosition);
        return new Entry<Object, Object>(key, value);
    }

    public K getKey(int index) {
        int entryPosition = OIntegerSerializer.INSTANCE.deserializeFromDirectMemory(this.directMemory, this.bufferPointer + 553L + (long)(index * 4));
        return (K)this.keySerializer.deserializeFromDirectMemory(this.directMemory, this.bufferPointer + (long)entryPosition);
    }

    public int getIndex(K key) {
        return this.binarySearch(key);
    }

    public int size() {
        return OIntegerSerializer.INSTANCE.deserializeFromDirectMemory(this.directMemory, this.bufferPointer + 29L);
    }

    @Override
    public Iterator<Entry<K, V>> iterator() {
        return new EntryIterator(0);
    }

    public Iterator<Entry<K, V>> iterator(int index) {
        return new EntryIterator(index);
    }

    public int mergedSize(OHashIndexBucket buddyBucket) {
        return 553 + this.size() * 4 + (MAX_BUCKET_SIZE_BYTES - OIntegerSerializer.INSTANCE.deserializeFromDirectMemory(this.directMemory, this.bufferPointer + 24L)) + buddyBucket.size() * 4 + (MAX_BUCKET_SIZE_BYTES - OIntegerSerializer.INSTANCE.deserializeFromDirectMemory(this.directMemory, buddyBucket.bufferPointer + 24L));
    }

    public int getContentSize() {
        return 553 + this.size() * 4 + (MAX_BUCKET_SIZE_BYTES - OIntegerSerializer.INSTANCE.deserializeFromDirectMemory(this.directMemory, this.bufferPointer + 24L));
    }

    public Entry<K, V> deleteEntry(int index) {
        Entry<K, V> removedEntry = this.getEntry(index);
        int freePointer = OIntegerSerializer.INSTANCE.deserializeFromDirectMemory(this.directMemory, this.bufferPointer + 24L);
        int positionOffset = 553 + index * 4;
        int entryPosition = OIntegerSerializer.INSTANCE.deserializeFromDirectMemory(this.directMemory, this.bufferPointer + (long)positionOffset);
        int keySize = this.keySerializer.getObjectSizeInDirectMemory(this.directMemory, this.bufferPointer + (long)entryPosition);
        int ridSize = this.valueSerializer.getObjectSizeInDirectMemory(this.directMemory, this.bufferPointer + (long)entryPosition + (long)keySize);
        int entrySize = keySize + ridSize;
        this.directMemory.copyData(this.bufferPointer + (long)positionOffset + 4L, this.bufferPointer + (long)positionOffset, (long)(this.size() * 4 - (index + 1) * 4));
        if (entryPosition > freePointer) {
            this.directMemory.copyData(this.bufferPointer + (long)freePointer, this.bufferPointer + (long)freePointer + (long)entrySize, (long)(entryPosition - freePointer));
        }
        int currentPositionOffset = 553;
        int size = this.size();
        for (int i = 0; i < size - 1; ++i) {
            int currentEntryPosition = OIntegerSerializer.INSTANCE.deserializeFromDirectMemory(this.directMemory, this.bufferPointer + (long)currentPositionOffset);
            if (currentEntryPosition < entryPosition) {
                OIntegerSerializer.INSTANCE.serializeInDirectMemory(Integer.valueOf(currentEntryPosition + entrySize), this.directMemory, this.bufferPointer + (long)currentPositionOffset);
            }
            currentPositionOffset += 4;
        }
        OIntegerSerializer.INSTANCE.serializeInDirectMemory(Integer.valueOf(freePointer + entrySize), this.directMemory, this.bufferPointer + 24L);
        OIntegerSerializer.INSTANCE.serializeInDirectMemory(Integer.valueOf(size - 1), this.directMemory, this.bufferPointer + 29L);
        return removedEntry;
    }

    public boolean addEntry(K key, V value) {
        int size;
        int entreeSize = this.keySerializer.getObjectSize(key) + this.valueSerializer.getObjectSize(value);
        int freePointer = OIntegerSerializer.INSTANCE.deserializeFromDirectMemory(this.directMemory, this.bufferPointer + 24L);
        if (freePointer - entreeSize < 553 + ((size = this.size()) + 1) * 4) {
            return false;
        }
        int index = this.binarySearch(key);
        if (index >= 0) {
            throw new IllegalArgumentException("Given value is present in bucket.");
        }
        int insertionPoint = -index - 1;
        this.insertEntry(key, value, insertionPoint);
        return true;
    }

    private void insertEntry(K key, V value, int insertionPoint) {
        int entreeSize = this.keySerializer.getObjectSize(key) + this.valueSerializer.getObjectSize(value);
        int freePointer = OIntegerSerializer.INSTANCE.deserializeFromDirectMemory(this.directMemory, this.bufferPointer + 24L);
        int size = this.size();
        int positionsOffset = insertionPoint * 4 + 553;
        this.directMemory.copyData(this.bufferPointer + (long)positionsOffset, this.bufferPointer + (long)positionsOffset + 4L, (long)(this.size() * 4 - insertionPoint * 4));
        int entreePosition = freePointer - entreeSize;
        OIntegerSerializer.INSTANCE.serializeInDirectMemory(Integer.valueOf(entreePosition), this.directMemory, this.bufferPointer + (long)positionsOffset);
        this.serializeEntry(key, value, entreePosition);
        OIntegerSerializer.INSTANCE.serializeInDirectMemory(Integer.valueOf(entreePosition), this.directMemory, this.bufferPointer + 24L);
        OIntegerSerializer.INSTANCE.serializeInDirectMemory(Integer.valueOf(size + 1), this.directMemory, this.bufferPointer + 29L);
    }

    public void appendEntry(K key, V value) {
        int positionsOffset = this.size() * 4 + 553;
        int entreeSize = this.keySerializer.getObjectSize(key) + this.valueSerializer.getObjectSize(value);
        int freePointer = OIntegerSerializer.INSTANCE.deserializeFromDirectMemory(this.directMemory, this.bufferPointer + 24L);
        int entreePosition = freePointer - entreeSize;
        OIntegerSerializer.INSTANCE.serializeInDirectMemory(Integer.valueOf(entreePosition), this.directMemory, this.bufferPointer + (long)positionsOffset);
        this.serializeEntry(key, value, entreePosition);
        OIntegerSerializer.INSTANCE.serializeInDirectMemory(Integer.valueOf(freePointer - entreeSize), this.directMemory, this.bufferPointer + 24L);
        OIntegerSerializer.INSTANCE.serializeInDirectMemory(Integer.valueOf(this.size() + 1), this.directMemory, this.bufferPointer + 29L);
    }

    private void serializeEntry(K key, V value, int entryOffset) {
        this.keySerializer.serializeInDirectMemory(key, this.directMemory, this.bufferPointer + (long)entryOffset);
        this.valueSerializer.serializeInDirectMemory(value, this.directMemory, this.bufferPointer + (long)(entryOffset += this.keySerializer.getObjectSize(key)));
    }

    public int getDepth() {
        return this.directMemory.getByte(this.bufferPointer + 28L);
    }

    public void setDepth(int depth) {
        this.directMemory.setByte(this.bufferPointer + 28L, (byte)depth);
    }

    public long getNextRemovedBucketPair() {
        return OLongSerializer.INSTANCE.deserializeFromDirectMemory(this.directMemory, this.bufferPointer + 545L);
    }

    public void setNextRemovedBucketPair(long nextRemovedBucketPair) {
        OLongSerializer.INSTANCE.serializeInDirectMemory(Long.valueOf(nextRemovedBucketPair), this.directMemory, this.bufferPointer + 545L);
    }

    public void updateEntry(int index, V value) {
        int entryPosition = OIntegerSerializer.INSTANCE.deserializeFromDirectMemory(this.directMemory, this.bufferPointer + 553L + (long)(index * 4));
        entryPosition += this.keySerializer.getObjectSizeInDirectMemory(this.directMemory, this.bufferPointer + (long)entryPosition);
        if (this.valueSerializer.getObjectSize(value) == this.valueSerializer.getObjectSizeInDirectMemory(this.directMemory, this.bufferPointer + (long)entryPosition)) {
            this.valueSerializer.serializeInDirectMemory(value, this.directMemory, this.bufferPointer + (long)entryPosition);
        } else {
            K key = this.getKey(index);
            this.deleteEntry(index);
            this.insertEntry(key, value, index);
        }
    }

    public long getSplitHistory(int level) {
        return OLongSerializer.INSTANCE.deserializeFromDirectMemory(this.directMemory, this.bufferPointer + 33L + (long)(8 * level));
    }

    public void setSplitHistory(int level, long position) {
        OLongSerializer.INSTANCE.serializeInDirectMemory(Long.valueOf(position), this.directMemory, this.bufferPointer + 33L + (long)(8 * level));
    }

    private final class EntryIterator
    implements Iterator<Entry<K, V>> {
        private int currentIndex;

        private EntryIterator(int currentIndex) {
            this.currentIndex = currentIndex;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < OHashIndexBucket.this.size();
        }

        @Override
        public Entry<K, V> next() {
            if (this.currentIndex >= OHashIndexBucket.this.size()) {
                throw new NoSuchElementException("Iterator was reached last element");
            }
            Entry entry = OHashIndexBucket.this.getEntry(this.currentIndex);
            ++this.currentIndex;
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove operation is not supported");
        }
    }

    public static class Entry<K, V> {
        public final K key;
        public final V value;

        public Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

