/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.hashindex.local;

import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.common.serialization.types.OStringSerializer;
import com.orientechnologies.orient.core.config.OStorageFileConfiguration;
import com.orientechnologies.orient.core.index.hashindex.local.OHashIndexFileLevelMetadata;
import com.orientechnologies.orient.core.storage.impl.local.OSingleFileSegment;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocalAbstract;
import java.io.IOException;

public class OHashIndexBufferStore
extends OSingleFileSegment {
    public OHashIndexBufferStore(String iPath, String iType) throws IOException {
        super(iPath, iType);
    }

    public OHashIndexBufferStore(OStorageLocalAbstract iStorage, OStorageFileConfiguration iConfig) throws IOException {
        super(iStorage, iConfig);
    }

    public OHashIndexBufferStore(OStorageLocalAbstract iStorage, OStorageFileConfiguration iConfig, String iType) throws IOException {
        super(iStorage, iConfig, iType);
    }

    public void setRecordsCount(long recordsCount) throws IOException {
        this.file.writeHeaderLong(0, recordsCount);
    }

    public long getRecordsCount() throws IOException {
        return this.file.readHeaderLong(0);
    }

    public void setKeySerializerId(byte keySerializerId) throws IOException {
        this.file.writeHeaderLong(8, keySerializerId);
    }

    public byte getKeySerializerId() throws IOException {
        return (byte)this.file.readHeaderLong(8);
    }

    public void setValueSerializerId(byte valueSerializerId) throws IOException {
        this.file.writeHeaderLong(16, valueSerializerId);
    }

    public byte getValuerSerializerId() throws IOException {
        return (byte)this.file.readHeaderLong(16);
    }

    public void storeMetadata(OHashIndexFileLevelMetadata[] filesMetadata) throws IOException {
        int bufferSize = 0;
        int counter = 0;
        for (OHashIndexFileLevelMetadata metadata : filesMetadata) {
            if (metadata == null) break;
            ++counter;
            String fileName = metadata.getFileName();
            bufferSize += OStringSerializer.INSTANCE.getObjectSize(fileName);
            bufferSize += 16;
        }
        int totalSize = bufferSize + 8;
        if (this.file.getFilledUpTo() < (long)totalSize) {
            this.file.allocateSpace((long)totalSize - this.file.getFilledUpTo());
        }
        byte[] buffer = new byte[bufferSize];
        int offset = 0;
        for (OHashIndexFileLevelMetadata fileMetadata : filesMetadata) {
            if (fileMetadata == null) break;
            OStringSerializer.INSTANCE.serializeNative(fileMetadata.getFileName(), buffer, offset);
            OLongSerializer.INSTANCE.serializeNative(Long.valueOf(fileMetadata.getBucketsCount()), buffer, offset += OStringSerializer.INSTANCE.getObjectSize(fileMetadata.getFileName()));
            OLongSerializer.INSTANCE.serializeNative(Long.valueOf(fileMetadata.getTombstoneIndex()), buffer, offset += 8);
            offset += 8;
        }
        this.file.writeInt(0L, counter);
        this.file.writeInt(4L, buffer.length);
        this.file.write(8L, buffer);
    }

    public OHashIndexFileLevelMetadata[] loadMetadata() throws IOException {
        int len = this.file.readInt(0L);
        OHashIndexFileLevelMetadata[] metadatas = new OHashIndexFileLevelMetadata[64];
        int bufferSize = this.file.readInt(4L);
        byte[] buffer = new byte[bufferSize];
        this.file.read(8L, buffer, buffer.length);
        int offset = 0;
        for (int i = 0; i < len; ++i) {
            OHashIndexFileLevelMetadata metadata;
            String name = OStringSerializer.INSTANCE.deserializeNative(buffer, offset);
            long bucketsCount = OLongSerializer.INSTANCE.deserializeNative(buffer, offset += OStringSerializer.INSTANCE.getObjectSize(name));
            long tombstone = OLongSerializer.INSTANCE.deserializeNative(buffer, offset += 8);
            offset += 8;
            metadatas[i] = metadata = new OHashIndexFileLevelMetadata(name, bucketsCount, tombstone);
        }
        return metadatas;
    }
}

