/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.hashindex.local;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.concur.resource.OSharedResourceAdaptive;
import com.orientechnologies.common.directmemory.ODirectMemory;
import com.orientechnologies.common.directmemory.ODirectMemoryFactory;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageFileConfiguration;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.hashindex.local.OHashFunction;
import com.orientechnologies.orient.core.index.hashindex.local.OHashIndexBucket;
import com.orientechnologies.orient.core.index.hashindex.local.OHashIndexBufferStore;
import com.orientechnologies.orient.core.index.hashindex.local.OHashIndexFileLevelMetadata;
import com.orientechnologies.orient.core.index.hashindex.local.OHashIndexTreeStateStore;
import com.orientechnologies.orient.core.index.hashindex.local.OHashTreeNodeMetadata;
import com.orientechnologies.orient.core.index.hashindex.local.OIndexMaximumLimitReachedException;
import com.orientechnologies.orient.core.index.hashindex.local.cache.ODiskCache;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocalAbstract;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;

public class OLocalHashTable<K, V>
extends OSharedResourceAdaptive {
    private static final double MERGE_THRESHOLD = 0.2;
    private static final long HASH_CODE_MIN_VALUE = 0L;
    private static final long HASH_CODE_MAX_VALUE = -1L;
    private long[][] hashTree;
    private OHashTreeNodeMetadata[] nodesMetadata;
    private int hashTreeSize;
    private long size;
    private int hashTreeTombstone = -1;
    private long bucketTombstonePointer = -1L;
    private final String metadataConfigurationFileExtension;
    private final String treeStateFileExtension;
    private final String bucketFileExtension;
    public static final int HASH_CODE_SIZE = 64;
    public static final int MAX_LEVEL_DEPTH = 8;
    public static final int MAX_LEVEL_SIZE = 256;
    public static final int LEVEL_MASK = 255;
    private OStorageLocalAbstract storage;
    private String name;
    private OHashIndexBufferStore metadataStore;
    private OHashIndexTreeStateStore treeStateStore;
    private final ODirectMemory directMemory = ODirectMemoryFactory.INSTANCE.directMemory();
    private ODiskCache buffer;
    private final OHashFunction<K> keyHashFunction;
    private OBinarySerializer<K> keySerializer;
    private OBinarySerializer<V> valueSerializer;
    private OHashIndexFileLevelMetadata[] filesMetadata = new OHashIndexFileLevelMetadata[64];
    private final long[] fileLevelIds = new long[64];
    private final Comparator<? super K> comparator = ODefaultComparator.INSTANCE;

    public OLocalHashTable(String metadataConfigurationFileExtension, String treeStateFileExtension, String bucketFileExtension, OHashFunction<K> keyHashFunction) {
        super(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean());
        this.metadataConfigurationFileExtension = metadataConfigurationFileExtension;
        this.treeStateFileExtension = treeStateFileExtension;
        this.bucketFileExtension = bucketFileExtension;
        this.keyHashFunction = keyHashFunction;
    }

    private void initStores(String metadataConfigurationFileExtension, String treeStateFileExtension) throws IOException {
        OStorageFileConfiguration metadataConfiguration = new OStorageFileConfiguration(null, "${STORAGE_PATH}/" + this.name + metadataConfigurationFileExtension, "classic", "0", "50%");
        OStorageFileConfiguration treeStateConfiguration = new OStorageFileConfiguration(null, "${STORAGE_PATH}/" + this.name + treeStateFileExtension, "classic", "0", "50%");
        this.metadataStore = new OHashIndexBufferStore(this.storage, metadataConfiguration);
        this.treeStateStore = new OHashIndexTreeStateStore(this.storage, treeStateConfiguration);
    }

    public void create(String name, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer, OStorageLocalAbstract storageLocal) {
        this.acquireExclusiveLock();
        try {
            try {
                this.storage = storageLocal;
                this.buffer = this.storage.getDiskCache();
                if (this.buffer == null) {
                    throw new IllegalStateException("Disk cache was not initialized on storage level");
                }
                this.name = name;
                this.keySerializer = keySerializer;
                this.valueSerializer = valueSerializer;
                this.initStores(this.metadataConfigurationFileExtension, this.treeStateFileExtension);
                this.metadataStore.create(-1);
                this.treeStateStore.create(-1);
                this.metadataStore.setRecordsCount(this.size);
                this.treeStateStore.setHashTreeSize(this.hashTreeSize);
                this.treeStateStore.setHashTreeTombstone(this.hashTreeTombstone);
                this.treeStateStore.setBucketTombstonePointer(this.bucketTombstonePointer);
                this.filesMetadata[0] = this.createFileMetadata(0);
                this.initHashTreeState();
            }
            catch (IOException e) {
                throw new OIndexException("Error during local hash table creation.", e);
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public OBinarySerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public void setKeySerializer(OBinarySerializer<K> keySerializer) {
        this.keySerializer = keySerializer;
    }

    public OBinarySerializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    public void setValueSerializer(OBinarySerializer<V> valueSerializer) {
        this.valueSerializer = valueSerializer;
    }

    private OHashIndexFileLevelMetadata createFileMetadata(int i) throws IOException {
        String fileName = String.valueOf(this.name) + i + this.bucketFileExtension;
        this.fileLevelIds[i] = this.buffer.openFile(fileName);
        return new OHashIndexFileLevelMetadata(fileName, 0L, -1L);
    }

    public V get(K key) {
        this.acquireSharedLock();
        try {
            OHashIndexBucket.Entry<K, V> entry;
            int fileLevel;
            long pageIndex;
            block12: {
                long hashCode = this.keyHashFunction.hashCode(key);
                BucketPath bucketPath = this.getBucket(hashCode);
                long bucketPointer = this.hashTree[bucketPath.nodeIndex][bucketPath.itemIndex + bucketPath.hashMapOffset];
                if (bucketPointer == 0L) {
                    return null;
                }
                pageIndex = this.getPageIndex(bucketPointer);
                fileLevel = this.getFileLevel(bucketPointer);
                long dataPointer = this.loadPage(pageIndex, fileLevel);
                try {
                    OHashIndexBucket<K, V> bucket = new OHashIndexBucket<K, V>(dataPointer, this.directMemory, this.keySerializer, this.valueSerializer);
                    entry = bucket.find(key);
                    if (entry != null) break block12;
                    this.releasePage(pageIndex, fileLevel);
                }
                catch (Throwable throwable) {
                    try {
                        this.releasePage(pageIndex, fileLevel);
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new OIndexException("Exception during index value retrieval", e);
                    }
                }
                return null;
            }
            Object v = entry.value;
            this.releasePage(pageIndex, fileLevel);
            return v;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public void put(K key, V value) {
        this.doPut(key, value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public V remove(K key) {
        this.acquireExclusiveLock();
        try {
            Object removed;
            long hashCode = this.keyHashFunction.hashCode(key);
            BucketPath nodePath = this.getBucket(hashCode);
            long bucketPointer = this.hashTree[nodePath.nodeIndex][nodePath.itemIndex + nodePath.hashMapOffset];
            long pageIndex = this.getPageIndex(bucketPointer);
            int fileLevel = this.getFileLevel(bucketPointer);
            long dataPointer = this.loadPage(pageIndex, fileLevel);
            try {
                OHashIndexBucket<K, V> bucket = new OHashIndexBucket<K, V>(dataPointer, this.directMemory, this.keySerializer, this.valueSerializer);
                int positionIndex = bucket.getIndex(key);
                if (positionIndex < 0) {
                    return null;
                }
                removed = bucket.deleteEntry((int)positionIndex).value;
                --this.size;
                if (!this.mergeBucketsAfterDeletion(nodePath, bucket)) {
                    this.markPageAsDirty(pageIndex, fileLevel);
                }
            }
            finally {
                this.releasePage(pageIndex, fileLevel);
            }
            if (nodePath.parent != null) {
                int hashMapSize = 1 << nodePath.nodeLocalDepth;
                long[] node = this.hashTree[nodePath.nodeIndex];
                boolean allMapsContainSameBucket = this.checkAllMapsContainSameBucket(node, hashMapSize);
                if (allMapsContainSameBucket) {
                    this.mergeNodeToParent(node, nodePath);
                }
            }
            Object v = removed;
            return v;
        }
        catch (IOException e) {
            throw new OIndexException("Error during index removal", e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void clear() {
        this.acquireExclusiveLock();
        try {
            try {
                int i = 0;
                while (i < this.filesMetadata.length) {
                    if (this.filesMetadata[i] != null) {
                        this.buffer.truncateFile(this.fileLevelIds[i]);
                    }
                    ++i;
                }
                this.bucketTombstonePointer = -1L;
                this.metadataStore.truncate();
                this.treeStateStore.truncate();
                this.initHashTreeState();
            }
            catch (IOException e) {
                throw new OIndexException("Error during hash table clear", e);
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public OHashIndexBucket.Entry<K, V>[] higherEntries(K key) {
        return this.higherEntries(key, -1);
    }

    /*
     * Exception decompiling
     */
    public OHashIndexBucket.Entry<K, V>[] higherEntries(K key, int limit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void saveState() throws IOException {
        this.treeStateStore.setHashTreeSize(this.hashTreeSize);
        this.treeStateStore.setBucketTombstonePointer(this.bucketTombstonePointer);
        this.treeStateStore.setHashTreeTombstone(this.hashTreeTombstone);
        this.treeStateStore.storeTreeState(this.hashTree, this.nodesMetadata);
        this.metadataStore.setRecordsCount(this.size);
        this.metadataStore.setKeySerializerId(this.keySerializer.getId());
        this.metadataStore.setValueSerializerId(this.valueSerializer.getId());
        this.metadataStore.storeMetadata(this.filesMetadata);
    }

    public void load(String name, OStorageLocalAbstract storageLocal) {
        this.acquireExclusiveLock();
        try {
            try {
                this.storage = storageLocal;
                this.buffer = this.storage.getDiskCache();
                this.name = name;
                this.initStores(this.metadataConfigurationFileExtension, this.treeStateFileExtension);
                this.metadataStore.open();
                this.treeStateStore.open();
                this.size = this.metadataStore.getRecordsCount();
                this.hashTreeSize = (int)this.treeStateStore.getHashTreeSize();
                this.hashTreeTombstone = (int)this.treeStateStore.getHashTreeTombstone();
                this.bucketTombstonePointer = this.treeStateStore.getBucketTombstonePointer();
                int bitsCount = Integer.bitCount(this.hashTreeSize);
                int arraySize = bitsCount == 1 ? this.hashTreeSize : Integer.highestOneBit(this.hashTreeSize) << 1;
                OHashIndexTreeStateStore.TreeState treeState = this.treeStateStore.loadTreeState(arraySize);
                this.hashTree = treeState.getHashTree();
                this.nodesMetadata = treeState.getHashTreeNodeMetadata();
                this.size = this.metadataStore.getRecordsCount();
                this.keySerializer = OBinarySerializerFactory.INSTANCE.getObjectSerializer(this.metadataStore.getKeySerializerId());
                this.valueSerializer = OBinarySerializerFactory.INSTANCE.getObjectSerializer(this.metadataStore.getValuerSerializerId());
                this.filesMetadata = this.metadataStore.loadMetadata();
                int i = 0;
                while (i < this.filesMetadata.length) {
                    OHashIndexFileLevelMetadata fileLevelMetadata = this.filesMetadata[i];
                    if (fileLevelMetadata != null) {
                        this.fileLevelIds[i] = this.buffer.openFile(fileLevelMetadata.getFileName());
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                throw new OIndexException("Exception during hash table loading", e);
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    private OHashIndexBucket.Entry<K, V>[] convertBucketToEntries(OHashIndexBucket<K, V> bucket, int startIndex, int endIndex) {
        OHashIndexBucket.Entry[] entries = new OHashIndexBucket.Entry[endIndex - startIndex];
        Iterator<OHashIndexBucket.Entry<K, V>> iterator = bucket.iterator(startIndex);
        int i = 0;
        int k = startIndex;
        while (k < endIndex) {
            entries[i] = iterator.next();
            ++i;
            ++k;
        }
        return entries;
    }

    /*
     * Unable to fully structure code
     */
    private BucketPath nextBucketToFind(BucketPath bucketPath, int bucketDepth) {
        offset = BucketPath.access$5(bucketPath) - bucketDepth;
        currentNode = bucketPath;
        nodeLocalDepth = this.nodesMetadata[BucketPath.access$0(bucketPath)].getNodeLocalDepth();
        if (OLocalHashTable.$assertionsDisabled || this.nodesMetadata[BucketPath.access$0(bucketPath)].getNodeLocalDepth() == BucketPath.access$4(bucketPath)) ** GOTO lbl11
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            if ((offset -= nodeLocalDepth) <= 0) continue;
            currentNode = BucketPath.access$3(bucketPath);
            nodeLocalDepth = BucketPath.access$4(currentNode);
            if (!OLocalHashTable.$assertionsDisabled && this.nodesMetadata[BucketPath.access$0(currentNode)].getNodeLocalDepth() != BucketPath.access$4(currentNode)) {
                throw new AssertionError();
            }
lbl11:
            // 4 sources

            ** while (offset > 0)
        }
lbl12:
        // 1 sources

        diff = bucketDepth - (BucketPath.access$5(currentNode) - nodeLocalDepth);
        interval = 1 << nodeLocalDepth - diff;
        firstStartIndex = BucketPath.access$1(currentNode) & (255 << nodeLocalDepth - diff & 255);
        globalIndex = firstStartIndex + interval + BucketPath.access$2(currentNode);
        if (globalIndex >= 256) {
            bucketPathToFind = this.nextLevelUp(currentNode);
        } else {
            hashMapSize = 1 << BucketPath.access$4(currentNode);
            hashMapOffset = globalIndex / hashMapSize * hashMapSize;
            startIndex = globalIndex - hashMapOffset;
            bucketPathToFind = new BucketPath(BucketPath.access$3(currentNode), hashMapOffset, startIndex, BucketPath.access$0(currentNode), BucketPath.access$4(currentNode), BucketPath.access$5(currentNode));
        }
        return this.nextNonEmptyNode(bucketPathToFind);
    }

    private BucketPath nextNonEmptyNode(BucketPath bucketPath) {
        block0: while (bucketPath != null) {
            long[] node = this.hashTree[bucketPath.nodeIndex];
            int startIndex = bucketPath.itemIndex + bucketPath.hashMapOffset;
            int endIndex = 256;
            int i = startIndex;
            while (i < 256) {
                long position = node[i];
                if (position > 0L) {
                    int hashMapSize = 1 << bucketPath.nodeLocalDepth;
                    int hashMapOffset = i / hashMapSize * hashMapSize;
                    int itemIndex = i - hashMapOffset;
                    return new BucketPath(bucketPath.parent, hashMapOffset, itemIndex, bucketPath.nodeIndex, bucketPath.nodeLocalDepth, bucketPath.nodeGlobalDepth);
                }
                if (position < 0L) {
                    int childNodeIndex = (int)((position & Long.MAX_VALUE) >> 8);
                    int childItemOffset = (int)position & 0xFF;
                    BucketPath parent = new BucketPath(bucketPath.parent, 0, i, bucketPath.nodeIndex, bucketPath.nodeLocalDepth, bucketPath.nodeGlobalDepth);
                    int childLocalDepth = this.nodesMetadata[childNodeIndex].getNodeLocalDepth();
                    bucketPath = new BucketPath(parent, childItemOffset, 0, childNodeIndex, childLocalDepth, bucketPath.nodeGlobalDepth + childLocalDepth);
                    continue block0;
                }
                ++i;
            }
            bucketPath = this.nextLevelUp(bucketPath);
        }
        return null;
    }

    private BucketPath nextLevelUp(BucketPath bucketPath) {
        if (bucketPath.parent == null) {
            return null;
        }
        int nodeLocalDepth = bucketPath.nodeLocalDepth;
        assert (this.nodesMetadata[bucketPath.nodeIndex].getNodeLocalDepth() == bucketPath.nodeLocalDepth);
        int pointersSize = 1 << 8 - nodeLocalDepth;
        BucketPath parent = bucketPath.parent;
        if (parent.itemIndex < 128) {
            int nextParentIndex = (parent.itemIndex / pointersSize + 1) * pointersSize;
            return new BucketPath(parent.parent, 0, nextParentIndex, parent.nodeIndex, parent.nodeLocalDepth, parent.nodeGlobalDepth);
        }
        int nextParentIndex = ((parent.itemIndex - 128) / pointersSize + 1) * pointersSize + 128;
        if (nextParentIndex < 256) {
            return new BucketPath(parent.parent, 0, nextParentIndex, parent.nodeIndex, parent.nodeLocalDepth, parent.nodeGlobalDepth);
        }
        return this.nextLevelUp(new BucketPath(parent.parent, 0, 255, parent.nodeIndex, parent.nodeLocalDepth, parent.nodeGlobalDepth));
    }

    /*
     * Exception decompiling
     */
    public OHashIndexBucket.Entry<K, V>[] ceilingEntries(K key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public OHashIndexBucket.Entry<K, V> firstEntry() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public OHashIndexBucket.Entry<K, V> lastEntry() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public OHashIndexBucket.Entry<K, V>[] lowerEntries(K key) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public OHashIndexBucket.Entry<K, V>[] floorEntries(K key) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private BucketPath prevBucketToFind(BucketPath bucketPath, int bucketDepth) {
        BucketPath bucketPathToFind;
        int offset = bucketPath.nodeGlobalDepth - bucketDepth;
        BucketPath currentBucket = bucketPath;
        int nodeLocalDepth = bucketPath.nodeLocalDepth;
        while (offset > 0) {
            if ((offset -= nodeLocalDepth) <= 0) continue;
            currentBucket = bucketPath.parent;
            nodeLocalDepth = currentBucket.nodeLocalDepth;
        }
        int diff = bucketDepth - (currentBucket.nodeGlobalDepth - nodeLocalDepth);
        int firstStartIndex = currentBucket.itemIndex & (255 << nodeLocalDepth - diff & 0xFF);
        int globalIndex = firstStartIndex + currentBucket.hashMapOffset - 1;
        if (globalIndex < 0) {
            bucketPathToFind = this.prevLevelUp(bucketPath);
        } else {
            int hashMapSize = 1 << currentBucket.nodeLocalDepth;
            int hashMapOffset = globalIndex / hashMapSize * hashMapSize;
            int startIndex = globalIndex - hashMapOffset;
            bucketPathToFind = new BucketPath(currentBucket.parent, hashMapOffset, startIndex, currentBucket.nodeIndex, currentBucket.nodeLocalDepth, currentBucket.nodeGlobalDepth);
        }
        return this.prevNonEmptyNode(bucketPathToFind);
    }

    private BucketPath prevNonEmptyNode(BucketPath nodePath) {
        block0: while (nodePath != null) {
            int endIndex;
            long[] node = this.hashTree[nodePath.nodeIndex];
            boolean startIndex = false;
            int i = endIndex = nodePath.itemIndex + nodePath.hashMapOffset;
            while (i >= 0) {
                long position = node[i];
                if (position > 0L) {
                    int hashMapSize = 1 << nodePath.nodeLocalDepth;
                    int hashMapOffset = i / hashMapSize * hashMapSize;
                    int itemIndex = i - hashMapOffset;
                    return new BucketPath(nodePath.parent, hashMapOffset, itemIndex, nodePath.nodeIndex, nodePath.nodeLocalDepth, nodePath.nodeGlobalDepth);
                }
                if (position < 0L) {
                    int childNodeIndex = (int)((position & Long.MAX_VALUE) >> 8);
                    int childItemOffset = (int)position & 0xFF;
                    int nodeLocalDepth = this.nodesMetadata[childNodeIndex].getNodeLocalDepth();
                    int endChildIndex = (1 << nodeLocalDepth) - 1;
                    BucketPath parent = new BucketPath(nodePath.parent, 0, i, nodePath.nodeIndex, nodePath.nodeLocalDepth, nodePath.nodeGlobalDepth);
                    nodePath = new BucketPath(parent, childItemOffset, endChildIndex, childNodeIndex, nodeLocalDepth, parent.nodeGlobalDepth + nodeLocalDepth);
                    continue block0;
                }
                --i;
            }
            nodePath = this.prevLevelUp(nodePath);
        }
        return null;
    }

    private BucketPath prevLevelUp(BucketPath bucketPath) {
        if (bucketPath.parent == null) {
            return null;
        }
        int nodeLocalDepth = bucketPath.nodeLocalDepth;
        int pointersSize = 1 << 8 - nodeLocalDepth;
        BucketPath parent = bucketPath.parent;
        if (parent.itemIndex > 128) {
            int prevParentIndex = (parent.itemIndex - 128) / pointersSize * pointersSize + 128 - 1;
            return new BucketPath(parent.parent, 0, prevParentIndex, parent.nodeIndex, parent.nodeLocalDepth, parent.nodeGlobalDepth);
        }
        int prevParentIndex = parent.itemIndex / pointersSize * pointersSize - 1;
        if (prevParentIndex >= 0) {
            return new BucketPath(parent.parent, 0, prevParentIndex, parent.nodeIndex, parent.nodeLocalDepth, parent.nodeGlobalDepth);
        }
        return this.prevLevelUp(new BucketPath(parent.parent, 0, 0, parent.nodeIndex, parent.nodeLocalDepth, -1));
    }

    public long size() {
        this.acquireSharedLock();
        try {
            long l = this.size;
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public void rename(String newName) {
        this.acquireExclusiveLock();
        try {
            try {
                this.metadataStore.rename(this.name, newName);
                this.treeStateStore.rename(this.name, newName);
                long[] lArray = this.fileLevelIds;
                int n = this.fileLevelIds.length;
                int n2 = 0;
                while (n2 < n) {
                    long fileId = lArray[n2];
                    if (fileId > 0L) {
                        this.buffer.renameFile(fileId, newName, this.name);
                    }
                    ++n2;
                }
            }
            catch (IOException ioe) {
                throw new OIndexException("Attempt of rename of hash table was failed", ioe);
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void close() {
        this.acquireExclusiveLock();
        try {
            try {
                this.flush();
                this.metadataStore.close();
                this.treeStateStore.close();
                int i = 0;
                while (i < this.filesMetadata.length) {
                    if (this.filesMetadata[i] != null) {
                        this.buffer.closeFile(this.fileLevelIds[i]);
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                throw new OIndexException("Error during hash table close", e);
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void delete() {
        this.acquireExclusiveLock();
        try {
            try {
                int i = 0;
                while (i < this.filesMetadata.length) {
                    if (this.filesMetadata[i] != null) {
                        this.buffer.deleteFile(this.fileLevelIds[i]);
                    }
                    ++i;
                }
                this.metadataStore.delete();
                this.treeStateStore.delete();
            }
            catch (IOException e) {
                throw new OIndexException("Exception during index deletion", e);
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    private void mergeNodeToParent(long[] node, BucketPath nodePath) {
        int maxChildDepth;
        int startIndex = this.findParentNodeStartIndex(nodePath);
        int localNodeDepth = nodePath.nodeLocalDepth;
        int hashMapSize = 1 << localNodeDepth;
        long[] parentNode = this.hashTree[nodePath.parent.nodeIndex];
        int i = 0;
        int k = startIndex;
        while (i < node.length) {
            parentNode[k] = node[i];
            i += hashMapSize;
            ++k;
        }
        this.deleteNode(nodePath.nodeIndex);
        OHashTreeNodeMetadata metadata = this.nodesMetadata[nodePath.parent.nodeIndex];
        if (nodePath.parent.itemIndex < 128) {
            maxChildDepth = metadata.getMaxLeftChildDepth();
            if (maxChildDepth == localNodeDepth) {
                metadata.setMaxLeftChildDepth(this.getMaxLevelDepth(parentNode, 0, parentNode.length / 2));
            }
        } else {
            maxChildDepth = metadata.getMaxRightChildDepth();
            if (maxChildDepth == localNodeDepth) {
                metadata.setMaxRightChildDepth(this.getMaxLevelDepth(parentNode, parentNode.length / 2, parentNode.length));
            }
        }
    }

    private boolean mergeBucketsAfterDeletion(BucketPath nodePath, OHashIndexBucket<K, V> bucket) throws IOException {
        long buddyIndex;
        int buddyLevel;
        int itemOffset;
        int nodeIndex;
        long buddyPointer;
        int firstEndIndex;
        int bucketDepth = bucket.getDepth();
        if ((double)bucket.getContentSize() > (double)OHashIndexBucket.MAX_BUCKET_SIZE_BYTES * 0.2) {
            return false;
        }
        if (bucketDepth - 8 < 1) {
            return false;
        }
        int offset = nodePath.nodeGlobalDepth - (bucketDepth - 1);
        BucketPath currentNode = nodePath;
        int nodeLocalDepth = nodePath.nodeLocalDepth;
        while (offset > 0) {
            if ((offset -= nodeLocalDepth) <= 0) continue;
            currentNode = nodePath.parent;
            nodeLocalDepth = currentNode.nodeLocalDepth;
        }
        int diff = bucketDepth - 1 - (currentNode.nodeGlobalDepth - nodeLocalDepth);
        int interval = 1 << nodeLocalDepth - diff - 1;
        int firstStartIndex = currentNode.itemIndex & (255 << nodeLocalDepth - diff & 0xFF);
        int secondStartIndex = firstEndIndex = firstStartIndex + interval;
        int secondEndIndex = secondStartIndex + interval;
        long[] node = this.hashTree[currentNode.nodeIndex];
        if ((currentNode.itemIndex >>> nodeLocalDepth - diff - 1 & 1) == 1) {
            buddyPointer = node[firstStartIndex + currentNode.hashMapOffset];
            while (buddyPointer < 0L) {
                nodeIndex = (int)((buddyPointer & Long.MAX_VALUE) >> 8);
                itemOffset = (int)buddyPointer & 0xFF;
                buddyPointer = this.hashTree[nodeIndex][itemOffset];
            }
            assert (buddyPointer > 0L);
            buddyLevel = this.getFileLevel(buddyPointer);
            buddyIndex = this.getPageIndex(buddyPointer);
        } else {
            buddyPointer = node[secondStartIndex + currentNode.hashMapOffset];
            while (buddyPointer < 0L) {
                nodeIndex = (int)((buddyPointer & Long.MAX_VALUE) >> 8);
                itemOffset = (int)buddyPointer & 0xFF;
                buddyPointer = this.hashTree[nodeIndex][itemOffset];
            }
            assert (buddyPointer > 0L);
            buddyLevel = this.getFileLevel(buddyPointer);
            buddyIndex = this.getPageIndex(buddyPointer);
        }
        long buddyPagePointer = this.loadPage(buddyIndex, buddyLevel);
        try {
            OHashIndexBucket<K, V> buddyBucket = new OHashIndexBucket<K, V>(buddyPagePointer, this.directMemory, this.keySerializer, this.valueSerializer);
            if (buddyBucket.getDepth() != bucketDepth) {
                return false;
            }
            if (bucket.mergedSize(buddyBucket) >= OHashIndexBucket.MAX_BUCKET_SIZE_BYTES) {
                return false;
            }
            this.filesMetadata[buddyLevel].setBucketsCount(this.filesMetadata[buddyLevel].getBucketsCount() - 2L);
            int newBuddyLevel = buddyLevel - 1;
            long newBuddyIndex = buddyBucket.getSplitHistory(newBuddyLevel);
            this.filesMetadata[buddyLevel].setBucketsCount(this.filesMetadata[buddyLevel].getBucketsCount() + 1L);
            long newBuddyPagePointer = this.loadPage(newBuddyIndex, newBuddyLevel);
            try {
                OHashIndexBucket newBuddyBucket = new OHashIndexBucket(bucketDepth - 1, newBuddyPagePointer, this.directMemory, this.keySerializer, this.valueSerializer);
                for (OHashIndexBucket.Entry<K, V> entry : buddyBucket) {
                    newBuddyBucket.appendEntry(entry.key, entry.value);
                }
                for (OHashIndexBucket.Entry<K, V> entry : bucket) {
                    newBuddyBucket.addEntry(entry.key, entry.value);
                }
            }
            finally {
                this.buffer.markDirty(this.fileLevelIds[newBuddyLevel], newBuddyIndex);
                this.releasePage(newBuddyIndex, newBuddyLevel);
            }
            long bucketPointer = this.hashTree[nodePath.nodeIndex][nodePath.itemIndex + nodePath.hashMapOffset];
            long bucketIndex = this.getPageIndex(bucketPointer);
            int bucketLevel = this.getFileLevel(bucketPointer);
            long newBuddyPointer = this.createBucketPointer(buddyIndex, buddyLevel);
            int i = firstStartIndex;
            while (i < secondEndIndex) {
                this.updateBucket(currentNode.nodeIndex, i, currentNode.hashMapOffset, newBuddyPointer);
                ++i;
            }
            OHashIndexFileLevelMetadata oldBuddyFileMetadata = this.filesMetadata[buddyLevel];
            if (oldBuddyFileMetadata.getBucketsCount() > 0L) {
                long newTombstoneIndex;
                if (bucketIndex < buddyIndex) {
                    bucket.setNextRemovedBucketPair(oldBuddyFileMetadata.getTombstoneIndex());
                    this.buffer.markDirty(this.fileLevelIds[bucketLevel], bucketIndex);
                    newTombstoneIndex = bucketIndex;
                } else {
                    buddyBucket.setNextRemovedBucketPair(oldBuddyFileMetadata.getTombstoneIndex());
                    this.buffer.markDirty(this.fileLevelIds[buddyLevel], buddyIndex);
                    newTombstoneIndex = buddyIndex;
                }
                oldBuddyFileMetadata.setTombstoneIndex(newTombstoneIndex);
            } else {
                oldBuddyFileMetadata.setTombstoneIndex(-1L);
            }
            return true;
        }
        finally {
            this.releasePage(buddyIndex, buddyLevel);
        }
    }

    public void flush() {
        this.acquireExclusiveLock();
        try {
            try {
                this.saveState();
                this.metadataStore.synch();
                this.treeStateStore.synch();
                int i = 0;
                while (i < this.filesMetadata.length) {
                    if (this.filesMetadata[i] != null) {
                        this.buffer.flushFile(this.fileLevelIds[i]);
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                throw new OIndexException("Error during hash table flush", e);
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public boolean wasSoftlyClosed() {
        this.acquireSharedLock();
        try {
            if (!this.metadataStore.wasSoftlyClosedAtPreviousTime()) {
                return false;
            }
            if (!this.treeStateStore.wasSoftlyClosedAtPreviousTime()) {
                return false;
            }
            int i = 0;
            while (i < this.filesMetadata.length) {
                if (this.filesMetadata[i] != null && !this.buffer.wasSoftlyClosed(this.fileLevelIds[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        catch (IOException ioe) {
            throw new OIndexException("Error during integrity check", ioe);
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public void setSoftlyClosed(boolean softlyClosed) {
        this.acquireSharedLock();
        try {
            try {
                this.metadataStore.setSoftlyClosed(softlyClosed);
                this.treeStateStore.setSoftlyClosed(softlyClosed);
                int i = 0;
                while (i < this.filesMetadata.length) {
                    if (this.filesMetadata[i] != null) {
                        this.buffer.setSoftlyClosed(this.fileLevelIds[i], softlyClosed);
                    }
                    ++i;
                }
            }
            catch (IOException ioe) {
                throw new OIndexException("Error during integrity check", ioe);
            }
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * Loose catch block
     */
    private void doPut(K key, V value) {
        this.acquireExclusiveLock();
        try {
            OHashIndexBucket<K, V> bucket;
            long pagePointer;
            int fileLevel;
            long pageIndex;
            long[] node;
            BucketPath bucketPath;
            block26: {
                block25: {
                    long hashCode = this.keyHashFunction.hashCode(key);
                    bucketPath = this.getBucket(hashCode);
                    node = this.hashTree[bucketPath.nodeIndex];
                    long bucketPointer = node[bucketPath.itemIndex + bucketPath.hashMapOffset];
                    if (bucketPointer == 0L) {
                        throw new IllegalStateException("In this version of hash table buckets are added through split only.");
                    }
                    pageIndex = this.getPageIndex(bucketPointer);
                    fileLevel = this.getFileLevel(bucketPointer);
                    pagePointer = this.loadPage(pageIndex, fileLevel);
                    bucket = new OHashIndexBucket<K, V>(pagePointer, this.directMemory, this.keySerializer, this.valueSerializer);
                    int index = bucket.getIndex(key);
                    if (index <= -1) break block25;
                    bucket.updateEntry(index, value);
                    this.releasePage(pageIndex, fileLevel);
                    return;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                if (!bucket.addEntry(key, value)) break block26;
                this.markPageAsDirty(pageIndex, fileLevel);
                ++this.size;
                this.releasePage(pageIndex, fileLevel);
                return;
            }
            try {
                try {
                    BucketSplitResult splitResult = this.splitBucket(bucket, fileLevel, pageIndex, pagePointer);
                    long updatedBucketPointer = splitResult.updatedBucketPointer;
                    long newBucketPointer = splitResult.newBucketPointer;
                    int bucketDepth = splitResult.newDepth;
                    if (bucketDepth <= bucketPath.nodeGlobalDepth) {
                        this.updateNodeAfterBucketSplit(bucketPath, bucketDepth, newBucketPointer, updatedBucketPointer);
                    } else if (bucketPath.nodeLocalDepth < 8) {
                        NodeSplitResult nodeSplitResult = this.splitNode(bucketPath, node);
                        assert (!nodeSplitResult.allLeftHashMapsEqual || !nodeSplitResult.allRightHashMapsEqual);
                        long[] newNode = nodeSplitResult.newNode;
                        int nodeLocalDepth = bucketPath.nodeLocalDepth + 1;
                        int hashMapSize = 1 << nodeLocalDepth;
                        assert (nodeSplitResult.allRightHashMapsEqual == this.checkAllMapsContainSameBucket(newNode, hashMapSize));
                        int newNodeIndex = -1;
                        if (!nodeSplitResult.allRightHashMapsEqual || bucketPath.itemIndex >= 128) {
                            newNodeIndex = this.addNewNode(newNode, nodeLocalDepth);
                        }
                        int updatedItemIndex = bucketPath.itemIndex << 1;
                        int updatedOffset = bucketPath.hashMapOffset << 1;
                        int updatedGlobalDepth = bucketPath.nodeGlobalDepth + 1;
                        boolean allLeftHashMapsEqual = nodeSplitResult.allLeftHashMapsEqual;
                        boolean allRightHashMapsEqual = nodeSplitResult.allRightHashMapsEqual;
                        if (updatedOffset < 256) {
                            allLeftHashMapsEqual = false;
                            BucketPath updatedBucketPath = new BucketPath(bucketPath.parent, updatedOffset, updatedItemIndex, bucketPath.nodeIndex, nodeLocalDepth, updatedGlobalDepth);
                            this.updateNodeAfterBucketSplit(updatedBucketPath, bucketDepth, newBucketPointer, updatedBucketPointer);
                        } else {
                            allRightHashMapsEqual = false;
                            BucketPath newBucketPath = new BucketPath(bucketPath.parent, updatedOffset - 256, updatedItemIndex, newNodeIndex, nodeLocalDepth, updatedGlobalDepth);
                            this.updateNodeAfterBucketSplit(newBucketPath, bucketDepth, newBucketPointer, updatedBucketPointer);
                        }
                        long[] updatedNode = this.hashTree[bucketPath.nodeIndex];
                        this.updateNodesAfterSplit(bucketPath, updatedNode, newNode, nodeLocalDepth, hashMapSize, allLeftHashMapsEqual, allRightHashMapsEqual, newNodeIndex);
                        if (allLeftHashMapsEqual) {
                            this.deleteNode(bucketPath.nodeIndex);
                        }
                    } else {
                        this.addNewLevelNode(bucketPath, node, newBucketPointer, updatedBucketPointer);
                    }
                }
                finally {
                    this.releasePage(pageIndex, fileLevel);
                }
                this.doPut(key, value);
            }
            catch (OIndexMaximumLimitReachedException e) {
                OLogManager.instance().warn((Object)this, "Key " + key + " is too large to fit in index and will be skipped", (Throwable)((Object)e), new Object[0]);
            }
            catch (IOException e) {
                throw new OIndexException("Error during index update", e);
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    private void updateNodesAfterSplit(BucketPath bucketPath, long[] node, long[] newNode, int nodeLocalDepth, int hashMapSize, boolean allLeftHashMapEquals, boolean allRightHashMapsEquals, int newNodeIndex) {
        long position;
        int i;
        int startIndex = this.findParentNodeStartIndex(bucketPath);
        long[] parentNode = this.hashTree[bucketPath.parent.nodeIndex];
        assert (this.assertParentNodeStartIndex(bucketPath, parentNode, startIndex));
        int pointersSize = 1 << 8 - nodeLocalDepth;
        if (allLeftHashMapEquals) {
            i = 0;
            while (i < pointersSize) {
                parentNode[startIndex + i] = position = node[i * hashMapSize];
                ++i;
            }
        } else {
            i = 0;
            while (i < pointersSize) {
                parentNode[startIndex + i] = (long)(bucketPath.nodeIndex << 8 | i * hashMapSize) | Long.MIN_VALUE;
                ++i;
            }
        }
        if (allRightHashMapsEquals) {
            i = 0;
            while (i < pointersSize) {
                parentNode[startIndex + pointersSize + i] = position = newNode[i * hashMapSize];
                ++i;
            }
        } else {
            i = 0;
            while (i < pointersSize) {
                parentNode[startIndex + pointersSize + i] = (long)(newNodeIndex << 8 | i * hashMapSize) | Long.MIN_VALUE;
                ++i;
            }
        }
        this.updateMaxChildDepth(bucketPath.parent, bucketPath.nodeLocalDepth + 1);
    }

    private void updateMaxChildDepth(BucketPath parentPath, int childDepth) {
        if (parentPath == null) {
            return;
        }
        OHashTreeNodeMetadata metadata = this.nodesMetadata[parentPath.nodeIndex];
        if (parentPath.itemIndex < 128) {
            int maxChildDepth = metadata.getMaxLeftChildDepth();
            if (childDepth > maxChildDepth) {
                metadata.setMaxLeftChildDepth(childDepth);
            }
        } else {
            int maxChildDepth = metadata.getMaxRightChildDepth();
            if (childDepth + 1 > maxChildDepth) {
                metadata.setMaxRightChildDepth(childDepth);
            }
        }
    }

    private boolean assertParentNodeStartIndex(BucketPath bucketPath, long[] parentNode, int calculatedIndex) {
        int startIndex = -1;
        int i = 0;
        while (i < parentNode.length) {
            if (parentNode[i] < 0L && (parentNode[i] & Long.MAX_VALUE) >>> 8 == (long)bucketPath.nodeIndex) {
                startIndex = i;
                break;
            }
            ++i;
        }
        return startIndex == calculatedIndex;
    }

    private int findParentNodeStartIndex(BucketPath bucketPath) {
        BucketPath parentBucketPath = bucketPath.parent;
        int pointersSize = 1 << 8 - bucketPath.nodeLocalDepth;
        if (parentBucketPath.itemIndex < 128) {
            return parentBucketPath.itemIndex / pointersSize * pointersSize;
        }
        return (parentBucketPath.itemIndex - 128) / pointersSize * pointersSize + 128;
    }

    private void addNewLevelNode(BucketPath bucketPath, long[] node, long newBucketPointer, long updatedBucketPointer) {
        int newNodeStartIndex;
        int mapInterval;
        int newNodeDepth;
        int maxDepth;
        long[] newNode = new long[256];
        if (bucketPath.itemIndex < node.length / 2) {
            maxDepth = this.nodesMetadata[bucketPath.nodeIndex].getMaxLeftChildDepth();
            assert (this.getMaxLevelDepth(node, 0, node.length / 2) == maxDepth);
            newNodeDepth = maxDepth > 0 ? maxDepth : 1;
            mapInterval = 1 << 8 - newNodeDepth;
            newNodeStartIndex = bucketPath.itemIndex / mapInterval * mapInterval;
        } else {
            maxDepth = this.nodesMetadata[bucketPath.nodeIndex].getMaxRightChildDepth();
            assert (this.getMaxLevelDepth(node, node.length / 2, node.length) == maxDepth);
            newNodeDepth = maxDepth > 0 ? maxDepth : 1;
            mapInterval = 1 << 8 - newNodeDepth;
            newNodeStartIndex = (bucketPath.itemIndex - node.length / 2) / mapInterval * mapInterval + node.length / 2;
        }
        int newNodeIndex = this.addNewNode(newNode, newNodeDepth);
        int mapSize = 1 << newNodeDepth;
        int i = 0;
        while (i < mapInterval) {
            int n;
            int nodeOffset = i + newNodeStartIndex;
            long bucketPointer = node[nodeOffset];
            if (nodeOffset != bucketPath.itemIndex) {
                n = i << newNodeDepth;
                while (n < i + 1 << newNodeDepth) {
                    newNode[n] = bucketPointer;
                    ++n;
                }
            } else {
                n = i << newNodeDepth;
                while (n < 2 * i + 1 << newNodeDepth - 1) {
                    newNode[n] = updatedBucketPointer;
                    ++n;
                }
                n = 2 * i + 1 << newNodeDepth - 1;
                while (n < i + 1 << newNodeDepth) {
                    newNode[n] = newBucketPointer;
                    ++n;
                }
            }
            node[nodeOffset] = (long)(newNodeIndex << 8 | i * mapSize) | Long.MIN_VALUE;
            ++i;
        }
        this.updateMaxChildDepth(bucketPath, newNodeDepth);
    }

    private int getMaxLevelDepth(long[] node, int start, int end) {
        int currentIndex = -1;
        int maxDepth = 0;
        int i = start;
        while (i < end) {
            int index;
            long nodePosition = node[i];
            if (nodePosition < 0L && (index = (int)((nodePosition & Long.MAX_VALUE) >>> 8)) != currentIndex) {
                currentIndex = index;
                if (maxDepth < this.nodesMetadata[index].getNodeLocalDepth()) {
                    maxDepth = this.nodesMetadata[index].getNodeLocalDepth();
                }
            }
            ++i;
        }
        return maxDepth;
    }

    private void updateNodeAfterBucketSplit(BucketPath bucketPath, int bucketDepth, long newBucketPointer, long updatedBucketPointer) {
        int firstEndIndex;
        int offset = bucketPath.nodeGlobalDepth - (bucketDepth - 1);
        BucketPath currentNode = bucketPath;
        int nodeLocalDepth = bucketPath.nodeLocalDepth;
        while (offset > 0) {
            if ((offset -= nodeLocalDepth) <= 0) continue;
            currentNode = bucketPath.parent;
            nodeLocalDepth = currentNode.nodeLocalDepth;
        }
        int diff = bucketDepth - 1 - (currentNode.nodeGlobalDepth - nodeLocalDepth);
        int interval = 1 << nodeLocalDepth - diff - 1;
        int firstStartIndex = currentNode.itemIndex & (255 << nodeLocalDepth - diff & 0xFF);
        int secondStartIndex = firstEndIndex = firstStartIndex + interval;
        int secondEndIndex = secondStartIndex + interval;
        int i = firstStartIndex;
        while (i < firstEndIndex) {
            this.updateBucket(currentNode.nodeIndex, i, currentNode.hashMapOffset, updatedBucketPointer);
            ++i;
        }
        i = secondStartIndex;
        while (i < secondEndIndex) {
            this.updateBucket(currentNode.nodeIndex, i, currentNode.hashMapOffset, newBucketPointer);
            ++i;
        }
    }

    private int addNewNode(long[] newNode, int nodeLocalDepth) {
        if (this.hashTreeTombstone >= 0) {
            long[] tombstone = this.hashTree[this.hashTreeTombstone];
            this.hashTree[this.hashTreeTombstone] = newNode;
            this.nodesMetadata[this.hashTreeTombstone] = new OHashTreeNodeMetadata(0, 0, (byte)nodeLocalDepth);
            int nodeIndex = this.hashTreeTombstone;
            this.hashTreeTombstone = tombstone != null ? (int)tombstone[0] : -1;
            return nodeIndex;
        }
        if (this.hashTreeSize >= this.hashTree.length) {
            long[][] newHashTree = new long[this.hashTree.length << 1][];
            System.arraycopy(this.hashTree, 0, newHashTree, 0, this.hashTree.length);
            this.hashTree = newHashTree;
            newHashTree = null;
            OHashTreeNodeMetadata[] newNodeMetadata = new OHashTreeNodeMetadata[this.nodesMetadata.length << 1];
            System.arraycopy(this.nodesMetadata, 0, newNodeMetadata, 0, this.nodesMetadata.length);
            this.nodesMetadata = newNodeMetadata;
            newNodeMetadata = null;
        }
        this.hashTree[this.hashTreeSize] = newNode;
        this.nodesMetadata[this.hashTreeSize] = new OHashTreeNodeMetadata(0, 0, (byte)nodeLocalDepth);
        ++this.hashTreeSize;
        return this.hashTreeSize - 1;
    }

    private boolean checkAllMapsContainSameBucket(long[] newNode, int hashMapSize) {
        boolean allHashMapsEquals = true;
        block0: for (int n = 0; n < newNode.length; n += hashMapSize) {
            boolean allHashBucketEquals = true;
            int i = 0;
            while (i < hashMapSize - 1) {
                if (newNode[i + n] != newNode[i + n + 1]) {
                    allHashBucketEquals = false;
                    continue block0;
                }
                ++i;
            }
            if (allHashBucketEquals) continue;
            allHashMapsEquals = false;
            break;
        }
        assert (this.assertAllNodesAreFilePointers(allHashMapsEquals, newNode, hashMapSize));
        return allHashMapsEquals;
    }

    private boolean assertAllNodesAreFilePointers(boolean allHashMapsEquals, long[] newNode, int hashMapSize) {
        if (allHashMapsEquals) {
            int n = 0;
            while (n < newNode.length) {
                int i = 0;
                while (i < hashMapSize) {
                    if (newNode[i] < 0L) {
                        return false;
                    }
                    ++i;
                }
                n += hashMapSize;
            }
        }
        return true;
    }

    private NodeSplitResult splitNode(BucketPath bucketPath, long[] node) {
        long[] newNode = new long[256];
        int hashMapSize = 1 << bucketPath.nodeLocalDepth + 1;
        boolean hashMapItemsAreEqual = true;
        int mapCounter = 0;
        long firstPosition = -1L;
        int i = 128;
        while (i < 256) {
            long position = node[i];
            if (hashMapItemsAreEqual && mapCounter == 0) {
                firstPosition = position;
            }
            newNode[2 * (i - 128)] = position;
            newNode[2 * (i - 128) + 1] = position;
            if (hashMapItemsAreEqual) {
                boolean bl = hashMapItemsAreEqual = firstPosition == position;
                if ((mapCounter += 2) >= hashMapSize) {
                    mapCounter = 0;
                }
            }
            ++i;
        }
        mapCounter = 0;
        boolean allRightItemsAreEqual = hashMapItemsAreEqual;
        hashMapItemsAreEqual = true;
        long[] updatedNode = new long[node.length];
        int i2 = 0;
        while (i2 < 128) {
            long position = node[i2];
            if (hashMapItemsAreEqual && mapCounter == 0) {
                firstPosition = position;
            }
            updatedNode[2 * i2] = position;
            updatedNode[2 * i2 + 1] = position;
            if (hashMapItemsAreEqual) {
                boolean bl = hashMapItemsAreEqual = firstPosition == position;
                if ((mapCounter += 2) >= hashMapSize) {
                    mapCounter = 0;
                }
            }
            ++i2;
        }
        boolean allLeftItemsAreEqual = hashMapItemsAreEqual;
        this.nodesMetadata[bucketPath.nodeIndex].incrementLocalNodeDepth();
        this.hashTree[((BucketPath)bucketPath).nodeIndex] = updatedNode;
        return new NodeSplitResult(newNode, allLeftItemsAreEqual, allRightItemsAreEqual);
    }

    private void deleteNode(int nodeIndex) {
        if (nodeIndex == this.hashTreeSize - 1) {
            this.hashTree[nodeIndex] = null;
            this.nodesMetadata[nodeIndex] = null;
            --this.hashTreeSize;
            return;
        }
        if (this.hashTreeTombstone > -1) {
            long[] tombstone = new long[]{this.hashTreeTombstone};
            this.hashTree[nodeIndex] = tombstone;
            this.hashTreeTombstone = nodeIndex;
        } else {
            this.hashTree[nodeIndex] = null;
            this.hashTreeTombstone = nodeIndex;
        }
        this.nodesMetadata[nodeIndex] = null;
    }

    private void splitBucketContent(OHashIndexBucket<K, V> bucket, OHashIndexBucket<K, V> updatedBucket, OHashIndexBucket<K, V> newBucket, int newBucketDepth) {
        assert (this.checkBucketDepth(bucket));
        for (OHashIndexBucket.Entry<K, V> entry : bucket) {
            if ((this.keyHashFunction.hashCode(entry.key) >>> 64 - newBucketDepth & 1L) == 0L) {
                updatedBucket.appendEntry(entry.key, entry.value);
                continue;
            }
            newBucket.appendEntry(entry.key, entry.value);
        }
        updatedBucket.setDepth(newBucketDepth);
        newBucket.setDepth(newBucketDepth);
        assert (this.checkBucketDepth(updatedBucket));
        assert (this.checkBucketDepth(newBucket));
    }

    private BucketSplitResult splitBucket(OHashIndexBucket<K, V> bucket, int fileLevel, long pageIndex, long pagePointer) throws IOException {
        long updatedBucketIndex;
        long tombstoneIndex;
        int bucketDepth = bucket.getDepth();
        int newBucketDepth = bucketDepth + 1;
        int newFileLevel = newBucketDepth - 8;
        OHashIndexFileLevelMetadata newFileMetadata = this.filesMetadata[newFileLevel];
        if (newFileMetadata == null) {
            this.filesMetadata[newFileLevel] = newFileMetadata = this.createFileMetadata(newFileLevel);
        }
        if ((tombstoneIndex = newFileMetadata.getTombstoneIndex()) >= 0L) {
            long tombstonePagePointer = this.loadPage(tombstoneIndex, newFileLevel);
            try {
                OHashIndexBucket<K, V> tombstone = new OHashIndexBucket<K, V>(tombstonePagePointer, this.directMemory, this.keySerializer, this.valueSerializer);
                newFileMetadata.setTombstoneIndex(tombstone.getNextRemovedBucketPair());
                updatedBucketIndex = tombstoneIndex;
            }
            finally {
                this.releasePage(tombstoneIndex, newFileLevel);
            }
        } else {
            updatedBucketIndex = this.buffer.getFilledUpTo(this.fileLevelIds[newFileLevel]);
        }
        long newBucketIndex = updatedBucketIndex + 1L;
        long updatedBucketDataPointer = this.loadPage(updatedBucketIndex, newFileLevel);
        try {
            long newBucketDataPointer = this.loadPage(newBucketIndex, newFileLevel);
            try {
                OHashIndexBucket<K, V> updatedBucket = new OHashIndexBucket<K, V>(newBucketDepth, updatedBucketDataPointer, this.directMemory, this.keySerializer, this.valueSerializer);
                OHashIndexBucket<K, V> newBucket = new OHashIndexBucket<K, V>(newBucketDepth, newBucketDataPointer, this.directMemory, this.keySerializer, this.valueSerializer);
                this.splitBucketContent(bucket, updatedBucket, newBucket, newBucketDepth);
                assert (bucket.getDepth() == bucketDepth);
                OHashIndexFileLevelMetadata bufferMetadata = this.filesMetadata[fileLevel];
                bufferMetadata.setBucketsCount(bufferMetadata.getBucketsCount() - 1L);
                assert (bufferMetadata.getBucketsCount() >= 0L);
                updatedBucket.setSplitHistory(fileLevel, pageIndex);
                newBucket.setSplitHistory(fileLevel, pageIndex);
                newFileMetadata.setBucketsCount(newFileMetadata.getBucketsCount() + 2L);
                long updatedBucketPointer = this.createBucketPointer(updatedBucketIndex, newFileLevel);
                long newBucketPointer = this.createBucketPointer(newBucketIndex, newFileLevel);
                BucketSplitResult bucketSplitResult = new BucketSplitResult(updatedBucketPointer, newBucketPointer, newBucketDepth);
                this.markPageAsDirty(newBucketIndex, newFileLevel);
                this.releasePage(newBucketIndex, newFileLevel);
                return bucketSplitResult;
            }
            catch (Throwable throwable) {
                this.markPageAsDirty(newBucketIndex, newFileLevel);
                this.releasePage(newBucketIndex, newFileLevel);
                throw throwable;
            }
        }
        finally {
            this.markPageAsDirty(updatedBucketIndex, newFileLevel);
            this.releasePage(updatedBucketIndex, newFileLevel);
        }
    }

    private boolean checkBucketDepth(OHashIndexBucket<K, V> bucket) {
        int bucketDepth = bucket.getDepth();
        if (bucket.size() == 0) {
            return true;
        }
        Iterator<OHashIndexBucket.Entry<K, V>> positionIterator = bucket.iterator();
        long firstValue = this.keyHashFunction.hashCode(positionIterator.next().key) >>> 64 - bucketDepth;
        while (positionIterator.hasNext()) {
            long value = this.keyHashFunction.hashCode(positionIterator.next().key) >>> 64 - bucketDepth;
            if (value == firstValue) continue;
            return false;
        }
        return true;
    }

    private void updateBucket(int nodeIndex, int itemIndex, int offset, long newBucketPointer) {
        long[] node = this.hashTree[nodeIndex];
        long position = node[itemIndex + offset];
        if (position >= 0L) {
            node[itemIndex + offset] = newBucketPointer;
        } else {
            int childNodeIndex = (int)((position & Long.MAX_VALUE) >>> 8);
            int childOffset = (int)(position & 0xFFL);
            int childNodeDepth = this.nodesMetadata[childNodeIndex].getNodeLocalDepth();
            int interval = 1 << childNodeDepth;
            int i = 0;
            while (i < interval) {
                this.updateBucket(childNodeIndex, i, childOffset, newBucketPointer);
                ++i;
            }
        }
    }

    private void initHashTreeState() throws IOException {
        long pageIndex = 0L;
        while (pageIndex < 256L) {
            long pagePointer = this.loadPage(pageIndex, 0);
            try {
                OHashIndexBucket<K, V> oHashIndexBucket = new OHashIndexBucket<K, V>(8, pagePointer, this.directMemory, this.keySerializer, this.valueSerializer);
            }
            finally {
                this.markPageAsDirty(pageIndex, 0);
                this.releasePage(pageIndex, 0);
            }
            ++pageIndex;
        }
        long[] rootTree = new long[256];
        int i = 0;
        while (i < 256) {
            rootTree[i] = this.createBucketPointer(i, 0);
            ++i;
        }
        this.hashTree = new long[1][];
        this.hashTree[0] = rootTree;
        this.nodesMetadata = new OHashTreeNodeMetadata[1];
        this.nodesMetadata[0] = new OHashTreeNodeMetadata(0, 0, 8);
        this.filesMetadata[0].setBucketsCount(256L);
        this.size = 0L;
        this.hashTreeSize = 1;
    }

    private long createBucketPointer(long pageIndex, int fileLevel) {
        return pageIndex + 1L << 8 | (long)fileLevel;
    }

    private long getPageIndex(long bucketPointer) {
        return (bucketPointer >>> 8) - 1L;
    }

    private int getFileLevel(long bucketPointer) {
        return (int)(bucketPointer & 0xFFL);
    }

    private void releasePage(long pageIndex, int fileLevel) {
        this.buffer.release(this.fileLevelIds[fileLevel], pageIndex);
    }

    private void markPageAsDirty(long pageIndex, int fileLevel) {
        this.buffer.markDirty(this.fileLevelIds[fileLevel], pageIndex);
    }

    private long loadPage(long pageIndex, int fileLevel) throws IOException {
        return this.buffer.load(this.fileLevelIds[fileLevel], pageIndex);
    }

    private BucketPath getBucket(long hashCode) {
        int localNodeDepth;
        int nodeDepth = localNodeDepth = this.nodesMetadata[0].getNodeLocalDepth();
        BucketPath parentNode = null;
        int nodeIndex = 0;
        int offset = 0;
        int index = (int)(hashCode >>> 64 - nodeDepth & (long)(255 >>> 8 - localNodeDepth));
        BucketPath currentNode = new BucketPath(parentNode, 0, index, 0, localNodeDepth, nodeDepth);
        do {
            long position;
            if ((position = this.hashTree[nodeIndex][index + offset]) >= 0L) {
                return currentNode;
            }
            nodeIndex = (int)((position & Long.MAX_VALUE) >>> 8);
            offset = (int)(position & 0xFFL);
            localNodeDepth = this.nodesMetadata[nodeIndex].getNodeLocalDepth();
            index = (int)(hashCode >>> 64 - (nodeDepth += localNodeDepth) & (long)(255 >>> 8 - localNodeDepth));
            parentNode = currentNode;
            currentNode = new BucketPath(parentNode, offset, index, nodeIndex, localNodeDepth, nodeDepth);
        } while (nodeDepth <= 64);
        throw new IllegalStateException("Extendible hashing tree in corrupted state.");
    }

    private static final class BucketPath {
        private final BucketPath parent;
        private final int hashMapOffset;
        private final int itemIndex;
        private final int nodeIndex;
        private final int nodeGlobalDepth;
        private final int nodeLocalDepth;

        private BucketPath(BucketPath parent, int hashMapOffset, int itemIndex, int nodeIndex, int nodeLocalDepth, int nodeGlobalDepth) {
            this.parent = parent;
            this.hashMapOffset = hashMapOffset;
            this.itemIndex = itemIndex;
            this.nodeIndex = nodeIndex;
            this.nodeGlobalDepth = nodeGlobalDepth;
            this.nodeLocalDepth = nodeLocalDepth;
        }
    }

    private static final class BucketSplitResult {
        private final long updatedBucketPointer;
        private final long newBucketPointer;
        private final int newDepth;

        private BucketSplitResult(long updatedBucketPointer, long newBucketPointer, int newDepth) {
            this.updatedBucketPointer = updatedBucketPointer;
            this.newBucketPointer = newBucketPointer;
            this.newDepth = newDepth;
        }
    }

    private static final class NodeSplitResult {
        private final long[] newNode;
        private final boolean allLeftHashMapsEqual;
        private final boolean allRightHashMapsEqual;

        private NodeSplitResult(long[] newNode, boolean allLeftHashMapsEqual, boolean allRightHashMapsEqual) {
            this.newNode = newNode;
            this.allLeftHashMapsEqual = allLeftHashMapsEqual;
            this.allRightHashMapsEqual = allRightHashMapsEqual;
        }
    }
}

