/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.intent;

import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.object.ODatabaseObject;
import com.orientechnologies.orient.core.db.raw.ODatabaseRaw;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.intent.OIntent;
import com.orientechnologies.orient.core.record.ORecordInternal;

public class OIntentMassiveInsert
implements OIntent {
    private boolean previousLevel1CacheEnabled;
    private boolean previousLevel2CacheEnabled;
    private boolean previousRetainRecords;
    private boolean previousRetainObjects;

    @Override
    public void begin(ODatabaseRaw iDatabase, Object ... iArgs) {
        this.previousLevel1CacheEnabled = iDatabase.getDatabaseOwner().getLevel1Cache().isEnabled();
        iDatabase.getDatabaseOwner().getLevel1Cache().setEnable(false);
        this.previousLevel2CacheEnabled = iDatabase.getDatabaseOwner().getLevel2Cache().isEnabled();
        iDatabase.getDatabaseOwner().getLevel2Cache().setEnable(false);
        ODatabaseComplex<ORecordInternal<?>> ownerDb = iDatabase.getDatabaseOwner();
        if (ownerDb instanceof ODatabaseRecord) {
            this.previousRetainRecords = ownerDb.isRetainRecords();
            ownerDb.setRetainRecords(false);
        }
        while (ownerDb.getDatabaseOwner() != ownerDb) {
            ownerDb = ownerDb.getDatabaseOwner();
        }
        if (ownerDb instanceof ODatabaseObject) {
            this.previousRetainObjects = ((ODatabaseObject)ownerDb).isRetainObjects();
            ((ODatabaseObject)ownerDb).setRetainObjects(false);
        }
    }

    @Override
    public void end(ODatabaseRaw iDatabase) {
        iDatabase.getDatabaseOwner().getLevel1Cache().setEnable(this.previousLevel1CacheEnabled);
        iDatabase.getDatabaseOwner().getLevel2Cache().setEnable(this.previousLevel2CacheEnabled);
        ODatabaseComplex<ORecordInternal<?>> ownerDb = iDatabase.getDatabaseOwner();
        if (ownerDb instanceof ODatabaseRecord) {
            ownerDb.setRetainRecords(this.previousRetainRecords);
        }
        while (ownerDb.getDatabaseOwner() != ownerDb) {
            ownerDb = ownerDb.getDatabaseOwner();
        }
        if (ownerDb instanceof ODatabaseObject) {
            ((ODatabaseObject)ownerDb).setRetainObjects(this.previousRetainObjects);
        }
    }
}

