/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.iterator;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.id.OClusterPosition;
import com.orientechnologies.orient.core.id.OClusterPositionFactory;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.iterator.OIterationException;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class OIdentifiableIterator<REC extends OIdentifiable>
implements Iterator<REC>,
Iterable<REC> {
    protected final ODatabaseRecord database;
    private final ODatabaseRecord lowLevelDatabase;
    private final OStorage dbStorage;
    protected boolean liveUpdated = false;
    protected long limit = -1L;
    protected long browsedRecords = 0L;
    private String fetchPlan;
    private ORecordInternal<?> reusedRecord = null;
    private Boolean directionForward;
    protected final ORecordId current = new ORecordId();
    protected long totalAvailableRecords;
    protected List<ORecordOperation> txEntries;
    protected int currentTxEntryPosition = -1;
    protected OClusterPosition firstClusterEntry = OClusterPositionFactory.INSTANCE.valueOf(0L);
    protected OClusterPosition lastClusterEntry = OClusterPositionFactory.INSTANCE.getMaxValue();
    private OClusterPosition currentEntry = OClusterPosition.INVALID_POSITION;
    private int currentEntryPosition = -1;
    private OPhysicalPosition[] positionsToProcess = null;
    private final boolean useCache;
    private final boolean iterateThroughTombstones;

    public OIdentifiableIterator(ODatabaseRecord iDatabase, ODatabaseRecord iLowLevelDatabase, boolean useCache, boolean iterateThroughTombstones) {
        this.database = iDatabase;
        this.lowLevelDatabase = iLowLevelDatabase;
        this.iterateThroughTombstones = iterateThroughTombstones;
        this.useCache = useCache;
        this.dbStorage = this.lowLevelDatabase.getStorage();
        this.current.clusterPosition = OClusterPosition.INVALID_POSITION;
    }

    public boolean isIterateThroughTombstones() {
        return this.iterateThroughTombstones;
    }

    public abstract boolean hasPrevious();

    public abstract OIdentifiable previous();

    public abstract OIdentifiableIterator<REC> begin();

    public abstract OIdentifiableIterator<REC> last();

    public ORecordInternal<?> current() {
        return this.readCurrentRecord(this.getRecord(), 0);
    }

    protected ORecordInternal<?> getTransactionEntry() {
        boolean noPhysicalRecordToBrowse;
        if (this.current.clusterPosition.isTemporary()) {
            noPhysicalRecordToBrowse = true;
        } else if (this.directionForward.booleanValue()) {
            noPhysicalRecordToBrowse = this.lastClusterEntry.compareTo(this.currentEntry) <= 0;
        } else {
            boolean bl = noPhysicalRecordToBrowse = this.currentEntry.compareTo(this.firstClusterEntry) <= 0;
        }
        if (!noPhysicalRecordToBrowse && this.positionsToProcess.length == 0) {
            noPhysicalRecordToBrowse = true;
        }
        if (noPhysicalRecordToBrowse && this.txEntries != null) {
            ++this.currentTxEntryPosition;
            if (this.currentTxEntryPosition >= this.txEntries.size()) {
                throw new NoSuchElementException();
            }
            return this.txEntries.get(this.currentTxEntryPosition).getRecord();
        }
        return null;
    }

    public String getFetchPlan() {
        return this.fetchPlan;
    }

    public void setFetchPlan(String fetchPlan) {
        this.fetchPlan = fetchPlan;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public boolean isReuseSameRecord() {
        return this.reusedRecord != null;
    }

    public OClusterPosition getCurrentEntry() {
        return this.currentEntry;
    }

    public OIdentifiableIterator<REC> setReuseSameRecord(boolean reuseSameRecord) {
        this.reusedRecord = reuseSameRecord ? this.database.newInstance() : null;
        return this;
    }

    protected ORecordInternal<?> getRecord() {
        ORecordInternal<?> record;
        if (this.reusedRecord != null) {
            record = this.reusedRecord;
            record.reset();
        } else {
            record = null;
        }
        return record;
    }

    @Override
    public Iterator<REC> iterator() {
        return this;
    }

    public long getLimit() {
        return this.limit;
    }

    public OIdentifiableIterator<REC> setLimit(long limit) {
        this.limit = limit;
        return this;
    }

    public boolean isLiveUpdated() {
        return this.liveUpdated;
    }

    public OIdentifiableIterator<REC> setLiveUpdated(boolean liveUpdated) {
        this.liveUpdated = liveUpdated;
        return this;
    }

    protected void checkDirection(boolean iForward) {
        if (this.directionForward == null) {
            this.directionForward = iForward;
        } else if (this.directionForward != iForward) {
            throw new OIterationException("Iterator cannot change direction while browsing");
        }
    }

    protected ORecordInternal<?> readCurrentRecord(ORecordInternal<?> iRecord, int iMovement) {
        if (this.limit > -1L && this.browsedRecords >= this.limit) {
            return null;
        }
        do {
            boolean moveResult;
            switch (iMovement) {
                case 1: {
                    moveResult = this.nextPosition();
                    break;
                }
                case -1: {
                    moveResult = this.prevPosition();
                    break;
                }
                case 0: {
                    moveResult = this.checkCurrentPosition();
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid movement value : " + iMovement);
                }
            }
            if (!moveResult) {
                return null;
            }
            try {
                if (iRecord != null) {
                    iRecord.setIdentity(new ORecordId(this.current.clusterId, this.current.clusterPosition));
                    iRecord = (ORecordInternal)this.lowLevelDatabase.load(iRecord, this.fetchPlan, !this.useCache, this.iterateThroughTombstones);
                } else {
                    iRecord = (ORecordInternal)this.lowLevelDatabase.load(this.current, this.fetchPlan, !this.useCache, this.iterateThroughTombstones);
                }
            }
            catch (ODatabaseException e) {
                if (Thread.interrupted()) {
                    throw e;
                }
                OLogManager.instance().error((Object)this, "Error on fetching record during browsing. The record has been skipped", (Throwable)((Object)e), new Object[0]);
            }
            if (iRecord == null) continue;
            ++this.browsedRecords;
            return iRecord;
        } while (iMovement != 0);
        return null;
    }

    protected boolean nextPosition() {
        if (this.positionsToProcess == null) {
            this.positionsToProcess = this.dbStorage.ceilingPhysicalPositions(this.current.clusterId, new OPhysicalPosition(this.firstClusterEntry));
            if (this.positionsToProcess == null) {
                return false;
            }
        } else if (this.currentEntry.compareTo(this.lastClusterEntry) >= 0) {
            return false;
        }
        this.incrementEntreePosition();
        while (this.positionsToProcess.length > 0 && this.currentEntryPosition >= this.positionsToProcess.length) {
            this.positionsToProcess = this.dbStorage.higherPhysicalPositions(this.current.clusterId, this.positionsToProcess[this.positionsToProcess.length - 1]);
            this.currentEntryPosition = -1;
            this.incrementEntreePosition();
        }
        if (this.positionsToProcess.length == 0) {
            return false;
        }
        this.currentEntry = this.positionsToProcess[this.currentEntryPosition].clusterPosition;
        if (this.currentEntry.compareTo(this.lastClusterEntry) > 0 || this.currentEntry.equals(OClusterPosition.INVALID_POSITION)) {
            return false;
        }
        this.current.clusterPosition = this.currentEntry;
        return true;
    }

    protected boolean checkCurrentPosition() {
        if (this.currentEntry == null || this.currentEntry.equals(OClusterPosition.INVALID_POSITION) || this.firstClusterEntry.compareTo(this.currentEntry) > 0 || this.lastClusterEntry.compareTo(this.currentEntry) < 0) {
            return false;
        }
        this.current.clusterPosition = this.currentEntry;
        return true;
    }

    protected boolean prevPosition() {
        if (this.positionsToProcess == null) {
            this.positionsToProcess = this.dbStorage.floorPhysicalPositions(this.current.clusterId, new OPhysicalPosition(this.lastClusterEntry));
            if (this.positionsToProcess == null) {
                return false;
            }
            if (this.positionsToProcess.length == 0) {
                return false;
            }
            this.currentEntryPosition = this.positionsToProcess.length;
        } else if (this.currentEntry.compareTo(this.firstClusterEntry) < 0) {
            return false;
        }
        this.decrementEntreePosition();
        while (this.positionsToProcess.length > 0 && this.currentEntryPosition < 0) {
            this.positionsToProcess = this.dbStorage.lowerPhysicalPositions(this.current.clusterId, this.positionsToProcess[0]);
            this.currentEntryPosition = this.positionsToProcess.length;
            this.decrementEntreePosition();
        }
        if (this.positionsToProcess.length == 0) {
            return false;
        }
        this.currentEntry = this.positionsToProcess[this.currentEntryPosition].clusterPosition;
        if (this.currentEntry.compareTo(this.firstClusterEntry) < 0) {
            return false;
        }
        this.current.clusterPosition = this.currentEntry;
        return true;
    }

    private void decrementEntreePosition() {
        if (this.positionsToProcess.length > 0) {
            if (this.iterateThroughTombstones) {
                --this.currentEntryPosition;
            } else {
                do {
                    --this.currentEntryPosition;
                } while (this.currentEntryPosition >= 0 && this.positionsToProcess[this.currentEntryPosition].recordVersion.isTombstone());
            }
        }
    }

    private void incrementEntreePosition() {
        if (this.positionsToProcess.length > 0) {
            if (this.iterateThroughTombstones) {
                ++this.currentEntryPosition;
            } else {
                do {
                    ++this.currentEntryPosition;
                } while (this.currentEntryPosition < this.positionsToProcess.length && this.positionsToProcess[this.currentEntryPosition].recordVersion.isTombstone());
            }
        }
    }

    protected void resetCurrentPosition() {
        this.currentEntry = OClusterPosition.INVALID_POSITION;
        this.positionsToProcess = null;
        this.currentEntryPosition = -1;
    }

    protected OClusterPosition currentPosition() {
        return this.currentEntry;
    }
}

