/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.iterator;

import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordAbstract;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClusters;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;

public class ORecordIteratorClass<REC extends ORecordInternal<?>>
extends ORecordIteratorClusters<REC> {
    protected final OClass targetClass;
    protected boolean polymorphic;
    protected boolean useCache;

    public ORecordIteratorClass(ODatabaseRecord iDatabase, ODatabaseRecordAbstract iLowLevelDatabase, String iClassName, boolean iPolymorphic) {
        this(iDatabase, iLowLevelDatabase, iClassName, iPolymorphic, true, false);
    }

    public ORecordIteratorClass(ODatabaseRecord iDatabase, ODatabaseRecord iLowLevelDatabase, String iClassName, boolean iPolymorphic) {
        this(iDatabase, iLowLevelDatabase, iClassName, iPolymorphic, true, false);
    }

    public ORecordIteratorClass(ODatabaseRecord iDatabase, ODatabaseRecord iLowLevelDatabase, String iClassName, boolean iPolymorphic, boolean iUseCache, boolean iterateThroughTombstones) {
        super(iDatabase, iLowLevelDatabase, iUseCache, iterateThroughTombstones);
        this.targetClass = this.database.getMetadata().getSchema().getClass(iClassName);
        if (this.targetClass == null) {
            throw new IllegalArgumentException("Class '" + iClassName + "' was not found in database schema");
        }
        this.polymorphic = iPolymorphic;
        this.clusterIds = this.polymorphic ? this.targetClass.getPolymorphicClusterIds() : this.targetClass.getClusterIds();
        this.clusterIds = OClassImpl.readableClusters(iDatabase, this.clusterIds);
        this.config();
    }

    @Override
    public REC next() {
        Object rec = super.next();
        if (rec == null) {
            return null;
        }
        return (REC)((ORecordInternal)rec.getRecord());
    }

    @Override
    public REC previous() {
        OIdentifiable rec = super.previous();
        if (rec == null) {
            return null;
        }
        return (REC)((ORecordInternal)rec.getRecord());
    }

    @Override
    protected boolean include(ORecord<?> record) {
        return record instanceof ODocument && this.targetClass.isSuperClassOf(((ODocument)record).getSchemaClass());
    }

    public boolean isPolymorphic() {
        return this.polymorphic;
    }

    @Override
    public String toString() {
        return String.format("ORecordIteratorClass.targetClass(%s).polymorphic(%s)", this.targetClass, this.polymorphic);
    }
}

